#!/software/python-3.6.2/gcc/bin/python
# in this script we create the directories with tetramer.xyz files
# a list of tetramers needs to be provided

import os
import mbe
import importlib; importlib.reload(mbe)

#read the unit cell
cell=mbe.read_cell('../input/cell')

#load the monomers
coord, elems=mbe.read_monomers_uni('../input')

#read the list of dimers
with open('dist_generate_py/sym_sort_shell6_ref0.dat') as f:
   calc_all=f.readlines()

idx=0
#loop over dimers
for calc_line in calc_all:
   print(idx)
   #get the directory
   calc_dir=calc_line.split()[0]
   #divide it into individual monomer directories
   dir_spl=calc_dir.split('/')
   dir_str=''
   dim_struc=[]
   #create the directory if it does not exist
   #TODO do not create the dimer if it already exists
   for dir_act in dir_spl[0:2]:
      dir_str+=dir_act+'/'
      if os.path.isdir(dir_str):
         print('dir exists '+dir_str)
      else:
         print('dir does not exist '+dir_str)
         os.mkdir(dir_str)
      #get the actual shift from the directory name
      vec=mbe.get_dir_vec(dir_act)
      #store the monomer structure in the unit cell in the mono object
      mono=coord[vec[3],:,:].copy()
      #shift the monomer according to the shift
      mono_shifted=mbe.mono_shift_vec(mono,vec[0:3],cell)
      #create the dimer structure
      for i in range(mono.shape[0]):
         dim_struc.append([elems[vec[3]][i],' '.join(map(str,mono_shifted[i,:]))])
   #print the trimer structure to a file
   with open(dir_str+'dimer.xyz','w+') as f:
      f.write(str(len(dim_struc))+'\n')
      f.write('generated with py\n')
      for lines in dim_struc:
         f.write(lines[0]+' '+lines[1]+'\n')
   
   idx+=1
   #if idx>10:
   #   break

