##############################################################
## generate the tetramers according to a distance criterion ##
##############################################################

import mbe
import numpy as np
import os
import importlib; importlib.reload(mbe)

#read the unit cell
cell=mbe.read_cell('../../input/cell')

#load the monomers
coord, elems=mbe.read_monomers_uni('../../input')

#print(coord)

#read the monomer list, i.e. the list with 
#index shell x y z nmono
#mlist=mbe.read_list('list_8787.dat')

#alternatively, generate the list of monomers on the fly
#each item holds: index shell x y z nmono
#indices start from 0 for the 0 0 0 0 0 molecule
mlist=mbe.gen_list(6,coord.shape[0])

mbe.sift_nmer_list('sort_shell6_ref0.dat',mlist,coord,elems,cell)

