from lab.reports import Attribute, geometric_mean

def get():
    symmetrical_states = Attribute('symmetrical_states', absolute=False, min_wins=False)
    improved_evaluations = Attribute('improved_evaluations', absolute=False, min_wins=False)
    improving_states = Attribute('improving_states', absolute=False, min_wins=False)
    symmetrical_states_per_evaluation = Attribute('symmetrical_states_per_evaluation', absolute=False, min_wins=False)
    last_jump_symmetrical_states = Attribute('last_jump_symmetrical_states', absolute=False, min_wins=False)
    last_jump_improved_evaluations = Attribute('last_jump_improved_evaluations', absolute=False, min_wins=False)
    last_jump_improving_states = Attribute('last_jump_improving_states', absolute=False, min_wins=False)
    last_jump_symmetrical_states_per_evaluation = Attribute('last_jump_symmetrical_states_per_evaluation', absolute=False, min_wins=False)
    generators_count = Attribute('generators_count', absolute=False, min_wins=False)
    generators_orders = Attribute('generators_orders', absolute=True, min_wins=False)
    time_symmetries = Attribute('time_symmetries', absolute=False, min_wins=True, functions=[geometric_mean])

    attributes = [
        symmetrical_states,
        improved_evaluations,
        improving_states,
        symmetrical_states_per_evaluation,
        last_jump_symmetrical_states,
        last_jump_improved_evaluations,
        last_jump_improving_states,
        last_jump_symmetrical_states_per_evaluation,
        generators_count,
        generators_orders,
        time_symmetries,
    ]

    return attributes
