from lab.reports import Attribute, arithmetic_mean

def get():
    number_of_applied_symmetries = Attribute('number_of_applied_symmetries', absolute=False, min_wins=False)
    bliss_time_average = Attribute('bliss_time_average', absolute=False, min_wins=True, functions=[arithmetic_mean])
    bliss_time_median = Attribute('bliss_time_median', absolute=False, min_wins=True, functions=[arithmetic_mean])
    bliss_memory_out = Attribute('bliss_memory_out', absolute=True, min_wins=True)
    bliss_timeout = Attribute('bliss_timeout', absolute=True, min_wins=True)
    bliss_total_calls = Attribute('bliss_total_calls', absolute=False, min_wins=False)
    fallback_only = Attribute('fallback_only', absolute=True, min_wins=True)
    merging_for_symmetries_attempts = Attribute('merging_for_symmetries_attempts', absolute=True, min_wins=False)
    merging_for_symmetries_fail_shrinking = Attribute('merging_for_symmetries_fail_shrinking', absolute=True, min_wins=True)
    merging_for_symmetries_fail_pruning = Attribute('merging_for_symmetries_fail_pruning', absolute=True, min_wins=True)
    merging_for_symmetries_fail_any = Attribute('merging_for_symmetries_fail_any', absolute=True, min_wins=True)
    merging_for_symmetries_success_ratio_shrinking = Attribute('merging_for_symmetries_success_ratio_shrinking', absolute=False, min_wins=False, functions=[arithmetic_mean])
    merging_for_symmetries_success_ratio_pruning = Attribute('merging_for_symmetries_success_ratio_pruning', absolute=False, min_wins=False, functions=[arithmetic_mean])
    merging_for_symmetries_success_ratio_any = Attribute('merging_for_symmetries_success_ratio_any', absolute=False, min_wins=False, functions=[arithmetic_mean])

    attributes = [
        number_of_applied_symmetries,
        bliss_time_average,
        bliss_time_median,
        bliss_memory_out,
        bliss_timeout,
        bliss_total_calls,
        fallback_only,
        merging_for_symmetries_attempts,
        merging_for_symmetries_fail_shrinking,
        merging_for_symmetries_fail_pruning,
        merging_for_symmetries_fail_any,
        merging_for_symmetries_success_ratio_shrinking,
        merging_for_symmetries_success_ratio_pruning,
        merging_for_symmetries_success_ratio_any,
    ]

    return attributes
