#! /usr/bin/env python

import os
import argparse
from collections import defaultdict
import sys

from lab import tools

revisions = [
    '34fdb310acb3', # olr, sota: b50k-dfp,/-symm, b50k-miasm-and-linear
    'a7b231dd8d46', # nlr
    '03fd6f9716fa', # sota: oss-sl-symm
    'acbb58c01fc8', # sota: b50k-pruning-pirr *, f50k*, ginf*
    'd80160ef986e', # sota: b50k-pruning-abs/reg, b50k-sbmiasm, b50k-sccs*, b50k-symm
]

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--dirs', nargs='+', help='the dirs that should be checked')
    args = parser.parse_args()
    if not args.dirs:
        print "You must provide at least one dir which should be checked"
        sys.exit(1)

    print "Supplied dirs:"
    for d in args.dirs:
        print os.path.abspath(d)

    algonick_to_options = {} # without revision
    algorithms = set() # full algorithm with revision
    domain_tasks = set()
    dir_to_keys_with_no_error = defaultdict(list)
    for d in args.dirs:
        print "checking {}".format(os.path.abspath(d))
        props = tools.Properties(filename=os.path.abspath(os.path.join(d, 'properties')))

        for key, run in props.items():
            if 'error' not in run:
                dir_to_keys_with_no_error[d].append(key)
                algorithm = run['algorithm'].encode('utf-8')
                algorithms.add(algorithm)
                for rev in revisions:
                    algorithm = algorithm.replace('{}-'.format(rev), '')
                component_options = []
                for option in run['component_options']:
                    component_options.append(option.encode('utf-8'))
                if algorithm in algonick_to_options:
                    assert algonick_to_options[algorithm] == component_options
                else:
                    algonick_to_options[algorithm] = component_options
                domain_tasks.add('{}:{}'.format(run['domain'], run['problem']))
    for d, keys in dir_to_keys_with_no_error.items():
        if len(keys) > 0:
            print "no error attribute in the following keys of {}".format(os.path.abspath(os.path.join(d, 'properties')))
            for key in keys:
                print key

    print "need to re-run the following configs:"
    print algonick_to_options
    print "on the following domain:tasks"
    print sorted(list(domain_tasks))
    print "list of algorihms"
    print sorted(list(algonick_to_options.keys()))

if __name__ == "__main__":
    main()
