#! /usr/bin/env python

from tools.my_experiment import MyExperiment

import exit_reason_parser_attributes

# Set the following variables for the experiment
REPO_NAME = 'downward/cegar-sdac'
REVISIONS = ['ded8e586e605']

CONFIGS = {
    'pdb': ['--search', 'astar(pdb(pattern=greedy))'],
    'ipdb900': ['--search', 'astar(cpdbs(patterns=hillclimbing(max_time=900)))'],
    'cegar': ['--search', 'astar(saturated_cost_partitioning([projections(hillclimbing(max_time=60)), projections(systematic(2)), cartesian()], orders=greedy(max_time=200, max_orders=infinity, diversify=true, max_optimization_time=1)))'],
}

# Create the experiment. Add parsers, fetchers or reports...
exp = MyExperiment(
    repo_name=REPO_NAME,
    configs=CONFIGS,
    revisions=REVISIONS,
    test_suite=['depot:p01.pddl', 'depot:p02.pddl', 'gripper:prob01.pddl', 'gripper:prob02.pddl', 'mystery:prob07.pddl'],
)
exp.add_search_parser('../exit-reason-parser.py', exit_reason_parser_attributes.get())

exp.add_absolute_report()

exp.run_steps()
