#! /usr/bin/env python

from tools.my_experiment import MyExperiment
import ms_parser_attributes
import sys
sys.path.insert(1, '../merge-strategies')
import merge_strategies_attributes
import miasm_attributes
import symmetries_attributes
sys.path.insert(1, '../symmetric-lookups')
import symmetries_parser_attributes

# Set the following variables for the experiment
REPO_NAME = 'downward/diss'
REVISIONS = ['81ab07c70f65']

CONFIGS = {'b50k-l-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=level)),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-dfp-rnd-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_fh,max_states=50000),total_order(atomic_ts_order=random,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-dfp-rnd-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-sbmiasm-rl-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=reverse_level,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmb60l-largest-secondary-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=secondary),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-dfp-allrnd-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,single_random])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-sbmiasm-l-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-gcgl-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=goal_cg_level)),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-dfp-l-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-dfp-l-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-sbmiasm-l-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=level,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-l-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_tree=linear(variable_order=level)),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-dfp-rnd-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_fh,max_states=50000),total_order(atomic_ts_order=random,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-sbmiasm-rl-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=reverse_level,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-dfp-rnd-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-dfp-rnd-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-sbmiasm-l-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=level,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmb60sbmiasm-rl-nto-pba-largest-secondary-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_symmetries(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=secondary),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-sbmiasm-rnd-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=random,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmi1sbmiasm-rl-nto-pba-largest-secondary-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_symmetries(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]),stabilize_transition_systems=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,symmetries_for_merging=largest,internal_merging=secondary),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-sbmiasm-rl-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmb60dfp-l-nto-abp-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_symmetries(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-inc-dfp-rnd-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=increasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-symmb60dfp-rl-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_symmetries(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-dfp-l-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-symmb60cggl-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=cg_goal_level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),shrink_strategy=shrink_fh,label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-dfp-rnd-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-dfp-allrnd-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,single_random])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-sbmiasm-rl-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmi1gcgl-largest-secondary-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=goal_cg_level),stabilize_transition_systems=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,symmetries_for_merging=largest,internal_merging=secondary),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-dfp-rnd-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-dfp-l-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_fh,max_states=50000),total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-dfp-l-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-symmb60miasm-dfp-rl-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_symmetries(merge_tree=miasm(abstraction=miasm_merge_and_shrink(),fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-rl-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_tree=linear(variable_order=reverse_level)),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-dfp-rl-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-dfp-rl-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-symmb60rl-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=reverse_level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),shrink_strategy=shrink_fh,label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-inc-dfp-allrnd-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=increasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,single_random])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-dfp-l-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-sbmiasm-l-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-dfp-rl-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-dfp-rl-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-cggl-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=cg_goal_level)),shrink_strategy=shrink_fh,label_reduction=exact(before_shrinking=false,before_merging=true,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-dfp-rnd-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-dfp-allrnd-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_fh,max_states=50000),single_random])),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-dfp-rl-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-dfp-rnd-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-sbmiasm-rnd-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=random,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-dfp-rnd-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-dfp-rl-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_fh,max_states=50000),total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-dfp-l-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmi1l-largest-secondary-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=level),stabilize_transition_systems=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,symmetries_for_merging=largest,internal_merging=secondary),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-rl-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=reverse_level)),shrink_strategy=shrink_bisimulation(greedy=true),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmi1sbmiasm-rl-nto-pba-smallest-secondary-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_symmetries(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]),stabilize_transition_systems=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,symmetries_for_merging=smallest,internal_merging=secondary),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-dfp-rnd-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_fh,max_states=50000),total_order(atomic_ts_order=random,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-symmb60rl-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=reverse_level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),shrink_strategy=shrink_bisimulation(greedy=true),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-sbmiasm-l-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'symmb60miasm-dfp-rl-nto-pba-b50k-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_symmetries(merge_tree=miasm(abstraction=miasm_merge_and_shrink(),fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-dfp-rnd-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-inc-dfp-l-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=increasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-dfp-rl-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-inc-dfp-l-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=increasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-sbmiasm-rnd-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=random,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-sbmiasm-rnd-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=random,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-dfp-rnd-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-inc-dfp-rl-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=increasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'symmb60gcgl-b50k-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=goal_cg_level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-sbmiasm-l-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-dfp-rl-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-dfp-allrnd-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,single_random])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-dfp-rl-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-sbmiasm-l-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=level,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-dfp-rl-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-dfp-rnd-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-sbmiasm-rnd-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=random,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-sbmiasm-rl-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=reverse_level,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-symmb60miasm-dfp-l-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_symmetries(merge_tree=miasm(abstraction=miasm_merge_and_shrink(),fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=true)])),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-symmb60gcgl-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=goal_cg_level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),shrink_strategy=shrink_bisimulation(greedy=true),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmb60cggl-smallest-secondary-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=cg_goal_level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=smallest,internal_merging=secondary),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-dfp-l-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_fh,max_states=50000),total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-dfp-l-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_fh,max_states=50000),total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-sbmiasm-rl-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-inc-dfp-rl-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=increasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-dfp-rnd-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-dfp-rnd-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-dfp-rl-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-dfp-rl-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-rl-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=reverse_level)),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-dfp-rl-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-dfp-rnd-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_fh,max_states=50000),total_order(atomic_ts_order=random,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-sbmiasm-allrnd-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),single_random])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-symmb60gcgl-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=goal_cg_level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),shrink_strategy=shrink_fh,label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-dfp-l-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-sbmiasm-rnd-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=random,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-inc-rl-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=increasing,merge_tree=linear(variable_order=reverse_level)),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-dfp-rnd-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-inc-dfp-rnd-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=increasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-dfp-l-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_fh,max_states=50000),total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-dfp-rl-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_fh,max_states=50000),total_order(atomic_ts_order=reverse_level,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmb60dfp-rl-nto-pba-largest-secondary-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=secondary),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-dfp-rl-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-dfp-l-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-inc-dfp-rnd-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=increasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-dfp-rnd-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-dfp-l-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmb60rl-smallest-secondary-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=reverse_level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=smallest,internal_merging=secondary),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-dfp-rnd-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-dfp-l-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-slone5-dfp-rl-nto-pba-fprnd-pirr-reg': ['--symmetries', 'sym=structural_symmetries(time_bound=0,symmetrical_lookups=one_state,symmetry_rw_length_or_number_states=5)', '--heuristic', 'hmas=merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=false)', '--search', 'astar(sl_heuristic(component_heuristic=hmas,symmetries=sym))'],
'b50k-dfp-l-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmb60dfp-rl-nto-pba-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_symmetries(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-sbmiasm-allrnd-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),single_random])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-rl-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_tree=linear(variable_order=reverse_level)),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-dfp-rnd-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-dfp-rl-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-sbmiasm-l-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-inc-dfp-rl-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=increasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-dfp-l-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-dfp-rnd-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-dfp-rl-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_fh,max_states=50000),total_order(atomic_ts_order=reverse_level,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-symmb60miasm-dfp-l-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_symmetries(merge_tree=miasm(abstraction=miasm_merge_and_shrink(),fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=true)])),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-l-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_tree=linear(variable_order=level)),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-inc-l-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=increasing,merge_tree=linear(variable_order=level)),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-sbmiasm-l-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=level,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-inc-cggl-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=increasing,merge_tree=linear(variable_order=cg_goal_level)),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-inc-dfp-l-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=increasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'symmb60cggl-b50k-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=cg_goal_level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-symmb60miasm-dfp-rl-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_symmetries(merge_tree=miasm(abstraction=miasm_merge_and_shrink(),fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmi1dfp-rl-nto-pba-smallest-secondary-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]),stabilize_transition_systems=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,symmetries_for_merging=smallest,internal_merging=secondary),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-dfp-rl-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-sbmiasm-rnd-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=random,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-gcgl-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_tree=linear(variable_order=goal_cg_level)),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-dfp-rnd-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-sbmiasm-rl-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmb60gcgl-largest-secondary-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=goal_cg_level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=secondary),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-dfp-rl-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-sbmiasm-rl-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=reverse_level,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-inc-gcgl-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=increasing,merge_tree=linear(variable_order=goal_cg_level)),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-sbmiasm-rnd-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=random,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-sbmiasm-l-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-dfp-l-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-sbmiasm-rnd-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=random,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-sbmiasm-rl-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=reverse_level,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-sbmiasm-l-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-dfp-rl-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-sbmiasm-rl-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=reverse_level,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-dfp-l-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-sbmiasm-rl-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=reverse_level,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-sbmiasm-allrnd-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),single_random])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-dfp-rnd-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmi1dfp-rl-nto-pba-largest-secondary-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]),stabilize_transition_systems=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,symmetries_for_merging=largest,internal_merging=secondary),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-dfp-rl-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-dfp-l-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-inc-dfp-l-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=increasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-dfp-rl-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_fh,max_states=50000),total_order(atomic_ts_order=reverse_level,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-miasm-dfp-rl-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_precomputed(merge_tree=miasm(abstraction=miasm_merge_and_shrink,fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]))),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-dfp-rl-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-dfp-rnd-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_fh,max_states=50000),total_order(atomic_ts_order=random,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-l-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=level)),shrink_strategy=shrink_fh,label_reduction=exact(before_shrinking=false,before_merging=true,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-l-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=level)),shrink_strategy=shrink_bisimulation(greedy=true),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-inc-dfp-rl-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=increasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-sbmiasm-rnd-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=random,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmi1cggl-smallest-secondary-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=cg_goal_level),stabilize_transition_systems=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,symmetries_for_merging=smallest,internal_merging=secondary),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-dfp-allrnd-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,single_random])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-dfp-rl-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-dfp-rnd-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmb60rl-largest-secondary-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=reverse_level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=secondary),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-dfp-rl-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-rl-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=reverse_level)),shrink_strategy=shrink_fh,label_reduction=exact(before_shrinking=false,before_merging=true,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-sbmiasm-rnd-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=random,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmb60sbmiasm-rl-nto-pba-smallest-secondary-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_symmetries(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=smallest,internal_merging=secondary),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-dfp-rnd-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-sbmiasm-l-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=level,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-dfp-l-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_fh,max_states=50000),total_order(atomic_ts_order=level,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmi1cggl-largest-secondary-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=cg_goal_level),stabilize_transition_systems=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,symmetries_for_merging=largest,internal_merging=secondary),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-dfp-rl-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_fh,max_states=50000),total_order(atomic_ts_order=reverse_level,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-dfp-rl-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_fh,max_states=50000),total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-dfp-rl-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-dfp-rl-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-dfp-rl-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmi1rl-smallest-secondary-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=reverse_level),stabilize_transition_systems=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,symmetries_for_merging=smallest,internal_merging=secondary),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-dfp-l-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-inc-dfp-rnd-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=increasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-inc-dfp-rl-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=increasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmb60l-smallest-secondary-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=smallest,internal_merging=secondary),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-sbmiasm-rl-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-symmb60l-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),shrink_strategy=shrink_bisimulation(greedy=true),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-dfp-l-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-sbmiasm-l-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-dfp-l-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-dfp-rnd-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-dfp-rl-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-l-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_tree=linear(variable_order=level)),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'symmb60rl-b50k-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=reverse_level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-dfp-allrnd-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,single_random])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-dfp-l-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-inc-dfp-l-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=increasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-sbmiasm-rnd-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=random,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-cggl-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=cg_goal_level)),shrink_strategy=shrink_bisimulation(greedy=true),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-dfp-rl-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-miasm-dfp-l-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_precomputed(merge_tree=miasm(abstraction=miasm_merge_and_shrink,fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=true)]))),label_reduction=exact(before_shrinking=false,before_merging=true,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-inc-dfp-l-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=increasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-dfp-rnd-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-symmb60dfp-rl-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_symmetries(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-sbmiasm-rl-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=reverse_level,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-sbmiasm-l-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-dfp-rnd-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-dfp-rnd-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-dfp-l-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_fh,max_states=50000),total_order(atomic_ts_order=level,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-symmb60dfp-l-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_symmetries(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-cggl-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_tree=linear(variable_order=cg_goal_level)),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-sbmiasm-rl-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=reverse_level,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-gcgl-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_tree=linear(variable_order=goal_cg_level)),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-miasm-dfp-l-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_precomputed(merge_tree=miasm(abstraction=miasm_merge_and_shrink,fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=true)]))),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-sbmiasm-l-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-miasm-dfp-rl-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_precomputed(merge_tree=miasm(abstraction=miasm_merge_and_shrink,fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]))),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-dfp-rnd-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_fh,max_states=50000),total_order(atomic_ts_order=random,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmi1l-smallest-secondary-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=level),stabilize_transition_systems=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,symmetries_for_merging=smallest,internal_merging=secondary),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-inc-dfp-rnd-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=increasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-dfp-l-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'symmb60l-b50k-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-dfp-l-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-sbmiasm-rnd-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=random,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-dfp-l-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-sbmiasm-rl-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-inc-dfp-rnd-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=increasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmi1gcgl-smallest-secondary-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=goal_cg_level),stabilize_transition_systems=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,symmetries_for_merging=smallest,internal_merging=secondary),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-sbmiasm-rnd-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=random,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmi1dfp-l-nto-abp-largest-secondary-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=true)]),stabilize_transition_systems=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,symmetries_for_merging=largest,internal_merging=secondary),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-dfp-l-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-dfp-rnd-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-gcgl-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=goal_cg_level)),shrink_strategy=shrink_fh,label_reduction=exact(before_shrinking=false,before_merging=true,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-dfp-rnd-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-symmb60dfp-l-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_symmetries(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-dfp-rl-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-dfp-rl-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-dfp-rl-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-sbmiasm-rnd-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=random,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-dfp-rnd-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-dfp-l-rnd-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-cggl-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_tree=linear(variable_order=cg_goal_level)),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-sbmiasm-rl-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=reverse_level,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-sbmiasm-rnd-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=random,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-sbmiasm-rnd-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=random,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-dfp-l-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'symmb60miasm-dfp-l-nto-abp-b50k-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_symmetries(merge_tree=miasm(abstraction=miasm_merge_and_shrink(),fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=true)])),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmb60dfp-l-nto-abp-largest-secondary-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=true)]),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=secondary),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-sbmiasm-l-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-sbmiasm-l-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=level,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-miasm-dfp-rl-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_precomputed(merge_tree=miasm(abstraction=miasm_merge_and_shrink,fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]))),label_reduction=exact(before_shrinking=false,before_merging=true,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-dfp-l-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-symmb60cggl-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=cg_goal_level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),shrink_strategy=shrink_bisimulation(greedy=true),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-sbmiasm-rl-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=reverse_level,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-dfp-l-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmb60cggl-largest-secondary-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=cg_goal_level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=secondary),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-rl-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_tree=linear(variable_order=reverse_level)),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-miasm-dfp-l-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_precomputed(merge_tree=miasm(abstraction=miasm_merge_and_shrink,fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=true)]))),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-inc-dfp-rl-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=increasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmb60gcgl-smallest-secondary-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=goal_cg_level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=smallest,internal_merging=secondary),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-cggl-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=cg_goal_level)),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-sbmiasm-rnd-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=random,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-dfp-l-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-gcgl-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_tree=linear(variable_order=goal_cg_level)),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmb60dfp-rl-nto-pba-smallest-secondary-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=smallest,internal_merging=secondary),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-dfp-rl-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'f50k-symmb60l-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),shrink_strategy=shrink_fh,label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmb60dfp-l-nto-abp-smallest-secondary-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=true)]),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=smallest,internal_merging=secondary),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-gcgl-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=goal_cg_level)),shrink_strategy=shrink_bisimulation(greedy=true),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-sbmiasm-rl-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=reverse_level,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmi1dfp-l-nto-abp-smallest-secondary-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=true)]),stabilize_transition_systems=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,symmetries_for_merging=smallest,internal_merging=secondary),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'ginf-dfp-l-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-revtop-dfp-l-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=reverse_topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-cggl-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_tree=linear(variable_order=cg_goal_level)),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-top-sbmiasm-l-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=false),max_states=50000,threshold_before_merge=1),total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-sccs-dec-dfp-rnd-otn-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_sccs(order_of_sccs=decreasing,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=random,product_ts_order=old_to_new,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
'b50k-symmi1rl-largest-secondary-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=reverse_level),stabilize_transition_systems=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,symmetries_for_merging=largest,internal_merging=secondary),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))']}

# Create the experiment. Add parsers, fetchers or reports...
exp = MyExperiment(
    repo_name=REPO_NAME,
    configs=CONFIGS,
    revisions=REVISIONS,
    grid_suite=['airport:p10-airport3-p1.pddl', 'barman-opt11-strips:pfile04-015.pddl', 'blocks:probBLOCKS-14-1.pddl', 'driverlog:p04.pddl', 'elevators-opt08-strips:p27.pddl', 'elevators-opt11-strips:p05.pddl', 'elevators-opt11-strips:p15.pddl', 'floortile-opt11-strips:opt-p08-015.pddl', 'grid:prob04.pddl', 'hiking-opt14-strips:ptesting-2-4-6.pddl', 'logistics00:probLOGISTICS-13-1.pddl', 'logistics98:prob09.pddl', 'miconic:s22-2.pddl', 'miconic:s26-4.pddl', 'miconic:s28-0.pddl', 'movie:prob13.pddl', 'nomystery-opt11-strips:p16.pddl', 'openstacks-opt08-strips:p20.pddl', 'openstacks-opt14-strips:p20_2.pddl', 'openstacks-strips:p05.pddl', 'parcprinter-08-strips:p07.pddl', 'pegsol-08-strips:p18.pddl', 'pegsol-opt11-strips:p07.pddl', 'pipesworld-notankage:p11-net2-b10-g2.pddl', 'psr-small:p25-s40-n3-l4-f10.pddl', 'rovers:p09.pddl', 'satellite:p19-pfile19.pddl', 'satellite:p21-HC-pfile1.pddl', 'satellite:p33-HC-pfile13.pddl', 'scanalyzer-opt11-strips:p03.pddl', 'sokoban-opt11-strips:p16.pddl', 'sokoban-opt11-strips:p18.pddl', 'tidybot-opt11-strips:p15.pddl', 'tpp:p11.pddl', 'transport-opt08-strips:p08.pddl', 'transport-opt14-strips:p13.pddl', 'zenotravel:p09.pddl'],
    test_suite=['depot:p01.pddl', 'depot:p02.pddl', 'gripper:prob01.pddl', 'gripper:prob02.pddl', 'mystery:prob07.pddl'],
)
exp.add_search_parser('../ms-parser.py', ms_parser_attributes.get())
exp.add_search_parser('../merge-strategies/merge-strategies-parser.py', merge_strategies_attributes.get())
exp.add_search_parser('../merge-strategies/miasm-parser.py', miasm_attributes.get())
exp.add_search_parser('../merge-strategies/merge-symmetries-parser.py', symmetries_attributes.get())
exp.add_search_parser('../symmetric-lookups/symmetries-parser.py', symmetries_parser_attributes.get())

####### Replace faulty ginf-symmdfp run ##########

import os
from lab.reports.filter import FilterReport

def remove_faulty_algo(run):
    return run['algorithm'] != '81ab07c70f65-ginf-symmb60dfp-rl-nto-pba-fprnd-full-reg'

exp.add_report(FilterReport(filter=[remove_faulty_algo]),outfile=os.path.join(exp.eval_dir, 'fixed-properties'))
exp.add_fetcher(os.path.expanduser('~/experiments/dissertation/sota-missing-runs-dfpsymm-fixed-eval'))

exp.add_absolute_report()

exp.run_steps()
