#! /usr/bin/env python

from tools.my_experiment import MyExperiment
import ms_parser_attributes
import sys
sys.path.insert(1, '../merge-strategies')
import merge_strategies_attributes
import symmetries_attributes

# Set the following variables for the experiment
REPO_NAME = 'downward/diss'
REVISIONS = ['81ab07c70f65']

CONFIGS = {'ginf-symmb60dfp-rl-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_symmetries(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],}

# Create the experiment. Add parsers, fetchers or reports...
exp = MyExperiment(
    repo_name=REPO_NAME,
    configs=CONFIGS,
    revisions=REVISIONS,
    grid_suite=['airport:p10-airport3-p1.pddl', 'barman-opt11-strips:pfile04-015.pddl', 'blocks:probBLOCKS-14-1.pddl', 'driverlog:p04.pddl', 'elevators-opt08-strips:p27.pddl', 'elevators-opt11-strips:p05.pddl', 'elevators-opt11-strips:p15.pddl', 'floortile-opt11-strips:opt-p08-015.pddl', 'grid:prob04.pddl', 'hiking-opt14-strips:ptesting-2-4-6.pddl', 'logistics00:probLOGISTICS-13-1.pddl', 'logistics98:prob09.pddl', 'miconic:s22-2.pddl', 'miconic:s26-4.pddl', 'miconic:s28-0.pddl', 'movie:prob13.pddl', 'nomystery-opt11-strips:p16.pddl', 'openstacks-opt08-strips:p20.pddl', 'openstacks-opt14-strips:p20_2.pddl', 'openstacks-strips:p05.pddl', 'parcprinter-08-strips:p07.pddl', 'pegsol-08-strips:p18.pddl', 'pegsol-opt11-strips:p07.pddl', 'pipesworld-notankage:p11-net2-b10-g2.pddl', 'psr-small:p25-s40-n3-l4-f10.pddl', 'rovers:p09.pddl', 'satellite:p19-pfile19.pddl', 'satellite:p21-HC-pfile1.pddl', 'satellite:p33-HC-pfile13.pddl', 'scanalyzer-opt11-strips:p03.pddl', 'sokoban-opt11-strips:p16.pddl', 'sokoban-opt11-strips:p18.pddl', 'tidybot-opt11-strips:p15.pddl', 'tpp:p11.pddl', 'transport-opt08-strips:p08.pddl', 'transport-opt14-strips:p13.pddl', 'zenotravel:p09.pddl'],
    test_suite=['depot:p01.pddl', 'depot:p02.pddl', 'gripper:prob01.pddl', 'gripper:prob02.pddl', 'mystery:prob07.pddl'],
)
exp.add_search_parser('../ms-parser.py', ms_parser_attributes.get())
exp.add_search_parser('../merge-strategies/merge-strategies-parser.py', merge_strategies_attributes.get())
exp.add_search_parser('../merge-strategies/merge-symmetries-parser.py', symmetries_attributes.get())

exp.add_absolute_report()

exp.run_steps()
