#! /usr/bin/env python

from tools.my_experiment import MyExperiment
import ms_parser_attributes
import sys
sys.path.insert(1, '../merge-strategies')
import merge_strategies_attributes
import miasm_attributes

# Set the following variables for the experiment
REPO_NAME = 'downward/diss'
REVISIONS = ['81ab07c70f65']

CONFIGS = {
    # pirr
    'ginf-cggl-fprnd-pirr-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=cg_goal_level)),shrink_strategy=shrink_bisimulation(greedy=true),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
    'ginf-rl-fprnd-pirr-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=reverse_level)),shrink_strategy=shrink_bisimulation(greedy=true),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
    'ginf-dfp-rl-nto-pba-fprnd-pirr-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),shrink_strategy=shrink_bisimulation(greedy=true),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
    'ginf-dfp-l-rnd-pba-fprnd-pirr-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=false)])),shrink_strategy=shrink_bisimulation(greedy=true),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
    'ginf-miasm-dfp-rl-nto-pba-fprnd-pirr-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_precomputed(merge_tree=miasm(abstraction=miasm_merge_and_shrink,fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]))),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
    'ginf-sbmiasm-l-rnd-pba-fprnd-pirr-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=true),max_states=infinity),total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
    'ginf-sccs-top-dfp-l-otn-abp-fprnd-pirr-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=false))'],

    # punr
    'ginf-cggl-fprnd-punr-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=cg_goal_level)),shrink_strategy=shrink_bisimulation(greedy=true),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=false,pruning_as_abstraction=false))'],
    'ginf-rl-fprnd-punr-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=reverse_level)),shrink_strategy=shrink_bisimulation(greedy=true),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=false,pruning_as_abstraction=false))'],
    'ginf-dfp-rl-nto-pba-fprnd-punr-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),shrink_strategy=shrink_bisimulation(greedy=true),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=false,pruning_as_abstraction=false))'],
    'ginf-dfp-l-rnd-pba-fprnd-punr-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=false)])),shrink_strategy=shrink_bisimulation(greedy=true),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=false,pruning_as_abstraction=false))'],
    'ginf-miasm-dfp-rl-nto-pba-fprnd-punr-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_precomputed(merge_tree=miasm(abstraction=miasm_merge_and_shrink,fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]))),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=false,pruning_as_abstraction=false))'],
    'ginf-sbmiasm-l-rnd-pba-fprnd-punr-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=true),max_states=infinity),total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=false,pruning_as_abstraction=false))'],
    'ginf-sccs-top-dfp-l-otn-abp-fprnd-punr-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=false,pruning_as_abstraction=false))'],

    # nop
    'ginf-cggl-fprnd-nop': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=cg_goal_level)),shrink_strategy=shrink_bisimulation(greedy=true),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=false))'],
    'ginf-rl-fprnd-nop': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=reverse_level)),shrink_strategy=shrink_bisimulation(greedy=true),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=false))'],
    'ginf-dfp-rl-nto-pba-fprnd-nop': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),shrink_strategy=shrink_bisimulation(greedy=true),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=false))'],
    'ginf-dfp-l-rnd-pba-fprnd-nop': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=false)])),shrink_strategy=shrink_bisimulation(greedy=true),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=false))'],
    'ginf-miasm-dfp-rl-nto-pba-fprnd-nop': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_precomputed(merge_tree=miasm(abstraction=miasm_merge_and_shrink,fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]))),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=false))'],
    'ginf-sbmiasm-l-rnd-pba-fprnd-nop': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_bisimulation(greedy=true),max_states=infinity),total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=false)])),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=false))'],
    'ginf-sccs-top-dfp-l-otn-abp-fprnd-nop': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=false))'],
}

# Create the experiment. Add parsers, fetchers or reports...
exp = MyExperiment(
    repo_name=REPO_NAME,
    configs=CONFIGS,
    revisions=REVISIONS,
    test_suite=['depot:p01.pddl', 'depot:p02.pddl', 'gripper:prob01.pddl', 'gripper:prob02.pddl', 'mystery:prob07.pddl']
)
exp.add_search_parser('../ms-parser.py', ms_parser_attributes.get())
exp.add_search_parser('../merge-strategies/merge-strategies-parser.py', merge_strategies_attributes.get())
exp.add_search_parser('../merge-strategies/miasm-parser.py', miasm_attributes.get())

exp.add_absolute_report()

exp.run_steps()
