#! /usr/bin/env python

from tools.my_experiment import MyExperiment
import ms_parser_attributes
import sys
sys.path.insert(1, '../merge-strategies')
import merge_strategies_attributes
import miasm_attributes
import symmetries_attributes

# Set the following variables for the experiment
REPO_NAME = 'downward/diss'
REVISIONS = ['acbb58c01fc8']

CONFIGS = {
    # default setting
    'ginf-miasm-dfp-rl-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_precomputed(merge_tree=miasm(abstraction=miasm_merge_and_shrink,fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]))),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
    'ginf-miasm-dfp-l-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_precomputed(merge_tree=miasm(abstraction=miasm_merge_and_shrink,fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=true)]))),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
    'ginf-cggl-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=cg_goal_level)),shrink_strategy=shrink_bisimulation(greedy=true),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
    'ginf-gcgl-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=goal_cg_level)),shrink_strategy=shrink_bisimulation(greedy=true),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
    'ginf-l-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=level)),shrink_strategy=shrink_bisimulation(greedy=true),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
    'ginf-rl-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=reverse_level)),shrink_strategy=shrink_bisimulation(greedy=true),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],

    # symm
    'ginf-symmb60dfp-rl-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_symmetries(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
    'ginf-symmb60dfp-l-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_symmetries(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
    'ginf-symmb60miasm-dfp-rl-nto-pba-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_symmetries(merge_tree=miasm(abstraction=miasm_merge_and_shrink(),fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
    'ginf-symmb60miasm-dfp-l-nto-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=true),merge_strategy=merge_symmetries(merge_tree=miasm(abstraction=miasm_merge_and_shrink(),fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=new_to_old,atomic_before_product=true)])),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
    'ginf-symmb60cggl-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=cg_goal_level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),shrink_strategy=shrink_bisimulation(greedy=true),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
    'ginf-symmb60gcgl-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=goal_cg_level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),shrink_strategy=shrink_bisimulation(greedy=true),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
    'ginf-symmb60l-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),shrink_strategy=shrink_bisimulation(greedy=true),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
    'ginf-symmb60rl-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=reverse_level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),shrink_strategy=shrink_bisimulation(greedy=true),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=infinity,threshold_before_merge=1,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
}

# Create the experiment. Add parsers, fetchers or reports...
exp = MyExperiment(
    repo_name=REPO_NAME,
    configs=CONFIGS,
    revisions=REVISIONS,
    test_suite=['depot:p01.pddl', 'depot:p02.pddl', 'gripper:prob01.pddl', 'gripper:prob02.pddl', 'mystery:prob07.pddl'],
)
exp.add_search_parser('../ms-parser.py', ms_parser_attributes.get())
exp.add_search_parser('../merge-strategies/merge-strategies-parser.py', merge_strategies_attributes.get())
exp.add_search_parser('../merge-strategies/miasm-parser.py', miasm_attributes.get())
exp.add_search_parser('../merge-strategies/symmetries-parser.py', symmetries_attributes.get())

####### Replace faulty ginf-symmdfp run ##########

import os
from lab.reports.filter import FilterReport

def remove_faulty_algo(run):
    return run['algorithm'] != 'acbb58c01fc8-ginf-symmb60dfp-rl-nto-pba-fprnd-full-reg'

def remove_fixed_runs_revision(run):
    algorithm = run['algorithm']
    algorithm = algorithm.replace('81ab07c70f65-', '')
    run['algorithm'] = algorithm
    return run

exp.add_report(FilterReport(filter=[remove_faulty_algo]),outfile=os.path.join(exp.eval_dir, 'fixed-properties'))
exp.add_fetcher(os.path.expanduser('~/experiments/dissertation/sota-ginf-dfpsymm-fixed-eval'),filter=[remove_fixed_runs_revision])

exp.add_absolute_report()

exp.run_steps()
