#! /usr/bin/env python

from tools.my_experiment import MyExperiment
import ms_parser_attributes
import sys
sys.path.insert(1, '../merge-strategies')
import merge_strategies_attributes

# Set the following variables for the experiment
REPO_NAME = 'downward/diss'
REVISIONS = ['81ab07c70f65']

CONFIGS = {
    # Linear
    'f50k-sccs-top-cggl-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_sccs(order_of_sccs=topological,merge_tree=linear(variable_order=cg_goal_level)),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
    'f50k-sccs-top-gcgl-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_sccs(order_of_sccs=topological,merge_tree=linear(variable_order=goal_cg_level)),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
    'f50k-sccs-top-l-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_sccs(order_of_sccs=topological,merge_tree=linear(variable_order=level)),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
    'f50k-sccs-top-rl-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_sccs(order_of_sccs=topological,merge_tree=linear(variable_order=reverse_level)),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
}

# Create the experiment. Add parsers, fetchers or reports...
exp = MyExperiment(
    repo_name=REPO_NAME,
    configs=CONFIGS,
    revisions=REVISIONS,
    test_suite=['depot:p01.pddl', 'depot:p02.pddl', 'gripper:prob01.pddl', 'gripper:prob02.pddl', 'mystery:prob07.pddl']
)
exp.add_search_parser('../ms-parser.py', ms_parser_attributes.get())
exp.add_search_parser('../merge-strategies/merge-strategies-parser.py', merge_strategies_attributes.get())

exp.add_absolute_report()

exp.run_steps()
