#! /usr/bin/env python

from tools.my_experiment import MyExperiment
import ms_parser_attributes
import sys
sys.path.insert(1, '../merge-strategies')
import merge_strategies_attributes
import miasm_attributes
import symmetries_attributes

# Set the following variables for the experiment
REPO_NAME = 'downward/diss'
REVISIONS = ['81ab07c70f65']

CONFIGS = {
    # pure
    'f50k-miasm-dfp-l-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_precomputed(merge_tree=miasm(abstraction=miasm_merge_and_shrink,fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=true)]))),label_reduction=exact(before_shrinking=false,before_merging=true,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
    'f50k-miasm-sbmiasm-rnd-otn-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_precomputed(merge_tree=miasm(abstraction=miasm_merge_and_shrink,fallback_merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_fh,max_states=50000),total_order(atomic_ts_order=random,product_ts_order=old_to_new,atomic_before_product=true)]))),label_reduction=exact(before_shrinking=false,before_merging=true,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],

    # symm
    # in future, remove double dfp here
    'f50k-symmb60dfp-dfp-l-rnd-abp-fprnd-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_symmetries(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=true)]),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
    'f50k-symmb60miasm-sbmiasm-rnd-otn-abp-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_symmetries(merge_tree=miasm(abstraction=miasm_merge_and_shrink(),fallback_merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_fh,max_states=50000),total_order(atomic_ts_order=random,product_ts_order=old_to_new,atomic_before_product=true)])),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
    'f50k-symmb60sbmiasm-rnd-otn-abp-full-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_symmetries(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_fh,max_states=50000),total_order(atomic_ts_order=random,product_ts_order=old_to_new,atomic_before_product=true)]),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),label_reduction=exact(before_shrinking=false,before_merging=true),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
}

# Create the experiment. Add parsers, fetchers or reports...
exp = MyExperiment(
    repo_name=REPO_NAME,
    configs=CONFIGS,
    revisions=REVISIONS,
    test_suite=['depot:p01.pddl', 'depot:p02.pddl', 'gripper:prob01.pddl', 'gripper:prob02.pddl', 'mystery:prob07.pddl'],
)
exp.add_search_parser('../ms-parser.py', ms_parser_attributes.get())
exp.add_search_parser('../merge-strategies/merge-strategies-parser.py', merge_strategies_attributes.get())
exp.add_search_parser('../merge-strategies/miasm-parser.py', miasm_attributes.get())
exp.add_search_parser('../merge-strategies/symmetries-parser.py', symmetries_attributes.get())

exp.add_absolute_report()

exp.run_steps()
