#! /usr/bin/env python

from tools.my_experiment import MyExperiment
import ms_parser_attributes
import sys
sys.path.insert(1, '../merge-strategies')
import merge_strategies_attributes
import miasm_attributes

# Set the following variables for the experiment
REPO_NAME = 'downward/diss'
REVISIONS = ['81ab07c70f65']

CONFIGS = {
    # full
    'f50k-cggl-fprnd-full-abs': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=cg_goal_level)),shrink_strategy=shrink_fh,label_reduction=exact(before_shrinking=false,before_merging=true,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=true))'],
    'f50k-rl-fprnd-full-abs': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=reverse_level)),shrink_strategy=shrink_fh,label_reduction=exact(before_shrinking=false,before_merging=true,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=true))'],
    'f50k-dfp-rl-nto-pba-fprnd-full-abs': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),shrink_strategy=shrink_fh,label_reduction=exact(before_shrinking=false,before_merging=true,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=true))'],
    'f50k-dfp-l-rnd-abp-fprnd-full-abs': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=true)])),shrink_strategy=shrink_fh,label_reduction=exact(before_shrinking=false,before_merging=true,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=true))'],
    'f50k-miasm-dfp-rl-nto-pba-fprnd-full-abs': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_precomputed(merge_tree=miasm(abstraction=miasm_merge_and_shrink,fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]))),label_reduction=exact(before_shrinking=false,before_merging=true,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=true))'],
    'f50k-sbmiasm-rnd-otn-abp-fprnd-full-abs': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_fh,max_states=50000),total_order(atomic_ts_order=level,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=false,before_merging=true,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=true))'],
    'f50k-sccs-top-dfp-l-rnd-abp-fprnd-full-abs': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=false,before_merging=true,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=true,pruning_as_abstraction=true))'],

    # pirr
    'f50k-cggl-fprnd-pirr-abs': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=cg_goal_level)),shrink_strategy=shrink_fh,label_reduction=exact(before_shrinking=false,before_merging=true,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=true))'],
    'f50k-rl-fprnd-pirr-abs': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=reverse_level)),shrink_strategy=shrink_fh,label_reduction=exact(before_shrinking=false,before_merging=true,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=true))'],
    'f50k-dfp-rl-nto-pba-fprnd-pirr-abs': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),shrink_strategy=shrink_fh,label_reduction=exact(before_shrinking=false,before_merging=true,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=true))'],
    'f50k-dfp-l-rnd-abp-fprnd-pirr-abs': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=true)])),shrink_strategy=shrink_fh,label_reduction=exact(before_shrinking=false,before_merging=true,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=true))'],
    'f50k-miasm-dfp-rl-nto-pba-fprnd-pirr-abs': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_precomputed(merge_tree=miasm(abstraction=miasm_merge_and_shrink,fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]))),label_reduction=exact(before_shrinking=false,before_merging=true,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=true))'],
    'f50k-sbmiasm-rnd-otn-abp-fprnd-pirr-abs': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_fh,max_states=50000),total_order(atomic_ts_order=level,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=false,before_merging=true,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=true))'],
    'f50k-sccs-top-dfp-l-rnd-abp-fprnd-pirr-abs': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=false,before_merging=true,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=true))'],

    # punr
    'f50k-cggl-fprnd-punr-abs': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=cg_goal_level)),shrink_strategy=shrink_fh,label_reduction=exact(before_shrinking=false,before_merging=true,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=false,pruning_as_abstraction=true))'],
    'f50k-rl-fprnd-punr-abs': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=reverse_level)),shrink_strategy=shrink_fh,label_reduction=exact(before_shrinking=false,before_merging=true,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=false,pruning_as_abstraction=true))'],
    'f50k-dfp-rl-nto-pba-fprnd-punr-abs': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),shrink_strategy=shrink_fh,label_reduction=exact(before_shrinking=false,before_merging=true,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=false,pruning_as_abstraction=true))'],
    'f50k-dfp-l-rnd-abp-fprnd-punr-abs': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=true)])),shrink_strategy=shrink_fh,label_reduction=exact(before_shrinking=false,before_merging=true,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=false,pruning_as_abstraction=true))'],
    'f50k-miasm-dfp-rl-nto-pba-fprnd-punr-abs': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_precomputed(merge_tree=miasm(abstraction=miasm_merge_and_shrink,fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]))),label_reduction=exact(before_shrinking=false,before_merging=true,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=false,pruning_as_abstraction=true))'],
    'f50k-sbmiasm-rnd-otn-abp-fprnd-punr-abs': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_stateless(merge_selector=score_based_filtering(scoring_functions=[sf_miasm(shrink_strategy=shrink_fh,max_states=50000),total_order(atomic_ts_order=level,product_ts_order=old_to_new,atomic_before_product=true)])),label_reduction=exact(before_shrinking=false,before_merging=true,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=false,pruning_as_abstraction=true))'],
    'f50k-sccs-top-dfp-l-rnd-abp-fprnd-punr-abs': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_fh,merge_strategy=merge_sccs(order_of_sccs=topological,merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=level,product_ts_order=random,atomic_before_product=true)])),label_reduction=exact(before_shrinking=false,before_merging=true,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,prune_unreachable_states=true,prune_irrelevant_states=false,pruning_as_abstraction=true))'],
}

# Create the experiment. Add parsers, fetchers or reports...
exp = MyExperiment(
    repo_name=REPO_NAME,
    configs=CONFIGS,
    revisions=REVISIONS,
    test_suite=['depot:p01.pddl', 'depot:p02.pddl', 'gripper:prob01.pddl', 'gripper:prob02.pddl', 'mystery:prob07.pddl']
)
exp.add_search_parser('../ms-parser.py', ms_parser_attributes.get())
exp.add_search_parser('../merge-strategies/merge-strategies-parser.py', merge_strategies_attributes.get())
exp.add_search_parser('../merge-strategies/miasm-parser.py', miasm_attributes.get())

exp.add_absolute_report()

exp.run_steps()
