#! /usr/bin/env python

from tools.my_experiment import MyExperiment
import ms_parser_attributes
import sys
sys.path.insert(1, '../merge-strategies')
import merge_strategies_attributes
import miasm_attributes
import symmetries_attributes
sys.path.insert(1, '../symmetric-lookups')
import symmetries_parser_attributes

# Set the following variables for the experiment
REPO_NAME = 'downward/diss'
REVISIONS = ['81ab07c70f65']

CONFIGS = {
    # Symm
    'b50k-symmb60cggl-largest-nonlinear-fprnd-pirr-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=cg_goal_level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
    'b50k-symmb60rl-largest-nonlinear-fprnd-pirr-reg': ['--search', 'astar(merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=reverse_level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=false))'],
    'b50k-symmb60miasm-dfp-rl-nto-pba-largest-nonlinear-fprnd-pirr-reg': ['--search', 'astar(merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_symmetries(merge_tree=miasm(abstraction=miasm_merge_and_shrink(),fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=false))'],

    # SL
    'b50k-slall-cggl-fprnd-pirr-reg': ['--symmetries', 'sym=structural_symmetries(time_bound=0,symmetrical_lookups=all_states)', '--heuristic', 'hmas=merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=cg_goal_level)),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=false)', '--search', 'astar(sl_heuristic(component_heuristic=hmas,symmetries=sym))'],
    'b50k-slall-rl-fprnd-pirr-reg': ['--symmetries', 'sym=structural_symmetries(time_bound=0,symmetrical_lookups=all_states)', '--heuristic', 'hmas=merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=reverse_level)),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=false)', '--search', 'astar(sl_heuristic(component_heuristic=hmas,symmetries=sym))'],
    'b50k-slall-miasm-dfp-rl-nto-pba-fprnd-pirr-reg': ['--symmetries', 'sym=structural_symmetries(time_bound=0,symmetrical_lookups=all_states)', '--heuristic', 'hmas=merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_precomputed(merge_tree=miasm(abstraction=miasm_merge_and_shrink,fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]))),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=false)', '--search', 'astar(sl_heuristic(component_heuristic=hmas,symmetries=sym))'],

    # OSS
    'b50k-oss-cggl-fprnd-pirr-reg': ['--symmetries', 'sym=structural_symmetries(time_bound=0,search_symmetries=oss)', '--heuristic', 'hmas=merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=cg_goal_level)),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=false)', '--search', 'astar(hmas,symmetries=sym)'],
    'b50k-oss-rl-fprnd-pirr-reg': ['--symmetries', 'sym=structural_symmetries(time_bound=0,search_symmetries=oss)', '--heuristic', 'hmas=merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=reverse_level)),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=false)', '--search', 'astar(hmas,symmetries=sym)'],
    'b50k-oss-miasm-dfp-rl-nto-pba-fprnd-pirr-reg': ['--symmetries', 'sym=structural_symmetries(time_bound=0,search_symmetries=oss)', '--heuristic', 'hmas=merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_precomputed(merge_tree=miasm(abstraction=miasm_merge_and_shrink,fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]))),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=false)', '--search', 'astar(hmas,symmetries=sym)'],

    # Combinations
    # OSS + SL
    'b50k-oss-slall-cggl-fprnd-pirr-reg': ['--symmetries', 'sym=structural_symmetries(time_bound=0,symmetrical_lookups=all_states,search_symmetries=oss)', '--heuristic', 'hmas=merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=cg_goal_level)),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=false)', '--search', 'astar(sl_heuristic(component_heuristic=hmas,symmetries=sym),symmetries=sym)'],
    # TODO: fix config, add fprnd again
    'b50k-oss-slall-rl-pirr-reg': ['--symmetries', 'sym=structural_symmetries(time_bound=0,symmetrical_lookups=all_states,search_symmetries=oss)', '--heuristic', 'hmas=merge_and_shrink(merge_strategy=merge_precomputed(merge_tree=linear(variable_order=reverse_level)),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=false)', '--search', 'astar(sl_heuristic(component_heuristic=hmas,symmetries=sym),symmetries=sym)'],
    'b50k-oss-slall-miasm-dfp-rl-nto-pba-fprnd-pirr-reg': ['--symmetries', 'sym=structural_symmetries(time_bound=0,symmetrical_lookups=all_states,search_symmetries=oss)', '--heuristic', 'hmas=merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_precomputed(merge_tree=miasm(abstraction=miasm_merge_and_shrink,fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)]))),label_reduction=exact(before_shrinking=true,before_merging=false,method=all_transition_systems_with_fixpoint,system_order=random),max_states=50000,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=false)', '--search', 'astar(sl_heuristic(component_heuristic=hmas,symmetries=sym),symmetries=sym)'],
    # OSS + symmb60
    'b50k-oss-symmb60cggl-largest-nonlinear-fprnd-pirr-reg': ['--symmetries', 'sym=structural_symmetries(time_bound=0,search_symmetries=oss)', '--heuristic', 'hmas=merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=cg_goal_level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=false)', '--search', 'astar(hmas,symmetries=sym)'],
    'b50k-oss-symmb60rl-largest-nonlinear-fprnd-pirr-reg': ['--symmetries', 'sym=structural_symmetries(time_bound=0,search_symmetries=oss)', '--heuristic', 'hmas=merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=reverse_level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=false)', '--search', 'astar(hmas,symmetries=sym)'],
    'b50k-oss-symmb60miasm-dfp-rl-nto-pba-largest-nonlinear-fprnd-pirr-reg': ['--symmetries', 'sym=structural_symmetries(time_bound=0,search_symmetries=oss)', '--heuristic', 'hmas=merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_symmetries(merge_tree=miasm(abstraction=miasm_merge_and_shrink(),fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=false)', '--search', 'astar(hmas,symmetries=sym)'],
    # SL + symmb60
    'b50k-slall-symmb60cggl-largest-nonlinear-fprnd-pirr-reg': ['--symmetries', 'sym=structural_symmetries(time_bound=0,symmetrical_lookups=all_states)', '--heuristic', 'hmas=merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=cg_goal_level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=false)', '--search', 'astar(sl_heuristic(component_heuristic=hmas,symmetries=sym))'],
    # TODO: fix type tl -> rl in future
    'b50k-slall-symmb60tl-largest-nonlinear-fprnd-pirr-reg': ['--symmetries', 'sym=structural_symmetries(time_bound=0,symmetrical_lookups=all_states)', '--heuristic', 'hmas=merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=reverse_level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=false)', '--search', 'astar(sl_heuristic(component_heuristic=hmas,symmetries=sym))'],
    'b50k-slall-symmb60miasm-dfp-rl-nto-pba-largest-nonlinear-fprnd-pirr-reg': ['--symmetries', 'sym=structural_symmetries(time_bound=0,symmetrical_lookups=all_states)', '--heuristic', 'hmas=merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_symmetries(merge_tree=miasm(abstraction=miasm_merge_and_shrink(),fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=false)', '--search', 'astar(sl_heuristic(component_heuristic=hmas,symmetries=sym))'],

    # All three
    'b50k-oss-slall-symmb60cggl-largest-nonlinear-fprnd-pirr-reg': ['--symmetries', 'sym=structural_symmetries(time_bound=0,symmetrical_lookups=all_states,search_symmetries=oss)', '--heuristic', 'hmas=merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=cg_goal_level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=false)', '--search', 'astar(sl_heuristic(component_heuristic=hmas,symmetries=sym),symmetries=sym)'],
    'b50k-oss-slall-symmb60rl-largest-nonlinear-fprnd-pirr-reg': ['--symmetries', 'sym=structural_symmetries(time_bound=0,symmetrical_lookups=all_states,search_symmetries=oss)', '--heuristic', 'hmas=merge_and_shrink(merge_strategy=merge_symmetries(merge_tree=linear(variable_order=reverse_level),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),shrink_strategy=shrink_bisimulation(greedy=false),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=false)', '--search', 'astar(sl_heuristic(component_heuristic=hmas,symmetries=sym),symmetries=sym)'],
    'b50k-oss-slall-symmb60miasm-dfp-rl-nto-pba-largest-nonlinear-fprnd-pirr-reg': ['--symmetries', 'sym=structural_symmetries(time_bound=0,symmetrical_lookups=all_states,search_symmetries=oss)', '--heuristic', 'hmas=merge_and_shrink(shrink_strategy=shrink_bisimulation(greedy=false),merge_strategy=merge_symmetries(merge_tree=miasm(abstraction=miasm_merge_and_shrink(),fallback_merge_selector=score_based_filtering(scoring_functions=[goal_relevance,dfp,total_order(atomic_ts_order=reverse_level,product_ts_order=new_to_old,atomic_before_product=false)])),stabilize_transition_systems=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,symmetries_for_merging=largest,internal_merging=non_linear),label_reduction=exact(before_shrinking=true,before_merging=false),max_states=50000,threshold_before_merge=1,prune_unreachable_states=false,prune_irrelevant_states=true,pruning_as_abstraction=false)', '--search', 'astar(sl_heuristic(component_heuristic=hmas,symmetries=sym),symmetries=sym)'],
}

# Create the experiment. Add parsers, fetchers or reports...
exp = MyExperiment(
    repo_name=REPO_NAME,
    configs=CONFIGS,
    revisions=REVISIONS,
    test_suite=['depot:p01.pddl', 'depot:p02.pddl', 'gripper:prob01.pddl', 'gripper:prob02.pddl', 'mystery:prob07.pddl'],
)
exp.add_search_parser('../ms-parser.py', ms_parser_attributes.get())
exp.add_search_parser('../merge-strategies/merge-strategies-parser.py', merge_strategies_attributes.get())
exp.add_search_parser('../merge-strategies/miasm-parser.py', miasm_attributes.get())
exp.add_search_parser('../merge-strategies/merge-symmetries-parser.py', symmetries_attributes.get())
exp.add_search_parser('../symmetric-lookups/symmetries-parser.py', symmetries_parser_attributes.get())

exp.add_absolute_report()

exp.run_steps()
