#! /usr/bin/env python

from lab.reports import arithmetic_mean, geometric_mean, percentile_50, percentile_75, Attribute
from tools.my_experiment import MyExperiment
from tools.my_reports import FlexibleAttribute

import ms_parser_attributes
import sys
sys.path.insert(1, '../merge-strategies')
import merge_strategies_attributes

import math
import os.path

# Set the following variables for the experiment
REPO_NAME = 'downward/dissertation'
REVISIONS = [
    '81ab07c70f65', # dissertation branch, sccs
]

CONFIGS = {}

# Create the experiment. Add parsers, fetchers or reports...
exp = MyExperiment(
    repo_name=REPO_NAME,
    configs=CONFIGS,
    revisions=REVISIONS,
    #test_suite=['depot:pfile1', 'depot:pfile2', 'gripper:prob01.pddl', 'gripper:prob02.pddl']
)
# for attributes
exp.add_search_parser('../ms-parser.py', ms_parser_attributes.get())
exp.add_search_parser('../merge-strategies/merge-strategies-parser.py', merge_strategies_attributes.get())

def remove_revision(run):
    algorithm = run['algorithm']
    for rev in REVISIONS:
        algorithm = algorithm.replace('%s-' % rev, '')
    run['algorithm'] = algorithm
    return run

exp.add_fetcher(os.path.expanduser('~/experiments/dissertation/sota-f50k-sccs-top-eval/'),filter=[remove_revision],filter_algorithm=[
    'f50k-sccs-top-dfp-rl-nto-pba-fprnd-full-reg',
    'f50k-sccs-top-dfp-rl-otn-pba-fprnd-full-reg',
    'f50k-sccs-top-dfp-rl-rnd-pba-fprnd-full-reg',
    'f50k-sccs-top-dfp-l-nto-pba-fprnd-full-reg',
    'f50k-sccs-top-dfp-l-otn-pba-fprnd-full-reg',
    'f50k-sccs-top-dfp-l-rnd-pba-fprnd-full-reg',
    'f50k-sccs-top-dfp-rnd-nto-pba-fprnd-full-reg',
    'f50k-sccs-top-dfp-rnd-otn-pba-fprnd-full-reg',
    'f50k-sccs-top-dfp-rnd-rnd-pba-fprnd-full-reg',
    'f50k-sccs-top-dfp-rl-nto-abp-fprnd-full-reg',
    'f50k-sccs-top-dfp-rl-otn-abp-fprnd-full-reg',
    'f50k-sccs-top-dfp-rl-rnd-abp-fprnd-full-reg',
    'f50k-sccs-top-dfp-l-nto-abp-fprnd-full-reg',
    'f50k-sccs-top-dfp-l-otn-abp-fprnd-full-reg',
    'f50k-sccs-top-dfp-l-rnd-abp-fprnd-full-reg',
    'f50k-sccs-top-dfp-rnd-nto-abp-fprnd-full-reg',
    'f50k-sccs-top-dfp-rnd-otn-abp-fprnd-full-reg',
    'f50k-sccs-top-dfp-rnd-rnd-abp-fprnd-full-reg',
    'f50k-sccs-top-dfp-allrnd-fprnd-full-reg',
    'f50k-sccs-top-sbmiasm-rl-nto-pba-fprnd-full-reg',
    'f50k-sccs-top-sbmiasm-rl-otn-pba-fprnd-full-reg',
    'f50k-sccs-top-sbmiasm-rl-rnd-pba-fprnd-full-reg',
    'f50k-sccs-top-sbmiasm-l-nto-pba-fprnd-full-reg',
    'f50k-sccs-top-sbmiasm-l-otn-pba-fprnd-full-reg',
    'f50k-sccs-top-sbmiasm-l-rnd-pba-fprnd-full-reg',
    'f50k-sccs-top-sbmiasm-rnd-nto-pba-fprnd-full-reg',
    'f50k-sccs-top-sbmiasm-rnd-otn-pba-fprnd-full-reg',
    'f50k-sccs-top-sbmiasm-rnd-rnd-pba-fprnd-full-reg',
    'f50k-sccs-top-sbmiasm-rl-nto-abp-fprnd-full-reg',
    'f50k-sccs-top-sbmiasm-rl-otn-abp-fprnd-full-reg',
    'f50k-sccs-top-sbmiasm-rl-rnd-abp-fprnd-full-reg',
    'f50k-sccs-top-sbmiasm-l-nto-abp-fprnd-full-reg',
    'f50k-sccs-top-sbmiasm-l-otn-abp-fprnd-full-reg',
    'f50k-sccs-top-sbmiasm-l-rnd-abp-fprnd-full-reg',
    'f50k-sccs-top-sbmiasm-rnd-nto-abp-fprnd-full-reg',
    'f50k-sccs-top-sbmiasm-rnd-otn-abp-fprnd-full-reg',
    'f50k-sccs-top-sbmiasm-rnd-rnd-abp-fprnd-full-reg',
    'f50k-sccs-top-sbmiasm-allrnd-fprnd-full-reg',
])
exp.add_fetcher(os.path.expanduser('~/experiments/dissertation/sota-f50k-sccs-top-fixed-linear-eval/'),filter=[remove_revision])
exp.add_fetcher(os.path.expanduser('~/experiments/dissertation/sota-ginf-sccs-top-eval/'),filter=[remove_revision])

flexible_attributes = [
    FlexibleAttribute('coverage', 'Coverage', None, absolute=True, min_wins=False, functions=[sum]),
    FlexibleAttribute('expansions_until_last_jump', 'Exp', float('inf'), absolute=False, min_wins=True, functions=[percentile_50, percentile_75]),
    FlexibleAttribute('search_time', 'Search time', None, absolute=False, min_wins=True, functions=[geometric_mean]),
    FlexibleAttribute('total_time', 'Total time', None, absolute=False, min_wins=True, functions=[geometric_mean]),
    #FlexibleAttribute('search_out_of_memory', 'Search oom', None, absolute=True, min_wins=True, functions=[sum]),
    #FlexibleAttribute('search_out_of_time', 'Search oot', None, absolute=True, min_wins=True, functions=[sum]),

    FlexibleAttribute('ms_abstraction_constructed', '\# constr', False, absolute=True, min_wins=False, functions=[sum]),
    #FlexibleAttribute('ms_atomic_construction_time', 'Atomic constr time', None, absolute=False, min_wins=True, functions=[arithmetic_mean]),
    FlexibleAttribute('ms_construction_time', 'Constr time', None, absolute=False, min_wins=True, functions=[arithmetic_mean]),
    FlexibleAttribute('ms_out_of_memory', 'Constr oom', None, absolute=True, min_wins=True, functions=[sum]),
    FlexibleAttribute('ms_out_of_time', 'Constr oot', None, absolute=True, min_wins=True, functions=[sum]),
    FlexibleAttribute('perfect_heuristic', 'Perfect h', None, absolute=True, min_wins=False),
    #FlexibleAttribute('ms_tiebreaking_iterations', 'Tiebreak it', 0, absolute=True, min_wins=True, functions=[sum]),
    #FlexibleAttribute('ms_max_int_abs_size', 'MITSS', None, absolute=False, min_wins=True, functions=[geometric_mean]),
    FlexibleAttribute('ms_linear_order', 'Linear tree', None, absolute=True, min_wins=True, functions=[sum]),
]


###### HTML tables ###################################################

exp.add_absolute_report(attributes=['coverage'],publish=False)


####### Paper tables #################################################

exp.add_flexible_aggregation_report(
    algorithm_rows=[
        [
            [
                'f50k-sccs-top-dfp-rl-nto-pba-fprnd-full-reg',
                'f50k-sccs-top-dfp-rl-otn-pba-fprnd-full-reg',
                'f50k-sccs-top-dfp-rl-rnd-pba-fprnd-full-reg',
                'f50k-sccs-top-dfp-l-nto-pba-fprnd-full-reg',
                'f50k-sccs-top-dfp-l-otn-pba-fprnd-full-reg',
                'f50k-sccs-top-dfp-l-rnd-pba-fprnd-full-reg',
                'f50k-sccs-top-dfp-rnd-nto-pba-fprnd-full-reg',
                'f50k-sccs-top-dfp-rnd-otn-pba-fprnd-full-reg',
                'f50k-sccs-top-dfp-rnd-rnd-pba-fprnd-full-reg',
                'f50k-sccs-top-dfp-allrnd-fprnd-full-reg',
            ],
        ],
        [
            [
                'f50k-sccs-top-dfp-rl-nto-abp-fprnd-full-reg',
                'f50k-sccs-top-dfp-rl-otn-abp-fprnd-full-reg',
                'f50k-sccs-top-dfp-rl-rnd-abp-fprnd-full-reg',
                'f50k-sccs-top-dfp-l-nto-abp-fprnd-full-reg',
                'f50k-sccs-top-dfp-l-otn-abp-fprnd-full-reg',
                'f50k-sccs-top-dfp-l-rnd-abp-fprnd-full-reg',
                'f50k-sccs-top-dfp-rnd-nto-abp-fprnd-full-reg',
                'f50k-sccs-top-dfp-rnd-otn-abp-fprnd-full-reg',
                'f50k-sccs-top-dfp-rnd-rnd-abp-fprnd-full-reg',
                'f50k-sccs-top-cggl-full-reg', # addition
            ],
        ],
    ],
    flexible_attributes=flexible_attributes,
    single_aggregation=False,
    name='f50k-sccs-dfp-and-cggl',
)

exp.add_flexible_aggregation_report(
    algorithm_rows=[
        [
            [
                'f50k-sccs-top-sbmiasm-rl-nto-pba-fprnd-full-reg',
                'f50k-sccs-top-sbmiasm-rl-otn-pba-fprnd-full-reg',
                'f50k-sccs-top-sbmiasm-rl-rnd-pba-fprnd-full-reg',
                'f50k-sccs-top-sbmiasm-l-nto-pba-fprnd-full-reg',
                'f50k-sccs-top-sbmiasm-l-otn-pba-fprnd-full-reg',
                'f50k-sccs-top-sbmiasm-l-rnd-pba-fprnd-full-reg',
                'f50k-sccs-top-sbmiasm-rnd-nto-pba-fprnd-full-reg',
                'f50k-sccs-top-sbmiasm-rnd-otn-pba-fprnd-full-reg',
                'f50k-sccs-top-sbmiasm-rnd-rnd-pba-fprnd-full-reg',
                'f50k-sccs-top-sbmiasm-allrnd-fprnd-full-reg',
            ],
        ],
        [
            [
                'f50k-sccs-top-sbmiasm-rl-nto-abp-fprnd-full-reg',
                'f50k-sccs-top-sbmiasm-rl-otn-abp-fprnd-full-reg',
                'f50k-sccs-top-sbmiasm-rl-rnd-abp-fprnd-full-reg',
                'f50k-sccs-top-sbmiasm-l-nto-abp-fprnd-full-reg',
                'f50k-sccs-top-sbmiasm-l-otn-abp-fprnd-full-reg',
                'f50k-sccs-top-sbmiasm-l-rnd-abp-fprnd-full-reg',
                'f50k-sccs-top-sbmiasm-rnd-nto-abp-fprnd-full-reg',
                'f50k-sccs-top-sbmiasm-rnd-otn-abp-fprnd-full-reg',
                'f50k-sccs-top-sbmiasm-rnd-rnd-abp-fprnd-full-reg',
                'f50k-sccs-top-rl-full-reg', # addition
            ],
        ],
    ],
    flexible_attributes=flexible_attributes,
    single_aggregation=False,
    name='f50k-sccs-sbmiasm-and-rl',
)

exp.add_flexible_aggregation_report(
    algorithm_rows=[
        [
            [
                'ginf-sccs-top-dfp-rl-nto-pba-fprnd-full-reg',
                'ginf-sccs-top-dfp-rl-otn-pba-fprnd-full-reg',
                'ginf-sccs-top-dfp-rl-rnd-pba-fprnd-full-reg',
                'ginf-sccs-top-dfp-l-nto-pba-fprnd-full-reg',
                'ginf-sccs-top-dfp-l-otn-pba-fprnd-full-reg',
                'ginf-sccs-top-dfp-l-rnd-pba-fprnd-full-reg',
                'ginf-sccs-top-dfp-rnd-nto-pba-fprnd-full-reg',
                'ginf-sccs-top-dfp-rnd-otn-pba-fprnd-full-reg',
                'ginf-sccs-top-dfp-rnd-rnd-pba-fprnd-full-reg',
                'ginf-sccs-top-dfp-allrnd-fprnd-full-reg',
            ],
        ],
        [
            [
                'ginf-sccs-top-dfp-rl-nto-abp-fprnd-full-reg',
                'ginf-sccs-top-dfp-rl-otn-abp-fprnd-full-reg',
                'ginf-sccs-top-dfp-rl-rnd-abp-fprnd-full-reg',
                'ginf-sccs-top-dfp-l-nto-abp-fprnd-full-reg',
                'ginf-sccs-top-dfp-l-otn-abp-fprnd-full-reg',
                'ginf-sccs-top-dfp-l-rnd-abp-fprnd-full-reg',
                'ginf-sccs-top-dfp-rnd-nto-abp-fprnd-full-reg',
                'ginf-sccs-top-dfp-rnd-otn-abp-fprnd-full-reg',
                'ginf-sccs-top-dfp-rnd-rnd-abp-fprnd-full-reg',
                'ginf-sccs-top-cggl-full-reg', # addition
            ],
        ],
    ],
    flexible_attributes=flexible_attributes,
    single_aggregation=False,
    name='ginf-sccs-dfp-and-cggl',
)

exp.add_flexible_aggregation_report(
    algorithm_rows=[
        [
            [
                'ginf-sccs-top-sbmiasm-rl-nto-pba-fprnd-full-reg',
                'ginf-sccs-top-sbmiasm-rl-otn-pba-fprnd-full-reg',
                'ginf-sccs-top-sbmiasm-rl-rnd-pba-fprnd-full-reg',
                'ginf-sccs-top-sbmiasm-l-nto-pba-fprnd-full-reg',
                'ginf-sccs-top-sbmiasm-l-otn-pba-fprnd-full-reg',
                'ginf-sccs-top-sbmiasm-l-rnd-pba-fprnd-full-reg',
                'ginf-sccs-top-sbmiasm-rnd-nto-pba-fprnd-full-reg',
                'ginf-sccs-top-sbmiasm-rnd-otn-pba-fprnd-full-reg',
                'ginf-sccs-top-sbmiasm-rnd-rnd-pba-fprnd-full-reg',
                'ginf-sccs-top-sbmiasm-allrnd-fprnd-full-reg',
            ],
        ],
        [
            [
                'ginf-sccs-top-sbmiasm-rl-nto-abp-fprnd-full-reg',
                'ginf-sccs-top-sbmiasm-rl-otn-abp-fprnd-full-reg',
                'ginf-sccs-top-sbmiasm-rl-rnd-abp-fprnd-full-reg',
                'ginf-sccs-top-sbmiasm-l-nto-abp-fprnd-full-reg',
                'ginf-sccs-top-sbmiasm-l-otn-abp-fprnd-full-reg',
                'ginf-sccs-top-sbmiasm-l-rnd-abp-fprnd-full-reg',
                'ginf-sccs-top-sbmiasm-rnd-nto-abp-fprnd-full-reg',
                'ginf-sccs-top-sbmiasm-rnd-otn-abp-fprnd-full-reg',
                'ginf-sccs-top-sbmiasm-rnd-rnd-abp-fprnd-full-reg',
                'ginf-sccs-top-rl-full-reg', # addition
            ],
        ],
    ],
    flexible_attributes=flexible_attributes,
    single_aggregation=False,
    name='ginf-sccs-sbmiasm-and-rl',
)

exp.run_steps()
