#! /usr/bin/env python

from lab.reports import arithmetic_mean, geometric_mean, percentile_50, percentile_75, Attribute

from tools.my_experiment import MyExperiment
from tools.my_reports import FlexibleAttribute

import ms_parser_attributes
import sys
sys.path.insert(1, '../merge-strategies')
import merge_strategies_attributes
import miasm_attributes
import symmetries_attributes
sys.path.insert(1, '../merge-and-shrink-jair')
import old_mas_attributes

import math
import os.path

# Set the following variables for the experiment
REPO_NAME = 'downward/dissertation'
REVISIONS = [
    'd80160ef986e', # dissertation branch, sccs
    '34fdb310acb3', # dissertation branch, baseline+symm, dfp, dfp-symm,
    '81ab07c70f65', # dissertation branch, rest
]

CONFIGS = {}

# Create the experiment. Add parsers, fetchers or reports...
exp = MyExperiment(
    repo_name=REPO_NAME,
    configs=CONFIGS,
    revisions=REVISIONS,
    #test_suite=['depot:pfile1', 'depot:pfile2', 'gripper:prob01.pddl', 'gripper:prob02.pddl']
)
# for attributes
exp.add_search_parser('../ms-parser.py', ms_parser_attributes.get())
exp.add_search_parser('../merge-strategies/merge-strategies-parser.py', merge_strategies_attributes.get())
exp.add_search_parser('../merge-strategies/miasm-parser.py', miasm_attributes.get())
exp.add_search_parser('../merge-and-shrink-jair/old-mas-parser.py', old_mas_attributes.get())

def remove_revision(run):
    algorithm = run['algorithm']
    for rev in REVISIONS:
        algorithm = algorithm.replace('%s-' % rev, '')
    run['algorithm'] = algorithm
    return run

exp.add_fetcher(os.path.expanduser('~/experiments/dissertation/sota-b50k-miasm-and-linear-eval/'),filter=[remove_revision],filter_algorithm=[
    'b50k-cggl-fprnd-full-reg',
    'b50k-rl-fprnd-full-reg',
    'b50k-miasm-dfp-rl-nto-pba-fprnd-full-reg',
    'b50k-miasm-dfp-l-nto-abp-fprnd-full-reg',
    'symmb60cggl-b50k-full-reg',
    'symmb60rl-b50k-full-reg',
    'symmb60miasm-dfp-rl-nto-pba-b50k-full-reg',
    'symmb60miasm-dfp-l-nto-abp-b50k-full-reg',
])
exp.add_fetcher(os.path.expanduser('~/experiments/dissertation/sota-b50k-dfp-eval/'),filter=[remove_revision],filter_algorithm=[
    'b50k-dfp-rl-nto-pba-fprnd-full-reg',
    'b50k-dfp-l-nto-abp-fprnd-full-reg',
])
exp.add_fetcher(os.path.expanduser('~/experiments/dissertation/sota-b50k-sbmiasm-eval/'),filter=[remove_revision],filter_algorithm=[
    'b50k-sbmiasm-rl-otn-abp-fprnd-full-reg',
])
exp.add_fetcher(os.path.expanduser('~/experiments/dissertation/sota-b50k-remaining-overview-configs-eval/'),filter=[remove_revision],filter_algorithm=[
    'b50k-miasm-sbmiasm-rl-otn-abp-fprnd-full-reg',
    'b50k-symmb60sbmiasm-rl-otn-abp-full-reg',
    'symmb60miasm-sbmiasm-rl-otn-abp-b50k-full-reg',
])
exp.add_fetcher(os.path.expanduser('~/experiments/dissertation/sota-b50k-sccs-inc-dfp-eval/'),filter=[remove_revision],filter_algorithm=[
    'b50k-sccs-inc-dfp-rl-nto-pba-fprnd-full-reg',
])
exp.add_fetcher(os.path.expanduser('~/experiments/dissertation/sota-b50k-dfp-symm-eval/'),filter=[remove_revision],filter_algorithm=[
    'b50k-symmb60dfp-rl-nto-pba-full-reg',
    'b50k-symmb60dfp-l-nto-abp-full-reg',
])

flexible_attributes = [
    FlexibleAttribute('coverage', 'Coverage', None, absolute=True, min_wins=False, functions=[sum]),
    FlexibleAttribute('expansions_until_last_jump', 'Exp', float('inf'), absolute=False, min_wins=True, functions=[percentile_50, percentile_75]),
    FlexibleAttribute('search_time', 'Search time', None, absolute=False, min_wins=True, functions=[geometric_mean]),
    FlexibleAttribute('total_time', 'Total time', None, absolute=False, min_wins=True, functions=[geometric_mean]),
    #FlexibleAttribute('search_out_of_memory', 'Search oom', None, absolute=True, min_wins=True, functions=[sum]),
    #FlexibleAttribute('search_out_of_time', 'Search oot', None, absolute=True, min_wins=True, functions=[sum]),

    FlexibleAttribute('ms_abstraction_constructed', '\# constr', False, absolute=True, min_wins=False, functions=[sum]),
    #FlexibleAttribute('ms_atomic_construction_time', 'Atomic constr time', None, absolute=False, min_wins=True, functions=[arithmetic_mean]),
    FlexibleAttribute('ms_construction_time', 'Constr time', None, absolute=False, min_wins=True, functions=[arithmetic_mean]),
    FlexibleAttribute('ms_out_of_memory', 'Constr oom', None, absolute=True, min_wins=True, functions=[sum]),
    FlexibleAttribute('ms_out_of_time', 'Constr oot', None, absolute=True, min_wins=True, functions=[sum]),
    FlexibleAttribute('perfect_heuristic', 'Perfect h', None, absolute=True, min_wins=False),
    #FlexibleAttribute('ms_tiebreaking_iterations', 'Tiebreak it', 0, absolute=True, min_wins=True, functions=[sum]),
    #FlexibleAttribute('ms_max_int_abs_size', 'MITSS', None, absolute=False, min_wins=True, functions=[geometric_mean]),
    FlexibleAttribute('ms_linear_order', 'Linear tree', None, absolute=True, min_wins=True, functions=[sum]),
]


####### Fix problem of not started runs ##########

import os
from lab.reports.filter import FilterReport

missing_olr_tasks = ['gripper:prob02.pddl', 'pipesworld-notankage:p43-net5-b24-g3.pddl', 'satellite:p33-HC-pfile13.pddl', 'sokoban-opt08-strips:p05.pddl'] # olr
missing_nlr_tasks = ['barman-opt14-strips:p638-2.pddl', 'blocks:probBLOCKS-8-2.pddl', 'elevators-opt11-strips:p09.pddl', 'freecell:p16.pddl', 'ged-opt14-strips:d-2-3.pddl', 'ged-opt14-strips:d-8-9.pddl', 'gripper:prob02.pddl', 'miconic:s21-1.pddl', 'miconic:s6-2.pddl', 'parking-opt14-strips:p_12_7-02.pddl', 'parking-opt14-strips:p_16_9-04.pddl', 'pathways-noneg:p07.pddl', 'psr-small:p10-s17-n2-l2-f30.pddl', 'satellite:p23-HC-pfile3.pddl', 'satellite:p33-HC-pfile13.pddl', 'tetris-opt14-strips:p03-4.pddl', 'transport-opt08-strips:p23.pddl', 'visitall-opt14-strips:p-1-12.pddl'] # nlr
missing_sota_tasks = ['airport:p10-airport3-p1.pddl', 'barman-opt11-strips:pfile04-015.pddl', 'blocks:probBLOCKS-14-1.pddl', 'driverlog:p04.pddl', 'elevators-opt08-strips:p27.pddl', 'elevators-opt11-strips:p05.pddl', 'elevators-opt11-strips:p15.pddl', 'floortile-opt11-strips:opt-p08-015.pddl', 'grid:prob04.pddl', 'hiking-opt14-strips:ptesting-2-4-6.pddl', 'logistics00:probLOGISTICS-13-1.pddl', 'logistics98:prob09.pddl', 'miconic:s22-2.pddl', 'miconic:s26-4.pddl', 'miconic:s28-0.pddl', 'movie:prob13.pddl', 'nomystery-opt11-strips:p16.pddl', 'openstacks-opt08-strips:p20.pddl', 'openstacks-opt14-strips:p20_2.pddl', 'openstacks-strips:p05.pddl', 'parcprinter-08-strips:p07.pddl', 'pegsol-08-strips:p18.pddl', 'pegsol-opt11-strips:p07.pddl', 'pipesworld-notankage:p11-net2-b10-g2.pddl', 'psr-small:p25-s40-n3-l4-f10.pddl', 'rovers:p09.pddl', 'satellite:p19-pfile19.pddl', 'satellite:p21-HC-pfile1.pddl', 'satellite:p33-HC-pfile13.pddl', 'scanalyzer-opt11-strips:p03.pddl', 'sokoban-opt11-strips:p16.pddl', 'sokoban-opt11-strips:p18.pddl', 'tidybot-opt11-strips:p15.pddl', 'tpp:p11.pddl', 'transport-opt08-strips:p08.pddl', 'transport-opt14-strips:p13.pddl', 'zenotravel:p09.pddl'] # sota

missing_olr_algorithms = ['olr-b50k-cggl', 'olr-b50k-cggl-nolr', 'olr-b50k-gcgl', 'olr-b50k-gcgl-nolr', 'olr-b50k-l', 'olr-b50k-l-nolr', 'olr-b50k-rl', 'olr-b50k-rl-nolr', 'olr-f50k-cggl', 'olr-f50k-cggl-nolr', 'olr-f50k-gcgl', 'olr-f50k-gcgl-nolr', 'olr-f50k-l', 'olr-f50k-l-nolr', 'olr-f50k-rl', 'olr-f50k-rl-nolr', 'olr-ginf-cggl', 'olr-ginf-cggl-nolr', 'olr-ginf-gcgl', 'olr-ginf-gcgl-nolr', 'olr-ginf-l', 'olr-ginf-l-nolr', 'olr-ginf-rl', 'olr-ginf-rl-nolr'] # olr
missing_nlr_algorithms = ['nlr-b50k-cggl-2ts', 'nlr-b50k-cggl-fprnd', 'nlr-b50k-cggl-nolr', 'nlr-b50k-cggl-oncernd', 'nlr-b50k-dfp-2ts', 'nlr-b50k-dfp-fprnd', 'nlr-b50k-dfp-nolr', 'nlr-b50k-dfp-oncernd', 'nlr-b50k-gcgl-2ts', 'nlr-b50k-gcgl-fprnd', 'nlr-b50k-gcgl-nolr', 'nlr-b50k-gcgl-oncernd', 'nlr-b50k-l-2ts', 'nlr-b50k-l-fprnd', 'nlr-b50k-l-nolr', 'nlr-b50k-l-oncernd', 'nlr-b50k-miasm-2ts', 'nlr-b50k-miasm-fprnd', 'nlr-b50k-miasm-nolr', 'nlr-b50k-miasm-oncernd', 'nlr-b50k-rl-2ts', 'nlr-b50k-rl-fprnd', 'nlr-b50k-rl-nolr', 'nlr-b50k-rl-oncernd', 'nlr-b50k-symmb60cggl-largest-nonlinear-fprnd', 'nlr-b50k-symmb60cggl-smallest-nonlinear-fprnd', 'nlr-b50k-symmb60dfp-largest-nonlinear-fprnd', 'nlr-b50k-symmb60dfp-smallest-nonlinear-fprnd', 'nlr-b50k-symmb60gcgl-largest-nonlinear-fprnd', 'nlr-b50k-symmb60gcgl-smallest-nonlinear-fprnd', 'nlr-b50k-symmb60l-largest-nonlinear-fprnd', 'nlr-b50k-symmb60l-smallest-nonlinear-fprnd', 'nlr-b50k-symmb60miasm-largest-nonlinear-fprnd', 'nlr-b50k-symmb60miasm-smallest-nonlinear-fprnd', 'nlr-b50k-symmb60rl-largest-nonlinear-fprnd', 'nlr-b50k-symmb60rl-smallest-nonlinear-fprnd', 'nlr-b50k-symmi1cggl-largest-nonlinear-fprnd', 'nlr-b50k-symmi1cggl-smallest-nonlinear-fprnd', 'nlr-b50k-symmi1dfp-largest-nonlinear-fprnd', 'nlr-b50k-symmi1dfp-smallest-nonlinear-fprnd', 'nlr-b50k-symmi1gcgl-largest-nonlinear-fprnd', 'nlr-b50k-symmi1gcgl-smallest-nonlinear-fprnd', 'nlr-b50k-symmi1l-largest-nonlinear-fprnd', 'nlr-b50k-symmi1l-smallest-nonlinear-fprnd', 'nlr-b50k-symmi1miasm-largest-nonlinear-fprnd', 'nlr-b50k-symmi1miasm-smallest-nonlinear-fprnd', 'nlr-b50k-symmi1rl-largest-nonlinear-fprnd', 'nlr-b50k-symmi1rl-smallest-nonlinear-fprnd', 'nlr-f50k-cggl-2ts', 'nlr-f50k-cggl-fprnd', 'nlr-f50k-cggl-nolr', 'nlr-f50k-cggl-oncernd', 'nlr-f50k-dfp-2ts', 'nlr-f50k-dfp-fprnd', 'nlr-f50k-dfp-nolr', 'nlr-f50k-dfp-oncernd', 'nlr-f50k-gcgl-2ts', 'nlr-f50k-gcgl-fprnd', 'nlr-f50k-gcgl-nolr', 'nlr-f50k-gcgl-oncernd', 'nlr-f50k-l-2ts', 'nlr-f50k-l-fprnd', 'nlr-f50k-l-nolr', 'nlr-f50k-l-oncernd', 'nlr-f50k-miasm-2ts', 'nlr-f50k-miasm-fprnd', 'nlr-f50k-miasm-nolr', 'nlr-f50k-miasm-oncernd', 'nlr-f50k-rl-2ts', 'nlr-f50k-rl-fprnd', 'nlr-f50k-rl-nolr', 'nlr-f50k-rl-oncernd', 'nlr-f50k-symmb60cggl-largest-nonlinear-fprnd', 'nlr-f50k-symmb60dfp-largest-nonlinear-fprnd', 'nlr-f50k-symmb60gcgl-largest-nonlinear-fprnd', 'nlr-f50k-symmb60l-largest-nonlinear-fprnd', 'nlr-f50k-symmb60miasm-largest-nonlinear-fprnd', 'nlr-f50k-symmb60rl-largest-nonlinear-fprnd', 'nlr-ginf-cggl-2ts', 'nlr-ginf-cggl-fprnd', 'nlr-ginf-cggl-nolr', 'nlr-ginf-cggl-oncernd', 'nlr-ginf-dfp-2ts', 'nlr-ginf-dfp-fprnd', 'nlr-ginf-dfp-nolr', 'nlr-ginf-dfp-oncernd', 'nlr-ginf-gcgl-2ts', 'nlr-ginf-gcgl-fprnd', 'nlr-ginf-gcgl-nolr', 'nlr-ginf-gcgl-oncernd', 'nlr-ginf-l-2ts', 'nlr-ginf-l-fprnd', 'nlr-ginf-l-nolr', 'nlr-ginf-l-oncernd', 'nlr-ginf-miasm-2ts', 'nlr-ginf-miasm-fprnd', 'nlr-ginf-miasm-nolr', 'nlr-ginf-miasm-oncernd', 'nlr-ginf-rl-2ts', 'nlr-ginf-rl-fprnd', 'nlr-ginf-rl-nolr', 'nlr-ginf-rl-oncernd', 'nlr-ginf-symmb60cggl-largest-nonlinear-fprnd', 'nlr-ginf-symmb60dfp-largest-nonlinear-fprnd', 'nlr-ginf-symmb60gcgl-largest-nonlinear-fprnd', 'nlr-ginf-symmb60l-largest-nonlinear-fprnd', 'nlr-ginf-symmb60miasm-largest-nonlinear-fprnd', 'nlr-ginf-symmb60rl-largest-nonlinear-fprnd'] # nlr
missing_sota_algorithms = ['b50k-cggl-fprnd-full-reg', 'b50k-dfp-allrnd-fprnd-full-reg', 'b50k-dfp-l-nto-abp-fprnd-full-reg', 'b50k-dfp-l-nto-pba-fprnd-full-reg', 'b50k-dfp-l-otn-abp-fprnd-full-reg', 'b50k-dfp-l-otn-pba-fprnd-full-reg', 'b50k-dfp-l-rnd-abp-fprnd-full-reg', 'b50k-dfp-l-rnd-pba-fprnd-full-reg', 'b50k-dfp-rl-nto-abp-fprnd-full-reg', 'b50k-dfp-rl-nto-pba-fprnd-full-reg', 'b50k-dfp-rl-otn-abp-fprnd-full-reg', 'b50k-dfp-rl-otn-pba-fprnd-full-reg', 'b50k-dfp-rl-rnd-abp-fprnd-full-reg', 'b50k-dfp-rl-rnd-pba-fprnd-full-reg', 'b50k-dfp-rnd-nto-abp-fprnd-full-reg', 'b50k-dfp-rnd-nto-pba-fprnd-full-reg', 'b50k-dfp-rnd-otn-abp-fprnd-full-reg', 'b50k-dfp-rnd-otn-pba-fprnd-full-reg', 'b50k-dfp-rnd-rnd-abp-fprnd-full-reg', 'b50k-dfp-rnd-rnd-pba-fprnd-full-reg', 'b50k-gcgl-fprnd-full-reg', 'b50k-l-fprnd-full-reg', 'b50k-miasm-dfp-l-nto-abp-fprnd-full-reg', 'b50k-miasm-dfp-rl-nto-pba-fprnd-full-reg', 'b50k-rl-fprnd-full-reg', 'b50k-sccs-dec-cggl-full-reg', 'b50k-sccs-dec-dfp-allrnd-fprnd-full-reg', 'b50k-sccs-dec-dfp-l-nto-abp-fprnd-full-reg', 'b50k-sccs-dec-dfp-l-nto-pba-fprnd-full-reg', 'b50k-sccs-dec-dfp-l-otn-abp-fprnd-full-reg', 'b50k-sccs-dec-dfp-l-otn-pba-fprnd-full-reg', 'b50k-sccs-dec-dfp-l-rnd-abp-fprnd-full-reg', 'b50k-sccs-dec-dfp-l-rnd-pba-fprnd-full-reg', 'b50k-sccs-dec-dfp-rl-nto-abp-fprnd-full-reg', 'b50k-sccs-dec-dfp-rl-nto-pba-fprnd-full-reg', 'b50k-sccs-dec-dfp-rl-otn-abp-fprnd-full-reg', 'b50k-sccs-dec-dfp-rl-otn-pba-fprnd-full-reg', 'b50k-sccs-dec-dfp-rl-rnd-abp-fprnd-full-reg', 'b50k-sccs-dec-dfp-rl-rnd-pba-fprnd-full-reg', 'b50k-sccs-dec-dfp-rnd-nto-abp-fprnd-full-reg', 'b50k-sccs-dec-dfp-rnd-nto-pba-fprnd-full-reg', 'b50k-sccs-dec-dfp-rnd-otn-abp-fprnd-full-reg', 'b50k-sccs-dec-dfp-rnd-otn-pba-fprnd-full-reg', 'b50k-sccs-dec-dfp-rnd-rnd-abp-fprnd-full-reg', 'b50k-sccs-dec-dfp-rnd-rnd-pba-fprnd-full-reg', 'b50k-sccs-dec-gcgl-full-reg', 'b50k-sccs-dec-l-full-reg', 'b50k-sccs-dec-rl-full-reg', 'b50k-sccs-dec-sbmiasm-allrnd-fprnd-full-reg', 'b50k-sccs-dec-sbmiasm-l-nto-abp-fprnd-full-reg', 'b50k-sccs-dec-sbmiasm-l-nto-pba-fprnd-full-reg', 'b50k-sccs-dec-sbmiasm-l-otn-abp-fprnd-full-reg', 'b50k-sccs-dec-sbmiasm-l-otn-pba-fprnd-full-reg', 'b50k-sccs-dec-sbmiasm-l-rnd-abp-fprnd-full-reg', 'b50k-sccs-dec-sbmiasm-l-rnd-pba-fprnd-full-reg', 'b50k-sccs-dec-sbmiasm-rl-nto-abp-fprnd-full-reg', 'b50k-sccs-dec-sbmiasm-rl-nto-pba-fprnd-full-reg', 'b50k-sccs-dec-sbmiasm-rl-otn-abp-fprnd-full-reg', 'b50k-sccs-dec-sbmiasm-rl-otn-pba-fprnd-full-reg', 'b50k-sccs-dec-sbmiasm-rl-rnd-abp-fprnd-full-reg', 'b50k-sccs-dec-sbmiasm-rl-rnd-pba-fprnd-full-reg', 'b50k-sccs-dec-sbmiasm-rnd-nto-abp-fprnd-full-reg', 'b50k-sccs-dec-sbmiasm-rnd-nto-pba-fprnd-full-reg', 'b50k-sccs-dec-sbmiasm-rnd-otn-abp-fprnd-full-reg', 'b50k-sccs-dec-sbmiasm-rnd-otn-pba-fprnd-full-reg', 'b50k-sccs-dec-sbmiasm-rnd-rnd-abp-fprnd-full-reg', 'b50k-sccs-dec-sbmiasm-rnd-rnd-pba-fprnd-full-reg', 'b50k-sccs-inc-cggl-full-reg', 'b50k-sccs-inc-dfp-allrnd-fprnd-full-reg', 'b50k-sccs-inc-dfp-l-nto-abp-fprnd-full-reg', 'b50k-sccs-inc-dfp-l-nto-pba-fprnd-full-reg', 'b50k-sccs-inc-dfp-l-otn-abp-fprnd-full-reg', 'b50k-sccs-inc-dfp-l-otn-pba-fprnd-full-reg', 'b50k-sccs-inc-dfp-l-rnd-abp-fprnd-full-reg', 'b50k-sccs-inc-dfp-l-rnd-pba-fprnd-full-reg', 'b50k-sccs-inc-dfp-rl-nto-abp-fprnd-full-reg', 'b50k-sccs-inc-dfp-rl-nto-pba-fprnd-full-reg', 'b50k-sccs-inc-dfp-rl-otn-abp-fprnd-full-reg', 'b50k-sccs-inc-dfp-rl-otn-pba-fprnd-full-reg', 'b50k-sccs-inc-dfp-rl-rnd-abp-fprnd-full-reg', 'b50k-sccs-inc-dfp-rl-rnd-pba-fprnd-full-reg', 'b50k-sccs-inc-dfp-rnd-nto-abp-fprnd-full-reg', 'b50k-sccs-inc-dfp-rnd-nto-pba-fprnd-full-reg', 'b50k-sccs-inc-dfp-rnd-otn-abp-fprnd-full-reg', 'b50k-sccs-inc-dfp-rnd-otn-pba-fprnd-full-reg', 'b50k-sccs-inc-dfp-rnd-rnd-abp-fprnd-full-reg', 'b50k-sccs-inc-dfp-rnd-rnd-pba-fprnd-full-reg', 'b50k-sccs-inc-gcgl-full-reg', 'b50k-sccs-inc-l-full-reg', 'b50k-sccs-inc-rl-full-reg', 'b50k-sccs-revtop-cggl-full-reg', 'b50k-sccs-revtop-dfp-allrnd-fprnd-full-reg', 'b50k-sccs-revtop-dfp-l-nto-abp-fprnd-full-reg', 'b50k-sccs-revtop-dfp-l-nto-pba-fprnd-full-reg', 'b50k-sccs-revtop-dfp-l-otn-abp-fprnd-full-reg', 'b50k-sccs-revtop-dfp-l-otn-pba-fprnd-full-reg', 'b50k-sccs-revtop-dfp-l-rnd-abp-fprnd-full-reg', 'b50k-sccs-revtop-dfp-l-rnd-pba-fprnd-full-reg', 'b50k-sccs-revtop-dfp-rl-nto-abp-fprnd-full-reg', 'b50k-sccs-revtop-dfp-rl-nto-pba-fprnd-full-reg', 'b50k-sccs-revtop-dfp-rl-otn-abp-fprnd-full-reg', 'b50k-sccs-revtop-dfp-rl-otn-pba-fprnd-full-reg', 'b50k-sccs-revtop-dfp-rl-rnd-abp-fprnd-full-reg', 'b50k-sccs-revtop-dfp-rl-rnd-pba-fprnd-full-reg', 'b50k-sccs-revtop-dfp-rnd-nto-abp-fprnd-full-reg', 'b50k-sccs-revtop-dfp-rnd-nto-pba-fprnd-full-reg', 'b50k-sccs-revtop-dfp-rnd-otn-abp-fprnd-full-reg', 'b50k-sccs-revtop-dfp-rnd-otn-pba-fprnd-full-reg', 'b50k-sccs-revtop-dfp-rnd-rnd-abp-fprnd-full-reg', 'b50k-sccs-revtop-dfp-rnd-rnd-pba-fprnd-full-reg', 'b50k-sccs-revtop-gcgl-full-reg', 'b50k-sccs-revtop-l-full-reg', 'b50k-sccs-revtop-rl-full-reg', 'b50k-sccs-revtop-sbmiasm-allrnd-fprnd-full-reg', 'b50k-sccs-revtop-sbmiasm-l-nto-abp-fprnd-full-reg', 'b50k-sccs-revtop-sbmiasm-l-nto-pba-fprnd-full-reg', 'b50k-sccs-revtop-sbmiasm-l-otn-abp-fprnd-full-reg', 'b50k-sccs-revtop-sbmiasm-l-otn-pba-fprnd-full-reg', 'b50k-sccs-revtop-sbmiasm-l-rnd-abp-fprnd-full-reg', 'b50k-sccs-revtop-sbmiasm-l-rnd-pba-fprnd-full-reg', 'b50k-sccs-revtop-sbmiasm-rl-nto-abp-fprnd-full-reg', 'b50k-sccs-revtop-sbmiasm-rl-nto-pba-fprnd-full-reg', 'b50k-sccs-revtop-sbmiasm-rl-otn-abp-fprnd-full-reg', 'b50k-sccs-revtop-sbmiasm-rl-otn-pba-fprnd-full-reg', 'b50k-sccs-revtop-sbmiasm-rl-rnd-abp-fprnd-full-reg', 'b50k-sccs-revtop-sbmiasm-rl-rnd-pba-fprnd-full-reg', 'b50k-sccs-revtop-sbmiasm-rnd-nto-abp-fprnd-full-reg', 'b50k-sccs-revtop-sbmiasm-rnd-nto-pba-fprnd-full-reg', 'b50k-sccs-revtop-sbmiasm-rnd-otn-abp-fprnd-full-reg', 'b50k-sccs-revtop-sbmiasm-rnd-otn-pba-fprnd-full-reg', 'b50k-sccs-revtop-sbmiasm-rnd-rnd-abp-fprnd-full-reg', 'b50k-sccs-revtop-sbmiasm-rnd-rnd-pba-fprnd-full-reg', 'b50k-sccs-top-cggl-full-reg', 'b50k-sccs-top-dfp-allrnd-fprnd-full-reg', 'b50k-sccs-top-dfp-l-nto-abp-fprnd-full-reg', 'b50k-sccs-top-dfp-l-nto-pba-fprnd-full-reg', 'b50k-sccs-top-dfp-l-otn-abp-fprnd-full-reg', 'b50k-sccs-top-dfp-l-otn-pba-fprnd-full-reg', 'b50k-sccs-top-dfp-l-rnd-abp-fprnd-full-reg', 'b50k-sccs-top-dfp-l-rnd-pba-fprnd-full-reg', 'b50k-sccs-top-dfp-rl-nto-abp-fprnd-full-reg', 'b50k-sccs-top-dfp-rl-nto-pba-fprnd-full-reg', 'b50k-sccs-top-dfp-rl-otn-abp-fprnd-full-reg', 'b50k-sccs-top-dfp-rl-otn-pba-fprnd-full-reg', 'b50k-sccs-top-dfp-rl-rnd-abp-fprnd-full-reg', 'b50k-sccs-top-dfp-rl-rnd-pba-fprnd-full-reg', 'b50k-sccs-top-dfp-rnd-nto-abp-fprnd-full-reg', 'b50k-sccs-top-dfp-rnd-nto-pba-fprnd-full-reg', 'b50k-sccs-top-dfp-rnd-otn-abp-fprnd-full-reg', 'b50k-sccs-top-dfp-rnd-otn-pba-fprnd-full-reg', 'b50k-sccs-top-dfp-rnd-rnd-abp-fprnd-full-reg', 'b50k-sccs-top-dfp-rnd-rnd-pba-fprnd-full-reg', 'b50k-sccs-top-gcgl-full-reg', 'b50k-sccs-top-l-full-reg', 'b50k-sccs-top-rl-full-reg', 'b50k-sccs-top-sbmiasm-allrnd-fprnd-full-reg', 'b50k-sccs-top-sbmiasm-l-nto-abp-fprnd-full-reg', 'b50k-sccs-top-sbmiasm-l-nto-pba-fprnd-full-reg', 'b50k-sccs-top-sbmiasm-l-otn-abp-fprnd-full-reg', 'b50k-sccs-top-sbmiasm-l-otn-pba-fprnd-full-reg', 'b50k-sccs-top-sbmiasm-l-rnd-abp-fprnd-full-reg', 'b50k-sccs-top-sbmiasm-l-rnd-pba-fprnd-full-reg', 'b50k-sccs-top-sbmiasm-rl-nto-abp-fprnd-full-reg', 'b50k-sccs-top-sbmiasm-rl-nto-pba-fprnd-full-reg', 'b50k-sccs-top-sbmiasm-rl-otn-abp-fprnd-full-reg', 'b50k-sccs-top-sbmiasm-rl-otn-pba-fprnd-full-reg', 'b50k-sccs-top-sbmiasm-rl-rnd-abp-fprnd-full-reg', 'b50k-sccs-top-sbmiasm-rl-rnd-pba-fprnd-full-reg', 'b50k-sccs-top-sbmiasm-rnd-nto-abp-fprnd-full-reg', 'b50k-sccs-top-sbmiasm-rnd-nto-pba-fprnd-full-reg', 'b50k-sccs-top-sbmiasm-rnd-otn-abp-fprnd-full-reg', 'b50k-sccs-top-sbmiasm-rnd-otn-pba-fprnd-full-reg', 'b50k-sccs-top-sbmiasm-rnd-rnd-abp-fprnd-full-reg', 'b50k-sccs-top-sbmiasm-rnd-rnd-pba-fprnd-full-reg', 'b50k-slone5-dfp-rl-nto-pba-fprnd-pirr-reg', 'b50k-symmb60cggl-largest-secondary-fprnd-full-reg', 'b50k-symmb60cggl-smallest-secondary-fprnd-full-reg', 'b50k-symmb60dfp-l-nto-abp-full-reg', 'b50k-symmb60dfp-l-nto-abp-largest-secondary-fprnd-full-reg', 'b50k-symmb60dfp-l-nto-abp-smallest-secondary-fprnd-full-reg', 'b50k-symmb60dfp-rl-nto-pba-full-reg', 'b50k-symmb60dfp-rl-nto-pba-largest-secondary-fprnd-full-reg', 'b50k-symmb60dfp-rl-nto-pba-smallest-secondary-fprnd-full-reg', 'b50k-symmb60gcgl-largest-secondary-fprnd-full-reg', 'b50k-symmb60gcgl-smallest-secondary-fprnd-full-reg', 'b50k-symmb60l-largest-secondary-fprnd-full-reg', 'b50k-symmb60l-smallest-secondary-fprnd-full-reg', 'b50k-symmb60rl-largest-secondary-fprnd-full-reg', 'b50k-symmb60rl-smallest-secondary-fprnd-full-reg', 'b50k-symmb60sbmiasm-rl-nto-pba-largest-secondary-fprnd-full-reg', 'b50k-symmb60sbmiasm-rl-nto-pba-smallest-secondary-fprnd-full-reg', 'b50k-symmi1cggl-largest-secondary-fprnd-full-reg', 'b50k-symmi1cggl-smallest-secondary-fprnd-full-reg', 'b50k-symmi1dfp-l-nto-abp-largest-secondary-fprnd-full-reg', 'b50k-symmi1dfp-l-nto-abp-smallest-secondary-fprnd-full-reg', 'b50k-symmi1dfp-rl-nto-pba-largest-secondary-fprnd-full-reg', 'b50k-symmi1dfp-rl-nto-pba-smallest-secondary-fprnd-full-reg', 'b50k-symmi1gcgl-largest-secondary-fprnd-full-reg', 'b50k-symmi1gcgl-smallest-secondary-fprnd-full-reg', 'b50k-symmi1l-largest-secondary-fprnd-full-reg', 'b50k-symmi1l-smallest-secondary-fprnd-full-reg', 'b50k-symmi1rl-largest-secondary-fprnd-full-reg', 'b50k-symmi1rl-smallest-secondary-fprnd-full-reg', 'b50k-symmi1sbmiasm-rl-nto-pba-largest-secondary-fprnd-full-reg', 'b50k-symmi1sbmiasm-rl-nto-pba-smallest-secondary-fprnd-full-reg', 'f50k-cggl-fprnd-full-reg', 'f50k-dfp-allrnd-fprnd-full-reg', 'f50k-dfp-l-nto-abp-fprnd-full-reg', 'f50k-dfp-l-nto-pba-fprnd-full-reg', 'f50k-dfp-l-otn-abp-fprnd-full-reg', 'f50k-dfp-l-otn-pba-fprnd-full-reg', 'f50k-dfp-l-rnd-abp-fprnd-full-reg', 'f50k-dfp-l-rnd-pba-fprnd-full-reg', 'f50k-dfp-rl-nto-abp-fprnd-full-reg', 'f50k-dfp-rl-nto-pba-fprnd-full-reg', 'f50k-dfp-rl-otn-abp-fprnd-full-reg', 'f50k-dfp-rl-otn-pba-fprnd-full-reg', 'f50k-dfp-rl-rnd-abp-fprnd-full-reg', 'f50k-dfp-rl-rnd-pba-fprnd-full-reg', 'f50k-dfp-rnd-nto-abp-fprnd-full-reg', 'f50k-dfp-rnd-nto-pba-fprnd-full-reg', 'f50k-dfp-rnd-otn-abp-fprnd-full-reg', 'f50k-dfp-rnd-otn-pba-fprnd-full-reg', 'f50k-dfp-rnd-rnd-abp-fprnd-full-reg', 'f50k-dfp-rnd-rnd-pba-fprnd-full-reg', 'f50k-gcgl-fprnd-full-reg', 'f50k-l-fprnd-full-reg', 'f50k-miasm-dfp-l-nto-abp-fprnd-full-reg', 'f50k-miasm-dfp-rl-nto-pba-fprnd-full-reg', 'f50k-rl-fprnd-full-reg', 'f50k-symmb60cggl-fprnd-full-reg', 'f50k-symmb60dfp-l-nto-abp-fprnd-full-reg', 'f50k-symmb60dfp-rl-nto-pba-fprnd-full-reg', 'f50k-symmb60gcgl-fprnd-full-reg', 'f50k-symmb60l-fprnd-full-reg', 'f50k-symmb60miasm-dfp-l-nto-abp-fprnd-full-reg', 'f50k-symmb60miasm-dfp-rl-nto-pba-fprnd-full-reg', 'f50k-symmb60rl-fprnd-full-reg', 'ginf-cggl-fprnd-full-reg', 'ginf-dfp-allrnd-fprnd-full-reg', 'ginf-dfp-l-nto-abp-fprnd-full-reg', 'ginf-dfp-l-nto-pba-fprnd-full-reg', 'ginf-dfp-l-otn-abp-fprnd-full-reg', 'ginf-dfp-l-otn-pba-fprnd-full-reg', 'ginf-dfp-l-rnd-abp-fprnd-full-reg', 'ginf-dfp-l-rnd-pba-fprnd-full-reg', 'ginf-dfp-rl-nto-abp-fprnd-full-reg', 'ginf-dfp-rl-nto-pba-fprnd-full-reg', 'ginf-dfp-rl-otn-abp-fprnd-full-reg', 'ginf-dfp-rl-otn-pba-fprnd-full-reg', 'ginf-dfp-rl-rnd-abp-fprnd-full-reg', 'ginf-dfp-rl-rnd-pba-fprnd-full-reg', 'ginf-dfp-rnd-nto-abp-fprnd-full-reg', 'ginf-dfp-rnd-nto-pba-fprnd-full-reg', 'ginf-dfp-rnd-otn-abp-fprnd-full-reg', 'ginf-dfp-rnd-otn-pba-fprnd-full-reg', 'ginf-dfp-rnd-rnd-abp-fprnd-full-reg', 'ginf-dfp-rnd-rnd-pba-fprnd-full-reg', 'ginf-gcgl-fprnd-full-reg', 'ginf-l-fprnd-full-reg', 'ginf-miasm-dfp-l-nto-abp-fprnd-full-reg', 'ginf-miasm-dfp-rl-nto-pba-fprnd-full-reg', 'ginf-rl-fprnd-full-reg', 'ginf-symmb60cggl-fprnd-full-reg', 'ginf-symmb60dfp-l-nto-abp-fprnd-full-reg', 'ginf-symmb60dfp-rl-nto-pba-fprnd-full-reg', 'ginf-symmb60gcgl-fprnd-full-reg', 'ginf-symmb60l-fprnd-full-reg', 'ginf-symmb60miasm-dfp-l-nto-abp-fprnd-full-reg', 'ginf-symmb60miasm-dfp-rl-nto-pba-fprnd-full-reg', 'ginf-symmb60rl-fprnd-full-reg', 'symmb60cggl-b50k-full-reg', 'symmb60gcgl-b50k-full-reg', 'symmb60l-b50k-full-reg', 'symmb60miasm-dfp-l-nto-abp-b50k-full-reg', 'symmb60miasm-dfp-rl-nto-pba-b50k-full-reg', 'symmb60rl-b50k-full-reg'] # sota

def remove_faulty_runs(run):
    algorithm = run['algorithm']
    domain_task = '{}:{}'.format(run['domain'], run['problem'])
    if (algorithm in missing_olr_algorithms and domain_task in missing_olr_tasks) or (algorithm in missing_nlr_algorithms and domain_task in missing_nlr_tasks) or (algorithm in missing_sota_algorithms and domain_task in missing_sota_tasks):
        #print "excluding run {} {}".format(algorithm, domain_task)
        return False
    return True

def remove_fixed_runs_revision(run):
    algorithm = run['algorithm']
    algorithm = algorithm.replace('81ab07c70f65-', '')
    run['algorithm'] = algorithm
    return run

exp.add_report(FilterReport(filter=[remove_faulty_runs]),outfile=os.path.join(exp.eval_dir, 'fixed-properties'))
exp.add_fetcher(os.path.expanduser('~/experiments/dissertation/olr-missing-runs-eval'),filter=[remove_fixed_runs_revision])
exp.add_fetcher(os.path.expanduser('~/experiments/dissertation/nlr-missing-runs-eval'),filter=[remove_fixed_runs_revision])
exp.add_fetcher(os.path.expanduser('~/experiments/dissertation/sota-missing-runs-eval'),filter=[remove_fixed_runs_revision])


###### HTML tables ###################################################

exp.add_absolute_report(
    attributes=['coverage'],
    publish=False,
)


####### Paper tables #################################################

exp.add_flexible_aggregation_report(
    algorithm_rows=[
        [
            [
                # pure
                'b50k-cggl-fprnd-full-reg',
                'b50k-rl-fprnd-full-reg',
                'b50k-dfp-rl-nto-pba-fprnd-full-reg',
                'b50k-dfp-l-nto-abp-fprnd-full-reg',
                'b50k-sbmiasm-rl-otn-abp-fprnd-full-reg',
                'b50k-miasm-dfp-rl-nto-pba-fprnd-full-reg',
                'b50k-miasm-dfp-l-nto-abp-fprnd-full-reg',
                'b50k-miasm-sbmiasm-rl-otn-abp-fprnd-full-reg',
                'b50k-sccs-inc-dfp-rl-nto-pba-fprnd-full-reg',
            ],
        ],
        [
            [
                # symm
                'symmb60cggl-b50k-full-reg',
                'symmb60rl-b50k-full-reg',
                'b50k-symmb60dfp-rl-nto-pba-full-reg',
                'b50k-symmb60dfp-l-nto-abp-full-reg',
                'b50k-symmb60sbmiasm-rl-otn-abp-full-reg',
                'symmb60miasm-dfp-rl-nto-pba-b50k-full-reg',
                'symmb60miasm-dfp-l-nto-abp-b50k-full-reg',
                'symmb60miasm-sbmiasm-rl-otn-abp-b50k-full-reg',
                # no sccs
            ],
        ],
    ],
    flexible_attributes=flexible_attributes,
    single_aggregation=False,
    #name='',
)

exp.run_steps()
