#! /usr/bin/env python

from tools.my_experiment import MyExperiment
import ms_parser_attributes
import sys
sys.path.insert(1, '../merge-and-shrink-jair')
import old_mas_attributes

# Set the following variables for the experiment
REPO_NAME = 'downward/diss'
REVISIONS = ['34fdb310acb3']

CONFIGS = {
    'olr-f50k-cggl': ['--search', 'astar(olr_merge_and_shrink(variable_order=cg_goal_level,shrink_strategy=olr_shrink_fh(max_states=50000)))'],
    'olr-f50k-gcgl': ['--search', 'astar(olr_merge_and_shrink(variable_order=goal_cg_level,shrink_strategy=olr_shrink_fh(max_states=50000)))'],
    'olr-f50k-l': ['--search', 'astar(olr_merge_and_shrink(variable_order=level,shrink_strategy=olr_shrink_fh(max_states=50000)))'],
    'olr-f50k-rl': ['--search', 'astar(olr_merge_and_shrink(variable_order=reverse_level,shrink_strategy=olr_shrink_fh(max_states=50000)))'],
    'olr-f50k-cggl-nolr': ['--search', 'astar(olr_merge_and_shrink(variable_order=cg_goal_level,shrink_strategy=olr_shrink_fh(max_states=50000),reduce_labels=false))'],
    'olr-f50k-gcgl-nolr': ['--search', 'astar(olr_merge_and_shrink(variable_order=goal_cg_level,shrink_strategy=olr_shrink_fh(max_states=50000),reduce_labels=false))'],
    'olr-f50k-l-nolr': ['--search', 'astar(olr_merge_and_shrink(variable_order=level,shrink_strategy=olr_shrink_fh(max_states=50000),reduce_labels=false))'],
    'olr-f50k-rl-nolr': ['--search', 'astar(olr_merge_and_shrink(variable_order=reverse_level,shrink_strategy=olr_shrink_fh(max_states=50000),reduce_labels=false))'],
}

# Create the experiment. Add parsers, fetchers or reports...
exp = MyExperiment(
    repo_name=REPO_NAME,
    configs=CONFIGS,
    revisions=REVISIONS,
    test_suite=['depot:p01.pddl', 'depot:p02.pddl', 'parcprinter-opt11-strips:p01.pddl', 'parcprinter-opt11-strips:p02.pddl', 'mystery:prob07.pddl']
)
exp.add_search_parser('../ms-parser.py', ms_parser_attributes.get())
exp.add_search_parser('../merge-and-shrink-jair/old-mas-parser.py', old_mas_attributes.get())

exp.add_absolute_report()

exp.run_steps()
