#! /usr/bin/env python

from tools.my_experiment import MyExperiment
import ms_parser_attributes
import sys
sys.path.insert(1, '../merge-strategies')
import symmetries_attributes
sys.path.insert(1, '../merge-and-shrink-jair')
import old_mas_attributes

# Set the following variables for the experiment
REPO_NAME = 'downward/diss'
REVISIONS = ['81ab07c70f65']

CONFIGS = {'nlr-f50k-miasm-nolr': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_miasm,sum_computation_bound=1000000,shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_method=none))'],
'nlr-b50k-symmi1miasm-smallest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_miasm(build_stabilized_pdg=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,stop_after_no_symmetries=false,symmetries_for_merging=smallest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-ginf-rl-2ts': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=reverse_level),shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_method=two_abstractions))'],
'nlr-b50k-symmb60l-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=level,build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-f50k-symmb60rl-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=reverse_level,build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
'nlr-b50k-rl-2ts': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=reverse_level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=two_abstractions))'],
'nlr-b50k-dfp-nolr': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_dfp,shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=none))'],
'nlr-b50k-symmi1l-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=level,build_stabilized_pdg=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-ginf-dfp-nolr': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_dfp,shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_method=none))'],
'nlr-b50k-miasm-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_miasm,sum_computation_bound=1000000,shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-ginf-miasm-2ts': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_miasm,sum_computation_bound=1000000,shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_method=two_abstractions))'],
'nlr-b50k-symmb60cggl-smallest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=cg_goal_level,build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=smallest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-ginf-cggl-2ts': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=cg_goal_level),shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_method=two_abstractions))'],
'nlr-f50k-miasm-oncernd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_miasm,sum_computation_bound=1000000,shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_method=all_abstractions,label_reduction_system_order=random))'],
'nlr-ginf-miasm-nolr': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_miasm,sum_computation_bound=1000000,shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_method=none))'],
'nlr-f50k-dfp-oncernd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_dfp,shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_method=all_abstractions,label_reduction_system_order=random))'],
'nlr-b50k-symmb60rl-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=reverse_level,build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-f50k-rl-2ts': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=reverse_level),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_method=two_abstractions))'],
'nlr-b50k-cggl-oncernd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=cg_goal_level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=all_abstractions,label_reduction_system_order=random))'],
'nlr-f50k-gcgl-oncernd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=goal_cg_level),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_method=all_abstractions,label_reduction_system_order=random))'],
'nlr-b50k-cggl-nolr': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=cg_goal_level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=none))'],
'nlr-f50k-cggl-2ts': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=cg_goal_level),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_method=two_abstractions))'],
'nlr-b50k-rl-oncernd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=reverse_level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=all_abstractions,label_reduction_system_order=random))'],
'nlr-b50k-symmi1dfp-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries(build_stabilized_pdg=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-b50k-symmb60dfp-smallest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries(build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=smallest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-b50k-symmi1l-smallest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=level,build_stabilized_pdg=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,stop_after_no_symmetries=false,symmetries_for_merging=smallest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-b50k-symmi1gcgl-smallest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=goal_cg_level,build_stabilized_pdg=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,stop_after_no_symmetries=false,symmetries_for_merging=smallest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-ginf-symmb60l-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=level,build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_system_order=random))'],
'nlr-f50k-symmb60l-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=level,build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
'nlr-b50k-symmi1gcgl-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=goal_cg_level,build_stabilized_pdg=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-ginf-symmb60gcgl-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=goal_cg_level,build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_system_order=random))'],
'nlr-b50k-symmb60miasm-smallest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_miasm(build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=smallest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-ginf-gcgl-oncernd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=goal_cg_level),shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_method=all_abstractions,label_reduction_system_order=random))'],
'nlr-b50k-gcgl-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=goal_cg_level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-b50k-symmi1rl-smallest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=reverse_level,build_stabilized_pdg=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,stop_after_no_symmetries=false,symmetries_for_merging=smallest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-ginf-gcgl-2ts': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=goal_cg_level),shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_method=two_abstractions))'],
'nlr-ginf-rl-oncernd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=reverse_level),shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_method=all_abstractions,label_reduction_system_order=random))'],
'nlr-f50k-symmb60miasm-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_miasm(build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
'nlr-f50k-l-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=level),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
'nlr-ginf-l-oncernd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=level),shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_method=all_abstractions,label_reduction_system_order=random))'],
'nlr-f50k-l-oncernd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=level),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_method=all_abstractions,label_reduction_system_order=random))'],
'nlr-f50k-dfp-2ts': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_dfp,shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_method=two_abstractions))'],
'nlr-b50k-symmb60gcgl-smallest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=goal_cg_level,build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=smallest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-f50k-l-nolr': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=level),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_method=none))'],
'nlr-b50k-dfp-oncernd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_dfp,shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=all_abstractions,label_reduction_system_order=random))'],
'nlr-ginf-dfp-oncernd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_dfp,shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_method=all_abstractions,label_reduction_system_order=random))'],
'nlr-f50k-gcgl-2ts': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=goal_cg_level),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_method=two_abstractions))'],
'nlr-f50k-cggl-nolr': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=cg_goal_level),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_method=none))'],
'nlr-b50k-cggl-2ts': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=cg_goal_level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=two_abstractions))'],
'nlr-f50k-symmb60cggl-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=cg_goal_level,build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
'nlr-f50k-miasm-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_miasm,sum_computation_bound=1000000,shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
'nlr-ginf-gcgl-nolr': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=goal_cg_level),shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_method=none))'],
'nlr-f50k-dfp-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_dfp,shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
'nlr-b50k-symmi1rl-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=reverse_level,build_stabilized_pdg=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-ginf-cggl-nolr': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=cg_goal_level),shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_method=none))'],
'nlr-b50k-dfp-2ts': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_dfp,shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=two_abstractions))'],
'nlr-f50k-rl-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=reverse_level),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
'nlr-b50k-miasm-oncernd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_miasm,sum_computation_bound=1000000,shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=all_abstractions,label_reduction_system_order=random))'],
'nlr-b50k-symmi1miasm-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_miasm(build_stabilized_pdg=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-b50k-symmi1cggl-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=cg_goal_level,build_stabilized_pdg=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-b50k-gcgl-nolr': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=goal_cg_level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=none))'],
'nlr-ginf-rl-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=reverse_level),shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_system_order=random))'],
'nlr-b50k-symmb60gcgl-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=goal_cg_level,build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-ginf-miasm-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_miasm,sum_computation_bound=1000000,shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_system_order=random))'],
'nlr-b50k-rl-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=reverse_level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-b50k-rl-nolr': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=reverse_level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=none))'],
'nlr-ginf-symmb60dfp-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries(build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_system_order=random))'],
'nlr-f50k-cggl-oncernd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=cg_goal_level),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_method=all_abstractions,label_reduction_system_order=random))'],
'nlr-b50k-miasm-nolr': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_miasm,sum_computation_bound=1000000,shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=none))'],
'nlr-ginf-dfp-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_dfp,shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_system_order=random))'],
'nlr-b50k-l-oncernd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=all_abstractions,label_reduction_system_order=random))'],
'nlr-b50k-symmi1dfp-smallest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries(build_stabilized_pdg=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,stop_after_no_symmetries=false,symmetries_for_merging=smallest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-b50k-symmb60rl-smallest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=reverse_level,build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=smallest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-b50k-miasm-2ts': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_miasm,sum_computation_bound=1000000,shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=two_abstractions))'],
'nlr-b50k-symmb60cggl-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=cg_goal_level,build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-f50k-miasm-2ts': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_miasm,sum_computation_bound=1000000,shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_method=two_abstractions))'],
'nlr-ginf-cggl-oncernd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=cg_goal_level),shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_method=all_abstractions,label_reduction_system_order=random))'],
'nlr-b50k-cggl-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=cg_goal_level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-f50k-cggl-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=cg_goal_level),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
'nlr-ginf-miasm-oncernd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_miasm,sum_computation_bound=1000000,shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_method=all_abstractions,label_reduction_system_order=random))'],
'nlr-ginf-gcgl-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=goal_cg_level),shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_system_order=random))'],
'nlr-f50k-dfp-nolr': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_dfp,shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_method=none))'],
'nlr-b50k-l-nolr': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=none))'],
'nlr-f50k-rl-oncernd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=reverse_level),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_method=all_abstractions,label_reduction_system_order=random))'],
'nlr-b50k-symmb60dfp-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries(build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-f50k-l-2ts': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=level),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_method=two_abstractions))'],
'nlr-ginf-l-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=level),shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_system_order=random))'],
'nlr-b50k-l-2ts': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=two_abstractions))'],
'nlr-b50k-symmi1cggl-smallest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=cg_goal_level,build_stabilized_pdg=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,stop_after_no_symmetries=false,symmetries_for_merging=smallest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-ginf-l-2ts': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=level),shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_method=two_abstractions))'],
'nlr-ginf-l-nolr': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=level),shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_method=none))'],
'nlr-ginf-rl-nolr': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=reverse_level),shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_method=none))'],
'nlr-b50k-dfp-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_dfp,shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-b50k-symmb60miasm-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_miasm(build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-f50k-symmb60gcgl-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=goal_cg_level,build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
'nlr-ginf-symmb60cggl-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=cg_goal_level,build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_system_order=random))'],
'nlr-b50k-symmb60l-smallest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=level,build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=smallest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-f50k-rl-nolr': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=reverse_level),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_method=none))'],
'nlr-ginf-symmb60miasm-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_miasm(build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_system_order=random))'],
'nlr-f50k-symmb60dfp-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries(build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
'nlr-b50k-gcgl-2ts': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=goal_cg_level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=two_abstractions))'],
'nlr-ginf-cggl-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=cg_goal_level),shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_system_order=random))'],
'nlr-ginf-symmb60rl-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=reverse_level,build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_system_order=random))'],
'nlr-b50k-gcgl-oncernd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=goal_cg_level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=all_abstractions,label_reduction_system_order=random))'],
'nlr-f50k-gcgl-nolr': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=goal_cg_level),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_method=none))'],
'nlr-b50k-l-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
'nlr-f50k-gcgl-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=goal_cg_level),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
'nlr-ginf-dfp-2ts': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_dfp,shrink_strategy=nlr_shrink_bisimulation(max_states=infinity,threshold=1,greedy=true,group_by_h=true),label_reduction_method=two_abstractions))']}

# Create the experiment. Add parsers, fetchers or reports...
exp = MyExperiment(
    repo_name=REPO_NAME,
    configs=CONFIGS,
    revisions=REVISIONS,
    grid_suite=['barman-opt14-strips:p638-2.pddl', 'blocks:probBLOCKS-8-2.pddl', 'elevators-opt11-strips:p09.pddl', 'freecell:p16.pddl', 'ged-opt14-strips:d-2-3.pddl', 'ged-opt14-strips:d-8-9.pddl', 'gripper:prob02.pddl', 'miconic:s21-1.pddl', 'miconic:s6-2.pddl', 'parking-opt14-strips:p_12_7-02.pddl', 'parking-opt14-strips:p_16_9-04.pddl', 'pathways-noneg:p07.pddl', 'psr-small:p10-s17-n2-l2-f30.pddl', 'satellite:p23-HC-pfile3.pddl', 'satellite:p33-HC-pfile13.pddl', 'tetris-opt14-strips:p03-4.pddl', 'transport-opt08-strips:p23.pddl', 'visitall-opt14-strips:p-1-12.pddl'],
    test_suite=['depot:p01.pddl', 'depot:p02.pddl', 'parcprinter-opt11-strips:p01.pddl', 'parcprinter-opt11-strips:p02.pddl', 'mystery:prob07.pddl']
)
exp.add_search_parser('../ms-parser.py', ms_parser_attributes.get())
exp.add_search_parser('../merge-and-shrink-jair/old-mas-parser.py', old_mas_attributes.get())
exp.add_search_parser('../merge-strategies/symmetries-parser.py', symmetries_attributes.get())

exp.add_absolute_report()

exp.run_steps()
