#! /usr/bin/env python

from tools.my_experiment import MyExperiment
import ms_parser_attributes
import sys
sys.path.insert(1, '../merge-strategies')
import symmetries_attributes
sys.path.insert(1, '../merge-and-shrink-jair')
import old_mas_attributes

# Set the following variables for the experiment
REPO_NAME = 'downward/diss'
REVISIONS = ['a7b231dd8d46']

CONFIGS = {
    'nlr-f50k-symmb60cggl-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=cg_goal_level,build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
    'nlr-f50k-symmb60dfp-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries(build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
    'nlr-f50k-symmb60gcgl-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=goal_cg_level,build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
    'nlr-f50k-symmb60l-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=level,build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
    'nlr-f50k-symmb60miasm-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_miasm(build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
    'nlr-f50k-symmb60rl-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=reverse_level,build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],

    #'nlr-f50k-symmb60cggl-smallest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=cg_goal_level,build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=smallest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
    #'nlr-f50k-symmb60dfp-smallest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries(build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=smallest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
    #'nlr-f50k-symmb60gcgl-smallest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=goal_cg_level,build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=smallest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
    #'nlr-f50k-symmb60l-smallest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=level,build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=smallest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
    #'nlr-f50k-symmb60miasm-smallest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_miasm(build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=smallest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
    #'nlr-f50k-symmb60rl-smallest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=reverse_level,build_stabilized_pdg=false,max_bliss_iterations=infinity,bliss_call_time_limit=0,bliss_total_time_budget=60,stop_after_no_symmetries=false,symmetries_for_merging=smallest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],

    #'nlr-f50k-symmi1cggl-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=cg_goal_level,build_stabilized_pdg=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
    #'nlr-f50k-symmi1dfp-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries(build_stabilized_pdg=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
    #'nlr-f50k-symmi1gcgl-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=goal_cg_level,build_stabilized_pdg=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
    #'nlr-f50k-symmi1l-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=level,build_stabilized_pdg=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
    #'nlr-f50k-symmi1miasm-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_miasm(build_stabilized_pdg=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
    #'nlr-f50k-symmi1rl-largest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=reverse_level,build_stabilized_pdg=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,stop_after_no_symmetries=false,symmetries_for_merging=largest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],

    #'nlr-f50k-symmi1cggl-smallest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=cg_goal_level,build_stabilized_pdg=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,stop_after_no_symmetries=false,symmetries_for_merging=smallest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
    #'nlr-f50k-symmi1dfp-smallest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries(build_stabilized_pdg=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,stop_after_no_symmetries=false,symmetries_for_merging=smallest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
    #'nlr-f50k-symmi1gcgl-smallest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=goal_cg_level,build_stabilized_pdg=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,stop_after_no_symmetries=false,symmetries_for_merging=smallest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
    #'nlr-f50k-symmi1l-smallest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=level,build_stabilized_pdg=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,stop_after_no_symmetries=false,symmetries_for_merging=smallest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
    #'nlr-f50k-symmi1miasm-smallest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_miasm(build_stabilized_pdg=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,stop_after_no_symmetries=false,symmetries_for_merging=smallest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
    #'nlr-f50k-symmi1rl-smallest-nonlinear-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_symmetries_linear(variable_order=reverse_level,build_stabilized_pdg=false,max_bliss_iterations=1,bliss_call_time_limit=0,bliss_total_time_budget=0,stop_after_no_symmetries=false,symmetries_for_merging=smallest,external_merging=merge_for_atomic,internal_merging=non_linear,symmetries_for_shrinking=no_shrinking),shrink_strategy=nlr_shrink_fh(max_states=50000),label_reduction_system_order=random))'],
}

# Create the experiment. Add parsers, fetchers or reports...
exp = MyExperiment(
    repo_name=REPO_NAME,
    configs=CONFIGS,
    revisions=REVISIONS,
    test_suite=['depot:p01.pddl', 'depot:p02.pddl', 'parcprinter-opt11-strips:p01.pddl', 'parcprinter-opt11-strips:p02.pddl', 'mystery:prob07.pddl']
)
exp.add_search_parser('../ms-parser.py', ms_parser_attributes.get())
exp.add_search_parser('../merge-and-shrink-jair/old-mas-parser.py', old_mas_attributes.get())
exp.add_search_parser('../merge-strategies/symmetries-parser.py', symmetries_attributes.get())

exp.add_absolute_report()

exp.run_steps()
