#! /usr/bin/env python

from tools.my_experiment import MyExperiment
import ms_parser_attributes
import sys
sys.path.insert(1, '../merge-and-shrink-jair')
import old_mas_attributes

# Set the following variables for the experiment
REPO_NAME = 'downward/diss'
REVISIONS = ['a7b231dd8d46']

CONFIGS = {
    # no LR
    'nlr-b50k-cggl-nolr': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=cg_goal_level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=none))'],
    'nlr-b50k-dfp-nolr': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_dfp,shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=none))'],
    'nlr-b50k-gcgl-nolr': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=goal_cg_level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=none))'],
    'nlr-b50k-l-nolr': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=none))'],
    'nlr-b50k-miasm-nolr': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_miasm,sum_computation_bound=1000000,shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=none))'],
    'nlr-b50k-rl-nolr': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=reverse_level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=none))'],

     # 2TS
    'nlr-b50k-cggl-2ts': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=cg_goal_level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=two_abstractions))'],
    'nlr-b50k-dfp-2ts': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_dfp,shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=two_abstractions))'],
    'nlr-b50k-gcgl-2ts': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=goal_cg_level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=two_abstractions))'],
    'nlr-b50k-l-2ts': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=two_abstractions))'],
    'nlr-b50k-miasm-2ts': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_miasm,sum_computation_bound=1000000,shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=two_abstractions))'],
    'nlr-b50k-rl-2ts': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=reverse_level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=two_abstractions))'],

    # ONCE-RND
    'nlr-b50k-cggl-oncernd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=cg_goal_level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=all_abstractions,label_reduction_system_order=random))'],
    'nlr-b50k-dfp-oncernd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_dfp,shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=all_abstractions,label_reduction_system_order=random))'],
    'nlr-b50k-gcgl-oncernd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=goal_cg_level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=all_abstractions,label_reduction_system_order=random))'],
    'nlr-b50k-l-oncernd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=all_abstractions,label_reduction_system_order=random))'],
    'nlr-b50k-miasm-oncernd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_miasm,sum_computation_bound=1000000,shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=all_abstractions,label_reduction_system_order=random))'],
    'nlr-b50k-rl-oncernd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=reverse_level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_method=all_abstractions,label_reduction_system_order=random))'],

    # FP-RND (default setting)
    'nlr-b50k-cggl-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=cg_goal_level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
    'nlr-b50k-dfp-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_dfp,shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
    'nlr-b50k-gcgl-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=goal_cg_level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
    'nlr-b50k-l-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
    'nlr-b50k-miasm-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_miasm,sum_computation_bound=1000000,shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
    'nlr-b50k-rl-fprnd': ['--search', 'astar(nlr_merge_and_shrink(merge_strategy=nlr_merge_linear(variable_order=reverse_level),shrink_strategy=nlr_shrink_bisimulation(max_states=50000,threshold=1,greedy=false,group_by_h=true),label_reduction_system_order=random))'],
}

# Create the experiment. Add parsers, fetchers or reports...
exp = MyExperiment(
    repo_name=REPO_NAME,
    configs=CONFIGS,
    revisions=REVISIONS,
    test_suite=['depot:p01.pddl', 'depot:p02.pddl', 'parcprinter-opt11-strips:p01.pddl', 'parcprinter-opt11-strips:p02.pddl', 'mystery:prob07.pddl']
)
exp.add_search_parser('../ms-parser.py', ms_parser_attributes.get())
exp.add_search_parser('../merge-and-shrink-jair/old-mas-parser.py', old_mas_attributes.get())

exp.add_absolute_report()

exp.run_steps()
