import pandas as pd
import sys
reload(sys)
sys.setdefaultencoding('utf-8')
from matplotlib import style
import os
import sql_queries
from flux_plotting import plot_flux, plot_province
import numpy as np
import matplotlib.pyplot as plt
from astropy.io import ascii
import scipy
os.chdir('/home/pmisson/Descargas/database/plots/calibration_graphs')
style.use("ggplot")
style.use("seaborn-poster")


ISO=ascii.read('ISO_countries2.csv',fast_reader=False,guess=False, delimiter=';')
maskISO=np.logical_not(ISO['Alpha2'].mask)
ISOCO=list(ISO['Alpha2'][maskISO])
namesCO=list(ISO['Country'][maskISO])
dictCO = dict(zip(ISOCO,namesCO))



viirs, energy_viirs= sql_queries.get_flux("'SNPP VIIRS-DNB'", "'yes'", 2012, 2012,'IT') #Query energy from VIIRS and Energy VIIRS
dmsp_noncal, energy_non_cal = sql_queries.get_flux("'NOAA DMSP'", "'no'", 2012, 2012,'IT') #Query energy from DMSP non cal and Energy DMSP non cal
dmsp_cal, energy_cal = sql_queries.get_flux("'NOAA DMSP'", "'partly'", 2012, 2010,'IT') #Query energy from DMSP cal and Energy DMSP cal
dmsp_cal = dmsp_cal[::2]
energy_cal = energy_cal[::2]

x=dmsp_cal
y=viirs
fit2=ascii.read('dmsp2viirs.csv')
def fit_dmsp2viirs(x):
    fit_dmsp2viirs = 10**(fit2['col1'][0]+fit2['col0'][0]*np.log10(x))
    return fit_dmsp2viirs

plt.plot(np.log10(x),np.log10(y), 'yo', np.log10(x), np.log10(fit_dmsp2viirs(x)), '--k')
plt.ylabel('LOG10(SNPP VIIRS/DNB Power (W))')
plt.xlabel('LOG10(DMSP OLS calibrated (ADU))')
plt.savefig('LogDMSPvVIIRS.jpg')
#plt.show()
plt.close()

fit=ascii.read('energy2viirs.csv')
def fit_energy2viirs(x):
    fit_energy2viirs = 10**(fit['col1'][0]+fit['col0'][0]*np.log10(x))
    return fit_energy2viirs

df1 = pd.DataFrame({"viirs":viirs, "dmsp_noncal":dmsp_noncal, "energy_viirs":energy_viirs, "energy_non_cal":energy_non_cal,
                    "dmsp_cal":dmsp_cal, "energy_cal":energy_cal})


nuts3_id = sql_queries.get_province_nuts3('WO')
province_name = sql_queries.get_province_name('WO')
istat_id = sql_queries.get_province_istat('WO')
province_order_nuts3 = sql_queries.get_province_province_nuts3('WO')


energy_province_names = sql_queries.get_province_name_from_energy('WO')
nuts_province_dictionary = dict(zip(nuts3_id, province_name)) #old nuts3 based
energy_province_id = sql_queries.get_province_id_from_energy('WO')
istat_province_dictionary = dict(zip(energy_province_id, energy_province_names))
#istat_to_nuts3 = dict(zip(istat_id, province_order_nuts3)) ### wrong order
istat_to_nuts3 = dict(zip(province_order_nuts3, istat_id))

def apply_factor(nuts3,medians):
    ####### all same as previous script except commented parts#########################
    ################################################################################
    ################################################################################


    province_year, province_energy = sql_queries.get_data_province("'"+nuts3+"'",'WO')
    province_viirs_year, province_viirs = sql_queries.get_province_flux("'"+nuts3+"'", "'SNPP VIIRS-DNB'", "'yes'",'WO')
    province_predicted_flux_viirs = np.array(province_energy)
    province_predicted_flux_viirs = fit_energy2viirs(province_predicted_flux_viirs)
    #province_predicted_flux_viirs = (province_predicted_flux_viirs*1316.063)+1498.336

    province_dmsp_cal_year, province_dmsp_cal = sql_queries.get_province_flux("'"+nuts3+"'", "'NOAA DMSP'", "'partly'",'WO')
    province_dmsp_cal_predicted = np.array(province_dmsp_cal)
    province_dmsp_cal_predicted =fit_dmsp2viirs(province_dmsp_cal_predicted)
    #province_dmsp_cal_predicted = (province_dmsp_cal_predicted*1.6406547835392305e-06)+-6984.849056374369

    province_dmsp_non_cal_year, province_dmsp_non_cal = sql_queries.get_province_flux("'"+nuts3+"'", "'NOAA DMSP'", "'no'",'WO')
    province_dmsp_non_cal_predicted = np.array(province_dmsp_non_cal)
    province_dmsp_non_cal_predicted = fit_dmsp2viirs(province_dmsp_non_cal_predicted)
    #province_dmsp_non_cal_predicted = (province_dmsp_non_cal_predicted*1.6406547835392305e-06)+-6984.849056374369

    ####VIIRS####    
    maskviirs=np.in1d(province_year,province_viirs_year)
    selectedviirsyears=np.array(province_year)[maskviirs]
    energymaksedviirs=np.array(province_predicted_flux_viirs)[maskviirs]
    maskenergy1=np.in1d(province_viirs_year,province_year)
    selectedenergy1years=np.array(province_viirs_year)[maskenergy1]
    viirmaksedsenergy=np.array(province_viirs)[maskenergy1]
    maskmediansVIIRS=np.in1d(medians[2],province_viirs_year)
    maskmediansVIIRS2=np.in1d(province_viirs_year,medians[2])
    corrVIIRS=np.array(province_viirs)[maskmediansVIIRS2]/medians[0][maskmediansVIIRS]#aply median of offsets
    corrVIIRSPlus=np.array(province_viirs)[maskmediansVIIRS2]/np.array(medians[0]+medians[1])[maskmediansVIIRS]
    corrVIIRSMinus=np.array(province_viirs)[maskmediansVIIRS2]/np.array(medians[0]-medians[1])[maskmediansVIIRS]
    yearsVIIRS=np.array(province_viirs_year)[maskmediansVIIRS2]

    zeropointVIIRS=0 #calculate vertical offset
    zeropointVIIRSPlus=0 #calculate vertical offset
    zeropointVIIRSMinus=0 #calculate vertical offset
    #### end VIIRS######

    ####non_cal####    
    masknon_cal=np.in1d(province_year,province_dmsp_non_cal_year)
    selectedenergy2years=np.array(province_year)[masknon_cal]
    maskenergy2=np.in1d(province_dmsp_non_cal_year,province_year)
    energymaksednon_cal=np.array(province_predicted_flux_viirs)[masknon_cal]

    
    selectednon_calyears=np.array(province_dmsp_non_cal_year)[maskenergy2]
    non_calmaksedsenergy=np.array(province_dmsp_non_cal_predicted)[maskenergy2]
    keys = selectedenergy2years
    values = energymaksednon_cal
    dictionary = dict(zip(keys, values))
    #print(dictionary)
    predictednon_calenergy=[]
    for X in selectednon_calyears:
        predictednon_calenergy.append(dictionary[X])

    maskmediansDSMP=np.in1d(medians[-1],province_dmsp_non_cal_year)
    maskmediansDSMP2=np.in1d(province_dmsp_non_cal_year,medians[-1])
    corrnon_cal=np.array(province_dmsp_non_cal_predicted)[maskmediansDSMP2]/medians[6][maskmediansDSMP] #apply median of offsets
    corrnon_calPlus=np.array(province_dmsp_non_cal_predicted)[maskmediansDSMP2]/np.array(medians[6]+medians[7])[maskmediansDSMP] #apply median of offsets
    corrnon_calMinus=np.array(province_dmsp_non_cal_predicted)[maskmediansDSMP2]/np.array(medians[6]-medians[7])[maskmediansDSMP] #apply median of offsets
    yearsnon_cal=np.array(province_dmsp_non_cal_year)[maskmediansDSMP2]

    masknon_calVIIRS=np.in1d(yearsnon_cal,yearsVIIRS)
    maskVIIRSnon_cal=np.in1d(yearsVIIRS,yearsnon_cal)
    non_calref=np.mean(corrnon_cal[masknon_calVIIRS])
    non_calrefPlus=np.mean(corrnon_calPlus[masknon_calVIIRS])
    non_calrefMinus=np.mean(corrnon_calPlus[masknon_calVIIRS])
    VIIRSref=np.mean(corrVIIRS[maskVIIRSnon_cal])
    zeropointnoncal=non_calref/VIIRSref #calculate vertical offset
    zeropointnoncalPlus=non_calrefPlus/VIIRSref  #calculate vertical offset
    zeropointnoncalMinus=non_calrefMinus/VIIRSref  #calculate vertical offset #calculate vertical offset  
    #### end non_cal######

    ####cal####    
    maskcal=np.in1d(province_year,province_dmsp_cal_year)
    selectedenergy3years=np.array(province_year)[maskcal]
    maskenergy3=np.in1d(province_dmsp_cal_year,province_year)
    energymaksedcal=np.array(province_predicted_flux_viirs)[maskcal]

    
    selectedcalyears=np.array(province_dmsp_cal_year)[maskenergy3]
    calmaksedsenergy=np.array(province_dmsp_cal_predicted)[maskenergy3]
    keys = selectedenergy3years
    values = energymaksedcal
    dictionary = dict(zip(keys, values))
    #print(dictionary)
    predictedcalenergy=[]
    for X in selectedcalyears:
        predictedcalenergy.append(dictionary[X])

    maskmediansDSMPcal=np.in1d(medians[5],province_dmsp_cal_year)
    maskmediansDSMPcal2=np.in1d(province_dmsp_cal_year,medians[5])
    corrcal=np.array(province_dmsp_cal_predicted)[maskmediansDSMPcal2]/medians[3][maskmediansDSMPcal] #apply median of offsets
    corrcalPlus=np.array(province_dmsp_cal_predicted)[maskmediansDSMPcal2]/(medians[3]+medians[4])[maskmediansDSMPcal] #apply median of offsets
    corrcalMinus=np.array(province_dmsp_cal_predicted)[maskmediansDSMPcal2]/(medians[3]-medians[4])[maskmediansDSMPcal] #apply median of offsets
    yearscal=np.array(province_dmsp_cal_year)[maskmediansDSMPcal2]
    
    masknon_calcal=np.in1d(yearsnon_cal,province_dmsp_cal_year)
    maskcalnon_cal=np.in1d(province_dmsp_cal_year,yearsnon_cal)
    non_calref=np.mean(corrnon_cal[masknon_calcal])
    non_calrefPlus=np.mean(corrnon_calPlus[masknon_calcal])
    non_calrefMinus=np.mean(corrnon_calMinus[masknon_calcal])
    calref=np.mean(corrcal[maskcalnon_cal])
    zeropointcal=calref/non_calref #calculate vertical offset
    zeropointcalPlus=calref/non_calrefPlus #calculate vertical offset
    zeropointcalMinus=calref/non_calrefMinus #calculate vertical offset
    #### end cal######

    df = pd.DataFrame({"corrnon_cal":corrnon_cal, "yearsnon_cal":yearsnon_cal})
    df1 = pd.DataFrame({"corrcal":corrcal,"yearscal":yearscal})
    df2 = pd.DataFrame({"corrVIIRS":corrVIIRS,"yearsVIIRS": yearsVIIRS})
    df3 = pd.DataFrame({"corrnon_calPlus":corrnon_calPlus, "yearsnon_cal1":yearsnon_cal})
    df4 = pd.DataFrame({"corrnon_calMinus":corrnon_calMinus, "yearsnon_cal2":yearsnon_cal})
    df5 = pd.DataFrame({"corrcalPlus":corrcalPlus,"yearscal1":yearscal})
    df6 = pd.DataFrame({"corrcalMinus":corrcalMinus,"yearscal2":yearscal})
    df7 = pd.DataFrame({"corrVIIRSPlus":corrVIIRSPlus,"yearsVIIRS1": yearsVIIRS})
    df8 = pd.DataFrame({"corrVIIRSMinus":corrVIIRSMinus,"yearsVIIRS2": yearsVIIRS})
    df = pd.concat([df,df1,df2,df3,df4,df5,df6,df7,df8], ignore_index = False, axis= 1)

    
    return df,zeropointVIIRS,zeropointcal,zeropointnoncal,zeropointVIIRSPlus,zeropointcalPlus,zeropointnoncalPlus,zeropointVIIRSMinus,zeropointcalMinus,zeropointnoncalMinus



blacklist=['ITC13','ITC14','ITC43','ITC44','ITC49','ITC4D','ITF48','ITF62','ITF64','ITG29','ITG2A','ITG2B','ITG2C','ITH59','ITI15','ITI35','ITC4C','ITG2B','ITI34','ITF47','ITG27','ITF63','ITC42','ITI14','ITH58','ITC34','ITC33','ITC15','ITG26','ITC15','ITC12']

#medians=pd.read_csv("medians.csv", encoding = "UTF-8")
data = ascii.read("medians.csv")
medians=[]
medians.append(data['col0'])
medians.append(data['col1'])
medians.append(data['col2'])
medians.append(data['col3'])
medians.append(data['col4'])
medians.append(data['col5'])
medians.append(data['col6'])
medians.append(data['col7'])
medians.append(data['col8'])



 
nuts3_id = sql_queries.get_province_nuts3('WO') #search  nuts id
province_name = sql_queries.get_province_name('WO')#search  nuts province name
nuts_province_dictionary = dict(zip(nuts3_id, province_name))#create dictionary that transforms nuts_id to province name

corrected ={} #empty dictionary for corrected data
zeroVIIRS ={} #empty dictionary for vertical offset per province
zerononcal={} #empty dictionary for vertical offset per province
zerocal={} #empty dictionary for vertical offset per province
zeroVIIRSPlus ={} #empty dictionary for vertical offset per province
zerononcalPlus={} #empty dictionary for vertical offset per province
zerocalPlus={} #empty dictionary for vertical offset per province
zeroVIIRSMinus ={} #empty dictionary for vertical offset per province
zerononcalMinus={} #empty dictionary for vertical offset per province
zerocalMinus={} #empty dictionary for vertical offset per province

for nuts3 in nuts3_id:
 if blacklist.count(nuts3)==0:
    try:
        corrected[nuts_province_dictionary[nuts3]],xi,xo,xp,xiP,xoP,xpP,xiM,xoM,xpM=apply_factor(nuts3,medians) #apply offset and calculate vertical offset
        zeroVIIRS[nuts_province_dictionary[nuts3]]=xi #store offset per province
        zerononcal[nuts_province_dictionary[nuts3]]=xp #store offset per province
        zerocal[nuts_province_dictionary[nuts3]]=xo #store offset per province
        zeroVIIRSPlus[nuts_province_dictionary[nuts3]]=xiP #store offset per province
        zerononcalPlus[nuts_province_dictionary[nuts3]]=xpP #store offset per province
        zerocalPlus[nuts_province_dictionary[nuts3]]=xoP #store offset per province
        zeroVIIRSMinus[nuts_province_dictionary[nuts3]]=xiM #store offset per province
        zerononcalMinus[nuts_province_dictionary[nuts3]]=xpM #store offset per province
        zerocalMinus[nuts_province_dictionary[nuts3]]=xoM #store offset per province
    except:
         print nuts3 +' falla'


############################################ This prints the plots with vertical offsets
def takeSecond(elem):                    
    return elem[1]

def takeFirst(elem):                    
    return elem[0]
VIIRS_tot=[]
DMSP_cal_tot=[]
DMSP_non_cal_tot=[]
VIIRS_totE=[]
DMSP_cal_totE=[]
DMSP_non_cal_totE=[]
Minist_tot=[]
MED=[]

print('Vamos a clacular')
for nuts3 in nuts3_id:
 #if blacklist.count(nuts3)==0:
    if nuts3=='None':
        print('None')
    elif nuts3=='-99':    
        print('-99')
    elif nuts3=='AU':    
        print('AU')
    elif nuts3=='PS':    
        print('PS')
    else:
    #try:
        print(nuts3)
        plt.plot(corrected[nuts_province_dictionary[nuts3]]["yearsnon_cal"],corrected[nuts_province_dictionary[nuts3]]["corrnon_cal"]/zerononcal[nuts_province_dictionary[nuts3]],'bo')

        errorDMSP_noncal0=np.abs(corrected[nuts_province_dictionary[nuts3]]["corrnon_calPlus"]/zerononcal[nuts_province_dictionary[nuts3]]-corrected[nuts_province_dictionary[nuts3]]["corrnon_cal"]/zerononcal[nuts_province_dictionary[nuts3]])
        errorDMSP_noncalM=np.abs(corrected[nuts_province_dictionary[nuts3]]["corrnon_calPlus"]/zerononcal[nuts_province_dictionary[nuts3]]-corrected[nuts_province_dictionary[nuts3]]["corrnon_cal"]/zerononcalMinus[nuts_province_dictionary[nuts3]])

        errorDMSP_noncalP=np.abs(corrected[nuts_province_dictionary[nuts3]]["corrnon_calPlus"]/zerononcal[nuts_province_dictionary[nuts3]]-corrected[nuts_province_dictionary[nuts3]]["corrnon_cal"]/zerononcalPlus[nuts_province_dictionary[nuts3]])
        errorDMSP_noncal=np.vstack([errorDMSP_noncal0,errorDMSP_noncalM,errorDMSP_noncalP])
        errorDMSP_noncal=np.max(errorDMSP_noncal,axis=0)

        plt.errorbar(corrected[nuts_province_dictionary[nuts3]]["yearsnon_cal"],corrected[nuts_province_dictionary[nuts3]]["corrnon_cal"]/zerononcal[nuts_province_dictionary[nuts3]], yerr=errorDMSP_noncal,color='b',linestyle='')


        errorDMSPcal0=np.abs(corrected[nuts_province_dictionary[nuts3]]["corrcalPlus"]/zerocal[nuts_province_dictionary[nuts3]]/zerononcal[nuts_province_dictionary[nuts3]]-corrected[nuts_province_dictionary[nuts3]]["corrcal"]/zerocal[nuts_province_dictionary[nuts3]]/zerononcal[nuts_province_dictionary[nuts3]])
        errorDMSPcalM=np.abs(corrected[nuts_province_dictionary[nuts3]]["corrcal"]/zerocal[nuts_province_dictionary[nuts3]]/zerononcal[nuts_province_dictionary[nuts3]]-corrected[nuts_province_dictionary[nuts3]]["corrcalMinus"]/zerocalMinus[nuts_province_dictionary[nuts3]]/zerononcalMinus[nuts_province_dictionary[nuts3]])

        errorDMSPcalP=np.abs(corrected[nuts_province_dictionary[nuts3]]["corrcalPlus"]/zerocal[nuts_province_dictionary[nuts3]]/zerononcal[nuts_province_dictionary[nuts3]]-corrected[nuts_province_dictionary[nuts3]]["corrcal"]/zerocalPlus[nuts_province_dictionary[nuts3]]/zerononcalPlus[nuts_province_dictionary[nuts3]])
        errorDMSPcal=np.vstack([errorDMSPcal0,errorDMSPcalM,errorDMSPcalP])
        errorDMSPcal=np.max(errorDMSPcal,axis=0)

        plt.errorbar(corrected[nuts_province_dictionary[nuts3]]["yearscal"],corrected[nuts_province_dictionary[nuts3]]["corrcal"]/zerocal[nuts_province_dictionary[nuts3]]/zerononcal[nuts_province_dictionary[nuts3]], yerr=errorDMSPcal,color='g',linestyle='')



        plt.plot(corrected[nuts_province_dictionary[nuts3]]["yearscal"],corrected[nuts_province_dictionary[nuts3]]["corrcal"]/zerocal[nuts_province_dictionary[nuts3]]/zerononcal[nuts_province_dictionary[nuts3]],'go')


        errorVIIRScal=np.abs(corrected[nuts_province_dictionary[nuts3]]["corrVIIRSPlus"]-corrected[nuts_province_dictionary[nuts3]]["corrVIIRS"])


        plt.errorbar(corrected[nuts_province_dictionary[nuts3]]["yearsVIIRS"],corrected[nuts_province_dictionary[nuts3]]["corrVIIRS"], yerr=errorVIIRScal,color='r',linestyle='')



        plt.plot(corrected[nuts_province_dictionary[nuts3]]["yearsVIIRS"],corrected[nuts_province_dictionary[nuts3]]["corrVIIRS"],'ro')
        province_year, province_energy = sql_queries.get_data_province("'"+nuts3+"'",'IT')
        province_predicted_flux_viirs = np.array(province_energy)
        province_predicted_flux_viirs = fit_energy2viirs(province_predicted_flux_viirs)
        #province_predicted_flux_viirs = (province_predicted_flux_viirs*1316.063)+1498.336
        plt.plot(province_year,province_predicted_flux_viirs,'ko')
        try:
            plt.title(dictCO[nuts_province_dictionary[nuts3]])
        except:
             plt.title(nuts_province_dictionary[nuts3])           
        plt.xlabel('years')
        plt.ylabel('Power emited (W)')
        allyears=np.concatenate([np.array(corrected[nuts_province_dictionary[nuts3]]["yearscal"]),np.array(corrected[nuts_province_dictionary[nuts3]]["yearsnon_cal"]),np.array(corrected[nuts_province_dictionary[nuts3]]["yearsVIIRS"],corrected[nuts_province_dictionary[nuts3]]["yearsnon_cal"])])
        allflux=np.concatenate([np.array(corrected[nuts_province_dictionary[nuts3]]["corrcal"]/zerocal[nuts_province_dictionary[nuts3]]/zerononcal[nuts_province_dictionary[nuts3]]),np.array(corrected[nuts_province_dictionary[nuts3]]["corrnon_cal"]/zerononcal[nuts_province_dictionary[nuts3]]),np.array(corrected[nuts_province_dictionary[nuts3]]["corrVIIRS"])])

        allfy=zip(allyears,allflux)


        sortedList = sorted(allfy,key=takeSecond)
        sortedList=sortedList[0:9]+sortedList[36:76]
        sortedList = sorted(sortedList,key=takeFirst)
        sortedList=np.array(sortedList)
        x=sortedList[:,0]
        y=sortedList[:,1]
        x1=np.convolve(x, np.ones((7,))/7, mode='valid')
        y1=np.convolve(y, np.ones((7,))/7, mode='valid')
        x2=scipy.signal.medfilt(x, kernel_size=5)
        y2=scipy.signal.medfilt(y, kernel_size=5)
        x2=scipy.signal.medfilt(x2, kernel_size=5)
        y2=scipy.signal.medfilt(y2, kernel_size=5)
        #plt.plot(x1,y1,'k-')
        plt.plot(x2,y2,'ko')
        

        plt.savefig(nuts_province_dictionary[nuts3]+'corr1p3WO.jpg')
        #plt.show()
        plt.close()
        
        
        MED.append(y2)
        VIIRS_tot.append(corrected[nuts_province_dictionary[nuts3]]["corrVIIRS"])
        DMSP_cal_tot.append(corrected[nuts_province_dictionary[nuts3]]["corrcal"]/zerocal[nuts_province_dictionary[nuts3]]/zerononcal[nuts_province_dictionary[nuts3]])
        DMSP_non_cal_tot.append(corrected[nuts_province_dictionary[nuts3]]["corrnon_cal"]/zerononcal[nuts_province_dictionary[nuts3]])
        VIIRS_totE.append(errorVIIRScal)
        DMSP_cal_totE.append(errorDMSPcal)
        DMSP_non_cal_totE.append(errorDMSP_noncal)

        
      
'''
    except:
        print nuts3 +' falla'
'''
DMSP_cal_tot2=np.array(DMSP_cal_tot)
for X in range(len(DMSP_cal_tot2)):
    if np.isnan(DMSP_cal_tot2[X][0]) or np.isinf(DMSP_cal_tot2[X][0]):
       DMSP_cal_tot2[X]=0
       DMSP_cal_totE[X]=0
tot_DMSP_cal=np.sum(DMSP_cal_tot2,axis=0)
tot_DMSP_calE=np.sqrt(np.sum(np.array(DMSP_cal_totE)**2,axis=0))#/len(DMSP_cal_totE)




for X in range(len(DMSP_non_cal_tot)):
    if np.isnan(DMSP_non_cal_tot[X][0]) or np.isinf(DMSP_non_cal_tot[X][0]):
       DMSP_non_cal_tot[X]=0
       DMSP_non_cal_totE[X]=0
for X in range(len(MED)):
    if np.isnan(MED[X][0]) or np.isinf(MED[X][0]):
       MED[X]=0




DMSP_non_cal_tot2=np.array(DMSP_non_cal_tot)
DMSP_non_cal_totE=np.array(DMSP_non_cal_totE)



tot_DMSP_non_cal=np.sum(DMSP_non_cal_tot2,axis=0)
tot_DMSP_non_calE=np.sqrt(np.sum(np.array(DMSP_non_cal_totE)**2,axis=0))#/len(DMSP_non_cal_totE)

VIIRS_tot2=np.array(VIIRS_tot)
VIIRS_totE=np.array(VIIRS_totE)
tot_VIIRS=np.sum(VIIRS_tot2,axis=0)
tot_VIIRSE=np.sqrt(np.sum(np.array(VIIRS_totE)**2,axis=0))#/len(VIIRS_totE)
MED1=np.sum(np.array(MED),axis=0)



#plt.plot(corrected[nuts_province_dictionary[nuts3]]["yearsnon_cal"],tot_DMSP_non_cal,'bo')

plt.errorbar(corrected[nuts_province_dictionary[nuts3]]["yearsnon_cal"],tot_DMSP_non_cal, yerr=tot_DMSP_non_calE,color='b',linestyle='',marker='o')

#plt.plot(corrected[nuts_province_dictionary[nuts3]]["yearscal"],tot_DMSP_cal,'go')
plt.errorbar(corrected[nuts_province_dictionary[nuts3]]["yearscal"],tot_DMSP_cal, yerr=tot_DMSP_calE,color='g',linestyle='',marker='o')
#plt.plot(corrected[nuts_province_dictionary[nuts3]]["yearsVIIRS"],tot_VIIRS,'ro')
plt.errorbar(corrected[nuts_province_dictionary[nuts3]]["yearsVIIRS"],tot_VIIRS, yerr=tot_VIIRSE,color='r',linestyle='',marker='o')
plt.plot(x2,MED1,'ko')
plt.title('World')
plt.xlabel('years')
plt.ylabel('Power emited (W)')
plt.savefig('WOcorr1p3CO.jpg')
plt.show()
plt.close()



######################################### Here we iterate the calculation of the offsets and vertical offsets
print("\n" + "Provinces where offsets and vertical offsets were not calculated: " + "\n")

############################################ This prints the plots with vertical offsets
for nuts3 in nuts3_id:
 #if blacklist.count(nuts3)==0:
    if nuts3=='None':
        print('None')
    elif nuts3=='-99':    
        print('-99')
    elif nuts3=='AU':    
        print('AU')
    elif nuts3=='PS':    
        print('PS')
    else:
    #try:
        print(nuts3)

        plt.plot(corrected[nuts_province_dictionary[nuts3]]["yearsnon_cal"],corrected[nuts_province_dictionary[nuts3]]["corrnon_cal"]/zerononcal[nuts_province_dictionary[nuts3]],'bo')

        errorDMSP_noncal0=np.abs(corrected[nuts_province_dictionary[nuts3]]["corrnon_calPlus"]/zerononcal[nuts_province_dictionary[nuts3]]-corrected[nuts_province_dictionary[nuts3]]["corrnon_cal"]/zerononcal[nuts_province_dictionary[nuts3]])
        errorDMSP_noncalM=np.abs(corrected[nuts_province_dictionary[nuts3]]["corrnon_calPlus"]/zerononcal[nuts_province_dictionary[nuts3]]-corrected[nuts_province_dictionary[nuts3]]["corrnon_cal"]/zerononcalMinus[nuts_province_dictionary[nuts3]])

        errorDMSP_noncalP=np.abs(corrected[nuts_province_dictionary[nuts3]]["corrnon_calPlus"]/zerononcal[nuts_province_dictionary[nuts3]]-corrected[nuts_province_dictionary[nuts3]]["corrnon_cal"]/zerononcalPlus[nuts_province_dictionary[nuts3]])
        errorDMSP_noncal=np.vstack([errorDMSP_noncal0,errorDMSP_noncalM,errorDMSP_noncalP])
        errorDMSP_noncal=np.max(errorDMSP_noncal,axis=0)

        plt.errorbar(corrected[nuts_province_dictionary[nuts3]]["yearsnon_cal"],corrected[nuts_province_dictionary[nuts3]]["corrnon_cal"]/zerononcal[nuts_province_dictionary[nuts3]], yerr=errorDMSP_noncal,color='b',linestyle='')


        errorDMSPcal0=np.abs(corrected[nuts_province_dictionary[nuts3]]["corrcalPlus"]-corrected[nuts_province_dictionary[nuts3]]["corrcal"])
        errorDMSPcalM=np.abs(corrected[nuts_province_dictionary[nuts3]]["corrcal"]-corrected[nuts_province_dictionary[nuts3]]["corrcalMinus"])

        errorDMSPcalP=np.abs(corrected[nuts_province_dictionary[nuts3]]["corrcalPlus"]-corrected[nuts_province_dictionary[nuts3]]["corrcal"])
        errorDMSPcal=np.vstack([errorDMSPcal0,errorDMSPcalM,errorDMSPcalP])
        errorDMSPcal=np.max(errorDMSPcal,axis=0)

        plt.errorbar(corrected[nuts_province_dictionary[nuts3]]["yearscal"],corrected[nuts_province_dictionary[nuts3]]["corrcal"], yerr=errorDMSPcal,color='g',linestyle='')



        plt.plot(corrected[nuts_province_dictionary[nuts3]]["yearscal"],corrected[nuts_province_dictionary[nuts3]]["corrcal"],'go')


        errorVIIRScal=np.abs(corrected[nuts_province_dictionary[nuts3]]["corrVIIRSPlus"]-corrected[nuts_province_dictionary[nuts3]]["corrVIIRS"])


        plt.errorbar(corrected[nuts_province_dictionary[nuts3]]["yearsVIIRS"],corrected[nuts_province_dictionary[nuts3]]["corrVIIRS"], yerr=errorVIIRScal,color='r',linestyle='')



        plt.plot(corrected[nuts_province_dictionary[nuts3]]["yearsVIIRS"],corrected[nuts_province_dictionary[nuts3]]["corrVIIRS"],'ro')
        province_year, province_energy = sql_queries.get_data_province("'"+nuts3+"'",'IT')
        province_predicted_flux_viirs = np.array(province_energy)
        province_predicted_flux_viirs = fit_energy2viirs(province_predicted_flux_viirs)
        #province_predicted_flux_viirs = (province_predicted_flux_viirs*1316.063)+1498.336
        plt.plot(province_year,province_predicted_flux_viirs,'ko')
        try:
            plt.title(dictCO[nuts_province_dictionary[nuts3]])
        except:
             plt.title(nuts_province_dictionary[nuts3]) 
        plt.xlabel('years')
        plt.ylabel('Power emited (W)')
        plt.savefig(nuts_province_dictionary[nuts3]+'corr5p3WO.jpg')
        #plt.show()
        plt.close()
        




##############################################
#
#    No offsets
#
#############################################


for nuts3 in nuts3_id:
 #if blacklist.count(nuts3)==0:
    if nuts3=='None':
        print('None')
    elif nuts3=='-99':    
        print('-99')
    elif nuts3=='AU':    
        print('AU')
    elif nuts3=='PS':    
        print('PS')
    else:
    #try:
        print(nuts3)

        plt.plot(corrected[nuts_province_dictionary[nuts3]]["yearsnon_cal"],corrected[nuts_province_dictionary[nuts3]]["corrnon_cal"],'bo')
        plt.plot(corrected[nuts_province_dictionary[nuts3]]["yearscal"],corrected[nuts_province_dictionary[nuts3]]["corrcal"],'go')
        plt.plot(corrected[nuts_province_dictionary[nuts3]]["yearsVIIRS"],corrected[nuts_province_dictionary[nuts3]]["corrVIIRS"],'ro')
        province_year, province_energy = sql_queries.get_data_province("'"+nuts3+"'",'IT')
        province_predicted_flux_viirs = np.array(province_energy)
        province_predicted_flux_viirs = fit_energy2viirs(province_predicted_flux_viirs)
        #province_predicted_flux_viirs = (province_predicted_flux_viirs*1316.063)+1498.336
        plt.plot(province_year,province_predicted_flux_viirs,'ko')
        try:
            plt.title(dictCO[nuts_province_dictionary[nuts3]])
        except:
             plt.title(nuts_province_dictionary[nuts3]) 
        plt.xlabel('years')
        plt.ylabel('Power emited (W)')
        plt.savefig(nuts_province_dictionary[nuts3]+'corr6p3WO.jpg')
        #plt.show()
        plt.close()
        




'''
plot_flux(df1, "viirs", "energy_viirs", energy_viirs, "green", viirs, "VIIRS", "VIIRS Flux", "Energy Consumption")
plot_flux(df1, "dmsp_cal", "energy_cal", energy_cal, "green", dmsp_cal,"Calibrated DMSP", "Energy Consumption", "DMSP Calibrated Flux")
plot_flux(df1, "dmsp_noncal", "energy_non_cal", energy_non_cal, "green", dmsp_noncal, "Non-calibrated DMSP", "DMSP Non-Calibrated Flux", "Energy Consumption")
plot_flux(df1, "energy_viirs", "viirs", viirs, "green", energy_viirs, "Energy Consumption", "Energy Consumption", "VIIRS Flux")
plot_flux(df1, "dmsp_cal", "viirs", viirs, "green", dmsp_cal, "DMSP Calibrated", "DMSP Calibrated Flux", "VIIRS Flux")
plot_flux(df1, "dmsp_noncal", "viirs", viirs, "green", dmsp_noncal, "DMSP Non Calibrated", "DMSP Non Calibrated Flux", "VIIRS Flux")
'''
