# README

## Top-level Schemas

*   [JSON schema for BenchPress config file.](./config.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json`

## Other Schemas

### Objects

*   [Available structure learning algorithms](./config-properties-resources-properties-available-structure-learning-algorithms.md "The available structure learning algorithms") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms`

*   [Benchmark setup](./config-properties-benchmark-setup.md "Description of the benchmarking setup") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/benchmark_setup`

*   [Blip instantiation](./config-properties-resources-properties-available-structure-learning-algorithms-properties-list-of-blip-instantiations-blip-instantiation.md "Blip instantiation") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/rblip/items`

*   [Blip instantiation](./config-definitions-blip-instantiation.md "Blip instantiation") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/rblip`

*   [Data sampling algorithms](./config-properties-resources-properties-data-sampling-algorithms.md "Data sampling setup") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/data`

*   [Data setup](./config-properties-benchmark-setup-properties-data-setup-data-setup.md "Description of the data model and sampling setup") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/benchmark_setup/properties/data/items`

*   [Data setup](./config-definitions-data-setup.md "Description of the data model and sampling setup") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/data_setup_dict`

*   [FCI](./config-properties-resources-properties-available-structure-learning-algorithms-properties-fci-instantiations-fci.md "FCI instance") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/tetrad_fci/items`

*   [FCI](./config-definitions-fci.md "FCI instance") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/tetrad_fci`

*   [Fast greedy equivalent search (fGES)](./config-properties-resources-properties-available-structure-learning-algorithms-properties-fges-instantiations-fast-greedy-equivalent-search-fges.md "fGES instance") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/tetrad_fges/items`

*   [Fast greedy equivalent search (fGES)](./config-definitions-fast-greedy-equivalent-search-fges.md "fGES instance") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/tetrad_fges`

*   [GFCI (parameter setting)](./config-properties-resources-properties-available-structure-learning-algorithms-properties-gfci-instantiations-gfci-parameter-setting.md "GFCI instance") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/tetrad_gfci/items`

*   [GFCI (parameter setting)](./config-definitions-gfci-parameter-setting.md "GFCI instance") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/tetrad_gfci`

*   [GLasso algorithm](./config-properties-resources-properties-available-structure-learning-algorithms-properties-glasso-glasso-algorithm.md "GLasso instance") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/sklearn_glasso/items`

*   [GLasso algorithm](./config-definitions-glasso-algorithm.md "GLasso instance") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/sklearn_glasso`

*   [Gobnilp algorithm](./config-properties-resources-properties-available-structure-learning-algorithms-properties-gobnilp-instantiations-gobnilp-algorithm.md "Gobnilp instance") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/gobnilp/items`

*   [Gobnilp algorithm](./config-definitions-gobnilp-algorithm.md "Gobnilp instance") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/gobnilp`

*   [Graph graph inverse-Wishart model](./config-properties-resources-properties-parameters-sampling-algorithm-properties-list-of-graph-inverse-wishart-ids-graph-graph-inverse-wishart-model.md "Parameter setting for a graph inverse-Wishart model") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/parameters/properties/trilearn_g_inv_wishart/items`

*   [Graph graph inverse-Wishart model](./config-definitions-graph-graph-inverse-wishart-model.md "Parameter setting for a graph inverse-Wishart model") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/trilearn_g_inv_wishart`

*   [Graph intra-class model](./config-properties-resources-properties-parameters-sampling-algorithm-properties-list-of-graph-intra-class-ids-graph-intra-class-model.md "Parameter setting for a graph intra-class model") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/parameters/properties/trilearn_intra-class/items`

*   [Graph intra-class model](./config-definitions-graph-intra-class-model.md "Parameter setting for a graph intra-class model") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/trilearn_intra-class`

*   [Graph sampling algorithms](./config-properties-resources-properties-graph-sampling-algorithms.md "The available graph sampling algorithms") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/graph`

*   [Green & Thomas algorithm for sampling from decomposable graph distributions](./config-properties-resources-properties-available-structure-learning-algorithms-properties-green--thomas-ids-green--thomas-algorithm-for-sampling-from-decomposable-graph-distributions.md "Green & Thomas algorithm for learning decomopasble graphs") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/gt13_multipair/items`

*   [Green & Thomas algorithm for sampling from decomposable graph distributions](./config-definitions-green--thomas-algorithm-for-sampling-from-decomposable-graph-distributions.md "Green & Thomas algorithm for learning decomopasble graphs") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/gt13_multipair`

*   [Grow shrink (GS) algorithm (paramter setting)](./config-definitions-grow-shrink-gs-algorithm-paramter-setting.md "Grow shrink (GS) algorithm instance") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/bnlearn_gs`

*   [Guidici & Green algorithm for sampling from decomposable graph distributions](./config-properties-resources-properties-available-structure-learning-algorithms-properties-guidici--green-ids-guidici--green-algorithm-for-sampling-from-decomposable-graph-distributions.md "Guidici & Green algorithm for learning decomopasble graphs") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/gg99_singlepair/items`

*   [Guidici & Green algorithm for sampling from decomposable graph distributions](./config-definitions-guidici--green-algorithm-for-sampling-from-decomposable-graph-distributions.md "Guidici & Green algorithm for learning decomopasble graphs") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/gg99_singlepair`

*   [HC algorithm (parameter setting)](./config-properties-resources-properties-available-structure-learning-algorithms-properties-hc-instantiations-hc-algorithm-parameter-setting.md "HC algorithm instance") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/bnlearn_hc/items`

*   [HC algorithm (parameter setting)](./config-definitions-hc-algorithm-parameter-setting.md "HC algorithm instance") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/bnlearn_hc`

*   [Hyper-Dirichlet](./config-properties-resources-properties-parameters-sampling-algorithm-properties-list-of-hyper-dirichlet-ids-hyper-dirichlet.md "Parameter setting for a hyper Dirichlet distribution") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/parameters/properties/trilearn_hyper-dir/items`

*   [Hyper-Dirichlet](./config-definitions-hyper-dirichlet.md "Parameter setting for a hyper Dirichlet distribution") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/trilearn_hyper-dir`

*   [Inter-IAMB algorithm](./config-properties-resources-properties-available-structure-learning-algorithms-properties-inter-iamb-instantiations-inter-iamb-algorithm.md "Inter-IAMB algorithm instance") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/bnlearn_interiamb/items`

*   [Inter-IAMB algorithm](./config-properties-resources-properties-available-structure-learning-algorithms-properties-gs-instantiations-inter-iamb-algorithm.md "Inter-IAMB algorithm instance") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/bnlearn_gs/items`

*   [Inter-IAMB algorithm](./config-definitions-inter-iamb-algorithm.md "Inter-IAMB algorithm instance") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/bnlearn_interiamb`

*   [Iterative search (paramter setting)](./config-properties-resources-properties-available-structure-learning-algorithms-properties-iterative-1-search-instantiations-iterative-search-paramter-setting.md "Iterative search +1 algorithm instance") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/bidag_itsearch/items`

*   [Iterative search (paramter setting)](./config-definitions-iterative-search-paramter-setting.md "Iterative search +1 algorithm instance") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/bidag_itsearch`

*   [Max-min hill climbing algorithm (MMHC)](./config-properties-resources-properties-available-structure-learning-algorithms-properties-mmhc-instantiations-max-min-hill-climbing-algorithm-mmhc.md "MMHC algorithm instance") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/bnlearn_mmhc/items`

*   [Max-min hill climbing algorithm (MMHC)](./config-definitions-max-min-hill-climbing-algorithm-mmhc.md "MMHC algorithm instance") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/bnlearn_mmhc`

*   [Notears](./config-properties-resources-properties-available-structure-learning-algorithms-properties-notears-instantiations-notears.md "Notears instantiation") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/notears/items`

*   [Notears](./config-definitions-notears.md "Notears instantiation") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/notears`

*   [Order MCMC (parameter setting)](./config-properties-resources-properties-available-structure-learning-algorithms-properties-order-mcmc-instantiations-order-mcmc-parameter-setting.md "Order MCMC algorithm instance") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/bidag_order_mcmc/items`

*   [Order MCMC (parameter setting)](./config-definitions-order-mcmc-parameter-setting.md "Order MCMC algorithm instance") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/bidag_order_mcmc`

*   [PC algorithm](./config-properties-resources-properties-available-structure-learning-algorithms-properties-pc-algorithm-instantiations-pc-algorithm.md "PC algorithm instance") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/pcalg_pc/items`

*   [PC algorithm](./config-definitions-pc-algorithm.md "PC algorithm instance") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/pcalg_pc`

*   [PCalg SEM params](./config-properties-resources-properties-parameters-sampling-algorithm-properties-list-of-sem_params-ids-pcalg-sem-params.md "Parameter setting for PC alg DAG sampling") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/parameters/properties/sem_params/items`

*   [PCalg SEM params](./config-definitions-pcalg-sem-params.md "Parameter setting for PC alg DAG sampling") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/sem_params`

*   [Parameters sampling algorithm](./config-properties-resources-properties-parameters-sampling-algorithm.md "The available parameter sampling algorithms") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/parameters`

*   [RFCI](./config-properties-resources-properties-available-structure-learning-algorithms-properties-rfci-instantiations-rfci.md "RFCI instance") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/tetrad_rfci/items`

*   [RFCI](./config-definitions-rfci.md "RFCI instance") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/tetrad_rfci`

*   [ROC item](./config-properties-benchmark-setup-properties-evaluation-methods-properties-roc-item.md "ROC item") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/benchmark_setup/properties/evaluation/properties/roc`

*   [ROC item](./config-definitions-roc-item.md "ROC item") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/roc`

*   [Standard sampling](./config-properties-resources-properties-data-sampling-algorithms-properties-list-of-iid-setups-standard-sampling.md "Data sampling from disctete Bayesian network") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/data/properties/iid/items`

*   [Standard sampling](./config-definitions-standard-sampling.md "Data sampling from disctete Bayesian network") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/iid`

*   [TABU search (parameter setting)](./config-properties-resources-properties-available-structure-learning-algorithms-properties-tabu-search-instantiations-tabu-search-parameter-setting.md "TABU algorithm instance") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/bnlearn_tabu/items`

*   [TABU search (parameter setting)](./config-definitions-tabu-search-parameter-setting.md "TABU algorithm instance") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/bnlearn_tabu`

*   [Trilearn](./config-properties-resources-properties-available-structure-learning-algorithms-properties-list-of-trilearn-instantiations-trilearn.md "Parameter setting for trilearn with log-linear decomposable model") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/trilearn_pgibbs/items`

*   [Trilearn](./config-definitions-trilearn.md "Parameter setting for trilearn with log-linear decomposable model") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/trilearn_pgibbs`

*   [bin_bn](./config-properties-resources-properties-parameters-sampling-algorithm-properties-bin_bn-bin_bn.md "Parameter setting for generateBinaryBN") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/parameters/properties/bin_bn/items`

*   [bin_bn](./config-definitions-bin_bn.md "Parameter setting for generateBinaryBN") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/bin_bn`

*   [pcalg randDAG](./config-properties-resources-properties-graph-sampling-algorithms-properties-list-of-pcalg_randdag-instantiations-pcalg-randdag.md "An instance of pcalg randdag") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/graph/properties/pcalg_randdag/items`

*   [pcalg randDAG](./config-definitions-pcalg-randdag.md "An instance of pcalg randdag") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/pcalg_randdag`

### Arrays

*   [Band matrix id's](./config-properties-resources-properties-graph-sampling-algorithms-properties-band-matrix-ids.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/graph/properties/bandmat`

*   [Christmas tree algorithm id's](./config-properties-resources-properties-graph-sampling-algorithms-properties-christmas-tree-algorithm-ids.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/graph/properties/trilearn_cta`

*   [Data setup](./config-properties-benchmark-setup-properties-data-setup.md "A list of data setup instantiations") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/benchmark_setup/properties/data`

*   [FCI instantiations](./config-properties-resources-properties-available-structure-learning-algorithms-properties-fci-instantiations.md "FCI instantiations") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/tetrad_fci`

*   [GFCI instantiations](./config-properties-resources-properties-available-structure-learning-algorithms-properties-gfci-instantiations.md "GFCI instantiations") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/tetrad_gfci`

*   [GLasso](./config-properties-resources-properties-available-structure-learning-algorithms-properties-glasso.md "GLasso scikit-learn implementation") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/sklearn_glasso`

*   [GS instantiations](./config-properties-resources-properties-available-structure-learning-algorithms-properties-gs-instantiations.md "GS instantiations") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/bnlearn_gs`

*   [Gobnilp instantiations](./config-properties-resources-properties-available-structure-learning-algorithms-properties-gobnilp-instantiations.md "Gobnilp instantiations") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/gobnilp`

*   [Green & Thomas id's](./config-properties-resources-properties-available-structure-learning-algorithms-properties-green--thomas-ids.md "Green & Thomas instantiations") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/gt13_multipair`

*   [Guidici & Green id's](./config-properties-resources-properties-available-structure-learning-algorithms-properties-guidici--green-ids.md "Guidici & Green parametrisarion") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/gg99_singlepair`

*   [HC instantiations](./config-properties-resources-properties-available-structure-learning-algorithms-properties-hc-instantiations.md "HC instantiations") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/bnlearn_hc`

*   [Inter-IAMB instantiations](./config-properties-resources-properties-available-structure-learning-algorithms-properties-inter-iamb-instantiations.md "Inter-IAMB instantiations") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/bnlearn_interiamb`

*   [Iterative +1 search instantiations](./config-properties-resources-properties-available-structure-learning-algorithms-properties-iterative-1-search-instantiations.md "Iterative +1 search instantiations") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/bidag_itsearch`

*   [List of 2 integers \[a, b\], where a<=b.](./config-definitions-data-setup-properties-seed-range-anyof-list-of-2-integers-a-b-where-ab.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/data_setup_dict/properties/seed_range/anyOf/0`

*   [List of 2 integers \[a, b\], where a<=b.](./config-definitions-data-setup-properties-seed-range-anyof-list-of-2-integers-a-b-where-ab.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/data_setup_dict/properties/seed_range/anyOf/0`

*   [List of Hyper-Dirichlet id's](./config-properties-resources-properties-parameters-sampling-algorithm-properties-list-of-hyper-dirichlet-ids.md "List of trilearn_hyper-dir id's") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/parameters/properties/trilearn_hyper-dir`

*   [List of blip instantiations](./config-properties-resources-properties-available-structure-learning-algorithms-properties-list-of-blip-instantiations.md "List of blip instantiations") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/rblip`

*   [List of graph intra-class id's](./config-properties-resources-properties-parameters-sampling-algorithm-properties-list-of-graph-intra-class-ids.md "List of intra-class id's") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/parameters/properties/trilearn_intra-class`

*   [List of graph inverse-Wishart id's](./config-properties-resources-properties-parameters-sampling-algorithm-properties-list-of-graph-inverse-wishart-ids.md "List of graph inverse-Wishart id's") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/parameters/properties/trilearn_g_inv_wishart`

*   [List of iid setups.](./config-properties-resources-properties-data-sampling-algorithms-properties-list-of-iid-setups.md "List of iid setups") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/data/properties/iid`

*   [List of notears id's](./config-properties-resources-properties-parameters-sampling-algorithm-properties-list-of-notears-ids.md "List of notears id's") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/parameters/properties/notears_parameters_sampling`

*   [List of pcalg_randdag instantiations](./config-properties-resources-properties-graph-sampling-algorithms-properties-list-of-pcalg_randdag-instantiations.md "List of pcalg_randdag instantiations") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/graph/properties/pcalg_randdag`

*   [List of sem_params id's](./config-properties-resources-properties-parameters-sampling-algorithm-properties-list-of-sem_params-ids.md "List of sem_params id's") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/parameters/properties/sem_params`

*   [List of trilearn instantiations](./config-properties-resources-properties-available-structure-learning-algorithms-properties-list-of-trilearn-instantiations.md "List of trilearn instantiations") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/trilearn_pgibbs`

*   [MMHC instantiations](./config-properties-resources-properties-available-structure-learning-algorithms-properties-mmhc-instantiations.md "MMHC instantiations") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/bnlearn_mmhc`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative integer list](./config-definitions-non-negative-integers-anyof-non-negative-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegint/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Non-negative number list](./config-definitions-flexnonnegnum-anyof-non-negative-number-list.md "List of non-negative numbers") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnonnegnum/anyOf/1`

*   [Notears DAG sampling id's](./config-properties-resources-properties-graph-sampling-algorithms-properties-notears-dag-sampling-ids.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/graph/properties/notears`

*   [Notears instantiations](./config-properties-resources-properties-available-structure-learning-algorithms-properties-notears-instantiations.md "Notears instantiations") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/notears`

*   [Order MCMC instantiations](./config-properties-resources-properties-available-structure-learning-algorithms-properties-order-mcmc-instantiations.md "Order MCMC instantiations") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/bidag_order_mcmc`

*   [PC algorithm instantiations](./config-properties-resources-properties-available-structure-learning-algorithms-properties-pc-algorithm-instantiations.md "PC algorithm instantiations") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/pcalg_pc`

*   [Positive integer list](./config-definitions-non-negative-integers-1-anyof-positive-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnatnum/anyOf/1`

*   [Positive integer list](./config-definitions-non-negative-integers-1-anyof-positive-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnatnum/anyOf/1`

*   [Positive integer list](./config-definitions-non-negative-integers-1-anyof-positive-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnatnum/anyOf/1`

*   [Positive integer list](./config-definitions-non-negative-integers-1-anyof-positive-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnatnum/anyOf/1`

*   [Positive integer list](./config-definitions-non-negative-integers-1-anyof-positive-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnatnum/anyOf/1`

*   [Positive integer list](./config-definitions-non-negative-integers-1-anyof-positive-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnatnum/anyOf/1`

*   [Positive integer list](./config-definitions-non-negative-integers-1-anyof-positive-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnatnum/anyOf/1`

*   [Positive integer list](./config-definitions-non-negative-integers-1-anyof-positive-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnatnum/anyOf/1`

*   [Positive integer list](./config-definitions-non-negative-integers-1-anyof-positive-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnatnum/anyOf/1`

*   [Positive integer list](./config-definitions-non-negative-integers-1-anyof-positive-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnatnum/anyOf/1`

*   [Positive integer list](./config-definitions-non-negative-integers-1-anyof-positive-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnatnum/anyOf/1`

*   [Positive integer list](./config-definitions-non-negative-integers-1-anyof-positive-integer-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexnatnum/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [Probability list](./config-definitions-numbers-in-the-range-01-anyof-probability-list.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/flexprob/anyOf/1`

*   [RFCI instantiations](./config-properties-resources-properties-available-structure-learning-algorithms-properties-rfci-instantiations.md "RFCI instantiations") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/tetrad_rfci`

*   [Random sized band matrix id's](./config-properties-resources-properties-graph-sampling-algorithms-properties-random-sized-band-matrix-ids.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/graph/properties/rand_bandmat`

*   [Tabu search instantiations](./config-properties-resources-properties-available-structure-learning-algorithms-properties-tabu-search-instantiations.md "Tabu search instantiations") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/bnlearn_tabu`

*   [Untitled array in JSON schema for BenchPress config file.](./config-properties-benchmark-setup-properties-evaluation-methods-properties-adjmat_plots.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/benchmark_setup/properties/evaluation/properties/adjmat_plots`

*   [Untitled array in JSON schema for BenchPress config file.](./config-properties-benchmark-setup-properties-evaluation-methods-properties-graph_plots.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/benchmark_setup/properties/evaluation/properties/graph_plots`

*   [Untitled array in JSON schema for BenchPress config file.](./config-properties-benchmark-setup-properties-evaluation-methods-properties-mcmc_traj_plots.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/benchmark_setup/properties/evaluation/properties/mcmc_traj_plots`

*   [Untitled array in JSON schema for BenchPress config file.](./config-definitions-mcmc_traj_plots-items-properties-functional-anyof-1.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/mcmc_traj_plots/items/properties/functional/anyOf/1`

*   [Untitled array in JSON schema for BenchPress config file.](./config-properties-benchmark-setup-properties-evaluation-methods-properties-mcmc_heatmaps.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/benchmark_setup/properties/evaluation/properties/mcmc_heatmaps`

*   [Untitled array in JSON schema for BenchPress config file.](./config-properties-benchmark-setup-properties-evaluation-methods-properties-mcmc_autocorr_plots.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/benchmark_setup/properties/evaluation/properties/mcmc_autocorr_plots`

*   [Untitled array in JSON schema for BenchPress config file.](./config-definitions-mcmc_autocorr_plots-items-properties-functional-anyof-1.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/mcmc_autocorr_plots/items/properties/functional/anyOf/1`

*   [Untitled array in JSON schema for BenchPress config file.](./config-properties-resources-properties-parameters-sampling-algorithm-properties-bin_bn.md "List of generateBinayBN instantiations") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/parameters/properties/bin_bn`

*   [Untitled array in JSON schema for BenchPress config file.](./config-definitions-order-mcmc-parameter-setting-properties-startspace_algorithm-anyof-2.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/bidag_order_mcmc/properties/startspace_algorithm/anyOf/2`

*   [Untitled array in JSON schema for BenchPress config file.](./config-definitions-mcmc_autocorr_plots.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/mcmc_autocorr_plots`

*   [Untitled array in JSON schema for BenchPress config file.](./config-definitions-mcmc_autocorr_plots-items-properties-functional-anyof-1.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/mcmc_autocorr_plots/items/properties/functional/anyOf/1`

*   [Untitled array in JSON schema for BenchPress config file.](./config-definitions-mcmc_traj_plots.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/mcmc_traj_plots`

*   [Untitled array in JSON schema for BenchPress config file.](./config-definitions-mcmc_traj_plots-items-properties-functional-anyof-1.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/mcmc_traj_plots/items/properties/functional/anyOf/1`

*   [Untitled array in JSON schema for BenchPress config file.](./config-definitions-mcmc_heatmaps.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/mcmc_heatmaps`

*   [Untitled array in JSON schema for BenchPress config file.](./config-definitions-order-mcmc-parameter-setting-properties-startspace_algorithm-anyof-2.md) – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/definitions/bidag_order_mcmc/properties/startspace_algorithm/anyOf/2`

*   [fGES instantiations](./config-properties-resources-properties-available-structure-learning-algorithms-properties-fges-instantiations.md "fGES instantiations") – `http://github.com/felixleopoldo/benchpress/schema/config.schema.json#/properties/resources/properties/structure_learning_algorithms/properties/tetrad_fges`

## Version Note

The schemas linked above follow the JSON Schema Spec version: `http://json-schema.org/draft-04/schema#`
