function createAndPlotWaveEquationSnapshots()
%createAndPlotWaveEquationSnapshots - creates an analytic solution of the
%linear acoustic wave equation and plots the density snapshots in a pcolor
% plot
%
%--------------------------------------------------------------------------
% version 1.0 (July 26, 2021)
% authors:
% - Felix Black (TU Berlin), black@math.tu-berlin.de
% - Philipp Schulze (TU Berlin), pschulze@math.tu-berlin.de
% - Benjamin Unger (U Stuttgart), benjamin.unger@simtech.uni-stuttgart.de
%--------------------------------------------------------------------------

% create analytical solution:
qp = @(x) exp(-(60*(0.001*x-0.5))^2); % left-going wave
qm = @(x) exp(-(60*(0.001*x-0.5))^2); % right-going wave
c = 0.18 ; % wave speed
v = @(t,x) qp(x-c*t) + qm(x+c*t); % analytic solution for the density

% discretization
n_space_steps = 3000 ;
n_time_steps = 600 ;
tt = linspace(0,2100,n_time_steps) ;
xx = linspace(0,1000,n_space_steps) ;

% evaluate analytic solution on the space-time grid:
sol = NaN(n_time_steps,n_space_steps) ;
for i=1:n_time_steps
    for j=1:n_space_steps
        sol(i,j) = v(tt(i),xx(j)) ;
    end
end

% plotting
figure()
pcolor(xx,tt,sol)
shading flat
xlabel('x[m]')
ylabel('t[s]')