function A = wildlandFireLinearPart_matrix(D, DD, v)
% wildlandFireLinearPart_matrix - gives matrix for the linear part of the
% wildland fire
%
% inputs:
% - D: finite difference matrix for the 1st derivative
% - DD: finite difference matrix for the 2nd derivative 
% - v: wind velocity
%
% outputs:
% - A: matrix for the linear part of the wildland fire
%
%--------------------------------------------------------------------------
% version 1.0 (July 27, 2021)
% authors:
% - Felix Black (TU Berlin), black@math.tu-berlin.de
% - Philipp Schulze (TU Berlin), pschulze@math.tu-berlin.de
% - Benjamin Unger (U Stuttgart), benjamin.unger@simtech.uni-stuttgart.de
%--------------------------------------------------------------------------

% PDE coefficients
kappa = 2.1360e-01 ;
alpha = 1.8793e02 ;
gamma = 4.8372e-05 ;

% number of steps in space
Nxi = size(D, 1) ;

% matrix for the linear part of the wildfire ROM
A = [kappa*DD-v*D-gamma*alpha*speye(Nxi),sparse(Nxi,Nxi); sparse(Nxi,2*Nxi)] ;