function right_hand_side = evaluate_wildlandFire_right_hand_side(t, u, wildlandFireMatrix, beta, alpha, gammaS)
% evaluate_wildlandFire_right_hand_side - evaluates the right-hand side of
% the wildland fire model
%
% inputs:
% - t: dummy input to fit to the ode45 syntax
% - u: current value of the state ([temperature; supply mass fraction])
% - wildlandFireMatrix: matrix for the linear part of the wildland fire
% model
% - beta: Arrhenius coefficient
% - alpha: temperature rise per second
% - gammaS: pre-exponential factor
%
% outputs:
% - right_hand_side: vector of the right-hand side
%
% dependencies:
% - evaluateWildlandFireNonlinearity (in LIB/SIMULATION)
%
%--------------------------------------------------------------------------
% version 1.0 (July 27, 2021)
% authors:
% - Felix Black (TU Berlin), black@math.tu-berlin.de
% - Philipp Schulze (TU Berlin), pschulze@math.tu-berlin.de
% - Benjamin Unger (U Stuttgart), benjamin.unger@simtech.uni-stuttgart.de
%--------------------------------------------------------------------------

Nxi = round(0.5*length(u)) ; % number of steps in space
T = u(1:Nxi) ; % current temperature
S = u(Nxi+1:end) ; % current supply mass fraction

% nonlinear part of the right-hand side
nonlinearity = evaluateWildlandFireNonlinearity(u, beta, alpha, gammaS) ;

% right-hand side as sum of linear part and nonlinear part
right_hand_side = wildlandFireMatrix*[T;S]+nonlinearity ;