function xWave = trackMaximumNegativeSlope(snapshotMatrix)
%trackMaximumNegativeSlope - determines position of minimum spatial
% derivative in each snapshot of snapshotMatrix
%
% inputs:
% - snapshotMatrix: matrix of snapshots of a function depending on space
% and time
%
% output:
% - xWave: vector containing the determined positions
%
%--------------------------------------------------------------------------
% version 1.0 (July 27, 2021)
% authors:
% - Felix Black (TU Berlin), black@math.tu-berlin.de
% - Philipp Schulze (TU Berlin), pschulze@math.tu-berlin.de
% - Benjamin Unger (U Stuttgart), benjamin.unger@simtech.uni-stuttgart.de
%--------------------------------------------------------------------------

% compute finite differences for all snapshots
snapshotMatrixDiff = snapshotMatrix(2:end,:)-snapshotMatrix(1:end-1,:) ;
% find the minimum value in each snapshot
[~, xWave] = min(snapshotMatrixDiff) ;