function shiftMatrices = shiftMatrixGenerator_constZeroExtrapolation(discretization, shift)
% shiftMatrixGenerator_constZeroExtrapolation - constructs shift matrices 
% where the function to be shifted is continued over the boundaries via
% zero padding
%
% inputs:
% - discretization: struct array containing discretization parameters
% - shift: vector containing paths for each time step
%
% outputs:
% - shiftMatrices: cell array containing shift matrix for each time step
%
% dependencies:
% - lagrange (in LIB/INTERPOLATION)
%
%--------------------------------------------------------------------------
% version 1.0 (July 27, 2021)
% authors:
% - Felix Black (TU Berlin), black@math.tu-berlin.de
% - Philipp Schulze (TU Berlin), pschulze@math.tu-berlin.de
% - Benjamin Unger (U Stuttgart), benjamin.unger@simtech.uni-stuttgart.de
%--------------------------------------------------------------------------

% number of steps in space
Nxi = discretization.space.n_steps; 
dxi = discretization.space.dx; % spatial mesh width
nCs = length(shift) ; % number of time steps

% initialization
shiftMatrices = cell(nCs, 1) ;
diagonalIndexVec = NaN(1, 4) ; % vector containing the indices of the non-zero diagonals of the shift matrix

for i=1:nCs % loop over time steps
    shiftLength = shift(i) ; % current path value 
    % current indices of non-zero diagonals
    diagonalIndexVec(2) = floor(shiftLength/dxi) ;
    diagonalIndexVec(1) = diagonalIndexVec(2)-1 ;
    diagonalIndexVec(3) = diagonalIndexVec(2)+1 ;  
    diagonalIndexVec(4) = diagonalIndexVec(2)+2 ;
    % set up the shift matrix
    shiftMatrices{i} = spdiags(repmat((lagrange(shiftLength/dxi-diagonalIndexVec(2)))',Nxi,1), diagonalIndexVec, Nxi, Nxi) ;
end