function shifted_POD_system = init_shift_matrix(discretization, shift_matrix_generator, shift) 
    
% plotLeftGoingSeparatedWave - plots only the left-going wave both in the
% lab frame and in the co-moving reference frame
%
% inputs:
% - discretization: struct containing the discretization parameters
% - shift_matrix_generator: function used for constructing the shift 
% matrices
% - shift: matrix containing the path values for each traveling wave
%
% outputs:
% - shifted_POD_system: struct containing the shift matrices for each time
% step as well as the number of traveling waves
% 
%--------------------------------------------------------------------------
% version 1.0 (July 27, 2021)
% authors:
% - Felix Black (TU Berlin), black@math.tu-berlin.de
% - Philipp Schulze (TU Berlin), pschulze@math.tu-berlin.de
% - Benjamin Unger (U Stuttgart), benjamin.unger@simtech.uni-stuttgart.de
%--------------------------------------------------------------------------

% number of traveling waves
n_subspaces = size(shift, 2); 
shifted_POD_system.n_subspaces = n_subspaces;

% assembling of the shift matrices for each time step
shifted_POD_system.shift_matrices = cell(n_subspaces, 1); 
for i = 1:n_subspaces
    shifted_POD_system.shift_matrices{i} = shift_matrix_generator(discretization, shift(:,i));
end