function [pod_solution, reduced_state_matrix, computation_time] =  pod_online_struct_array(fom_rom, discretization, modes, PODROMMatrices, FModes_POD)
% shifted_pod_online_struct_array - computes the shifted POD ROM solution
% for all parameter values specified in the struct 'model'
%
% inputs:
% - fom_rom: struct array containing ROM settings like the Arrhenius 
% coefficient to be used
% - discretization: struct array containing discretization parameters
% - modes: POD modes determined in the offline phase
% - PODROMMatrices: struct containing the pre-computed coefficient matrices
% of the ROM
% - FModes_POD: DEIM modes
%
% outputs:
% - pod_solution: cell array containing the approximation based on the ROM 
% for each parameter value
% - reduced_state_matrix: cell array containing the coefficients for each
% parameter value
% - computation_time: vector containing the run time for each parameter 
% value
%
% dependencies:
% - pod_online_ode45 (in LIB/POD)
%
%--------------------------------------------------------------------------
% version 1.0 (July 28, 2021)
% authors:
% - Felix Black (TU Berlin), black@math.tu-berlin.de
% - Philipp Schulze (TU Berlin), pschulze@math.tu-berlin.de
% - Benjamin Unger (U Stuttgart), benjamin.unger@simtech.uni-stuttgart.de
%--------------------------------------------------------------------------

% number of ROM simulations to be performed (coincides with the number of
% parameter values)
n_simulations = length(fom_rom);

% initialization of output variables
pod_solution = cell(1, n_simulations);
reduced_state_matrix = cell(1, n_simulations);
computation_time = zeros(1, n_simulations);

% simulate ROM for each parameter value
for i = 1:n_simulations
    % simulate ROM for current parameter value
    [pod_solution{i}, reduced_state_matrix{i}, computation_time(i)] = pod_online_ode45(modes, discretization(i), fom_rom(i).parameter, fom_rom(i).initial_condition, PODROMMatrices, FModes_POD) ;
end