function [modes, redState, offline, relErr, sPODapprox, PODModes] = shifted_pod_offline_struct_array(snapshots, fom, discretization, offline, shifts)
% shifted_pod_offline_struct_array - performs mode decomposition via
% shifted POD for each parameter value
%
% inputs:
% - snapshots: cell array containing snapshot matrix of FOM solution
% for each parameter value
% - fom: struct array containing parameters for the FOM
% - discretization: struct array containing discretization parameters
% - offline: struct containing parameters for the mode decomposition
% - shifts: matrix containing paths for each traveling wave and for each
% time step; optional argument
%
% outputs:
% - modes: matrix containing the determined modes
% - redState: cell array containing the coefficients and the paths for each
% parameter value
% - offline: struct containing parameters for the mode decomposition
% - relErr: vector containing the relative approximation error for each
% parameter value
% - sPODapprox: cell array containing the shifted POD approximation for
% each parameter value
% - PODModes: cell array containing the POD modes used before and after the
% switch (areas (i) and (ii)); only determined if offline.method equals 
% @subspaceDecompositionSPODswitch
%
% dependencies:
% - shifted_pod_offline (in LIB/MODE_DECOMPOSITION)
%
%--------------------------------------------------------------------------
% version 1.0 (July 27, 2021)
% authors:
% - Felix Black (TU Berlin), black@math.tu-berlin.de
% - Philipp Schulze (TU Berlin), pschulze@math.tu-berlin.de
% - Benjamin Unger (U Stuttgart), benjamin.unger@simtech.uni-stuttgart.de
%--------------------------------------------------------------------------

% number of parameter values
n_samples = length(snapshots);

% collect different Arrhenius coefficients
beta = NaN(n_samples, 1) ;
for j=1:n_samples
    beta(j) = fom(j).parameter.beta ;
end

% call of shifted_pod_offline
if(nargin>4) % if shifts are provided
    if(strcmp(func2str(offline.method),'subspaceDecompositionSPODswitch')) % this method computes also POD modes
        [modes, redState, offline, relErr, sPODapprox, PODModes] = shifted_pod_offline(snapshots, discretization, offline, beta, shifts) ;
    else
        [modes, redState, offline, relErr, sPODapprox] = shifted_pod_offline(snapshots, discretization, offline, beta, shifts) ;
    end
else
    if(strcmp(func2str(offline.method),'subspaceDecompositionSPODswitch')) % this method computes also POD modes
        [modes, redState, offline, relErr, sPODapprox, PODModes] = shifted_pod_offline(snapshots, discretization, offline, beta) ;
    else
        [modes, redState, offline, relErr, sPODapprox] = shifted_pod_offline(snapshots, discretization, offline, beta) ;
    end
end