function lx = lagrange(x) 
% lagrange - determines interpolation coefficients based on a cubic
% Lagrange polynomial; assumes the sampling points [-1 0 1 2]
%
% inputs:
% - x: point where the interpolant should be evaluated
%
% outputs:
% - lx: interpolation coefficients corresponding to the 4 sampling points
%
%--------------------------------------------------------------------------
% version 1.0 (July 27, 2021)
% authors:
% - Felix Black (TU Berlin), black@math.tu-berlin.de
% - Philipp Schulze (TU Berlin), pschulze@math.tu-berlin.de
% - Benjamin Unger (U Stuttgart), benjamin.unger@simtech.uni-stuttgart.de
%--------------------------------------------------------------------------

lx    = zeros(4,1)           ;
lx(1) = -1/6*(x^3-3*x^2+2*x) ;
lx(2) = 1/2*(x^3-2*x^2-x+2)  ;
lx(3) = -1/2*(x^3-x^2-2*x)   ;
lx(4) = 1/6*(x^3-x)          ;