function T0 = loadInitialTemperature(x, L)
% loadInitialTemperature - loads temperature initial condition and
% evaluates it at x
%
% inputs:
% - x: row vector of spatial points
% - L: length of the computational domain
%
% outputs:
% - T0: value of initial condition at x
%
%--------------------------------------------------------------------------
% version 1.0 (July 27, 2021)
% authors:
% - Felix Black (TU Berlin), black@math.tu-berlin.de
% - Philipp Schulze (TU Berlin), pschulze@math.tu-berlin.de
% - Benjamin Unger (U Stuttgart), benjamin.unger@simtech.uni-stuttgart.de
%--------------------------------------------------------------------------


S = load('DATA/ICSeparatedWaves.mat') ; % load the initial condition
T0Sample = S.T0 ; % get the temperature part of the initial condition

nSteps = length(T0Sample) ; % number of steps in space
dx = L/nSteps; % spatial mesh width
xSample = dx*(1:nSteps); % array of spatial points

T0 = interp1(xSample, T0Sample, x) ; % evaluate initial condition at x via a piecewise linear interpolant