function S0 = loadInitialSpeciesFraction(x, L)
% loadInitialSpeciesFraction - loads supply mass fraction initial condition 
% and evaluates it at x
%
% inputs:
% - x: row vector of spatial points
% - L: length of the computational domain
%
% outputs:
% - S0: value of initial condition at x
%
%--------------------------------------------------------------------------
% version 1.0 (July 27, 2021)
% authors:
% - Felix Black (TU Berlin), black@math.tu-berlin.de
% - Philipp Schulze (TU Berlin), pschulze@math.tu-berlin.de
% - Benjamin Unger (U Stuttgart), benjamin.unger@simtech.uni-stuttgart.de
%--------------------------------------------------------------------------


S = load('DATA/ICSeparatedWaves.mat') ; % load the initial condition
S0Sample = S.S0 ; % get the supply mass fraction part of the initial condition

nSteps = length(S0Sample) ; % number of steps in space
dx = L/nSteps; % spatial mesh width
xSample = dx*(1:nSteps); % array of spatial points

S0 = interp1(xSample, S0Sample, x) ; % evaluate initial condition at x via a piecewise linear interpolant