function y = gaussian_pulse(x, length)
% gaussian_pulse - evaluates a Gaussian pulse at x
%
% inputs:
% - x: row vector of spatial points
% - length: length of the computational domain
%
% outputs:
% - y: value of Gaussian at x
%
%--------------------------------------------------------------------------
% version 1.0 (July 27, 2021)
% authors:
% - Felix Black (TU Berlin), black@math.tu-berlin.de
% - Philipp Schulze (TU Berlin), pschulze@math.tu-berlin.de
% - Benjamin Unger (U Stuttgart), benjamin.unger@simtech.uni-stuttgart.de
%--------------------------------------------------------------------------

y = exp(-((x - (length/2))/(10*sqrt(2))).^2);