function bilinearForm = wIPOM(shiftMatrix1, shiftMatrix2, U1, U2, A)
% iPOM - computes outputs of the bilinear form x'*A*y, where the columns 
% of shiftMatrix1*U1 are substituted for x and the columns of 
% shiftMatrix2*U2 are substituted for y
%
% inputs:
% - shiftMatrix1: nxn matrix
% - shiftMatrix2: nxn matrix
% - U1: nxm matrix
% - U2: nxm matrix
% - A: nxn matrix
%
% outputs:
% - bilinearForm: matrix containing the outputs of the bilinear form
%
%--------------------------------------------------------------------------
% version 1.0 (July 28, 2021)
% authors:
% - Felix Black (TU Berlin), black@math.tu-berlin.de
% - Philipp Schulze (TU Berlin), pschulze@math.tu-berlin.de
% - Benjamin Unger (U Stuttgart), benjamin.unger@simtech.uni-stuttgart.de
%--------------------------------------------------------------------------


Ushifted1 = shiftMatrix1*U1 ;
Ushifted2 = shiftMatrix2*U2 ;

bilinearForm = Ushifted1'*A*Ushifted2 ;