function innerProduct = iPOM(shiftMatrix1, shiftMatrix2, U1, U2)
% iPOM - computes inner products of the columns of (shiftMatrix1*U1) and
% the columns of (shiftMatrix2*U2)
%
% inputs:
% - shiftMatrix1: nxn matrix
% - shiftMatrix2: nxn matrix
% - U1: nxm matrix
% - U2: nxm matrix
%
% outputs:
% - innerProduct: matrix containing the inner products
%
%--------------------------------------------------------------------------
% version 1.0 (July 28, 2021)
% authors:
% - Felix Black (TU Berlin), black@math.tu-berlin.de
% - Philipp Schulze (TU Berlin), pschulze@math.tu-berlin.de
% - Benjamin Unger (U Stuttgart), benjamin.unger@simtech.uni-stuttgart.de
%--------------------------------------------------------------------------


Ushifted1 = shiftMatrix1*U1 ;
Ushifted2 = shiftMatrix2*U2 ;

innerProduct = Ushifted1'*Ushifted2 ;