function S = QDEIM(U)
% QDEIM - performs QDEIM algorithm as presented in the paper
% 
% Z. Drmac and S. Gugercin. A new selection operator for the discrete 
% empirical interpolation method - improved a priori error bound and 
% extensions. SIAM J. Sci. Comput 2016, 38, A631-A648. 
% doi:10.1137/15M1019271.
%
% inputs:
% - U: matrix of full column rank
%
% output:
% - S: DEIM row indices
%
%--------------------------------------------------------------------------
% original version of the code was presented in the paper cited above; the 
% code below is a slightly reduced version of this code; this modification
% was implemented by
% - Felix Black (TU Berlin), black@math.tu-berlin.de
% - Philipp Schulze (TU Berlin), pschulze@math.tu-berlin.de
% - Benjamin Unger (U Stuttgart), benjamin.unger@simtech.uni-stuttgart.de
%--------------------------------------------------------------------------

% number of columns in U
m = size(U, 2) ;

% determine a QR decomposition with partial pivoting and get the index
% vector of the corresponding permutation matrix
[~, ~, P] = qr(U', 'vector') ; 

% the first m entries of P correspond to the DEIM rows
S = P(1:m) ;