function r = evaluateWildlandFireNonlinearityHelper(T, beta)
% evaluateWildlandFireNonlinearityHelper - evaluates the modified Arrhenius
% law
%
% inputs:
% - T: current value of the temperature
% - beta: Arrhenius coefficient
%
% outputs:
% - r: dimensionless reaction rate
%
%--------------------------------------------------------------------------
% version 1.0 (July 27, 2021)
% authors:
% - Felix Black (TU Berlin), black@math.tu-berlin.de
% - Philipp Schulze (TU Berlin), pschulze@math.tu-berlin.de
% - Benjamin Unger (U Stuttgart), benjamin.unger@simtech.uni-stuttgart.de
%--------------------------------------------------------------------------

T0 = 0 ; % temperature of the environment
goodIndices = find(T-T0>=0) ; % indices where combustion takes place

% dimensionless reaction rate is computed via a modified Arrhenius law
r = zeros(length(T),1) ;
r(goodIndices) = exp(-beta./(T(goodIndices)-T0)) ;