function offline = create_offline_struct(offline_default)
% create_offline_struct - creates a struct containing parameters for the
% mode decomposition (offline phase)
%
% inputs:
% - offline_default: struct containing optional fields
%
% outputs:
% - offline: struct containing parameters for the mode decomposition
%
% dependencies:
% - shiftMatrixGenerator_constExtrapolation (in LIB/SHIFT)
%
%--------------------------------------------------------------------------
% version 1.0 (July 27, 2021)
% authors:
% - Felix Black (TU Berlin), black@math.tu-berlin.de
% - Philipp Schulze (TU Berlin), pschulze@math.tu-berlin.de
% - Benjamin Unger (U Stuttgart), benjamin.unger@simtech.uni-stuttgart.de
%--------------------------------------------------------------------------

% number of transformed modes for each traveling waves
offline.n_modes = offline_default.n_modes; 
% method used for mode decomposition
offline.method = offline_default.method;
% function used for creating the shift matrices
offline.shift_matrix_generator = @shiftMatrixGenerator_constExtrapolation ;
% method used for post processing the tracked shifts
offline.shiftPostProcessing.method = 'linearInterp' ;
% offset used for the path post processing
offline.shiftPostProcessing.offset = offline_default.shiftPostProcessing.offset ;

% number of traveling waves
offline.n_frames = 2;

% the following parameters only apply if offline.method equals 
% 'subspaceDecompositionSPODswitch'
if(strcmp(func2str(offline.method),'subspaceDecompositionSPODswitch'))
    % number of POD modes in area (i)
    if size(offline_default.nPODModesBeforeSwitch,2) == 1
        offline.nPODModesBeforeSwitch = offline_default.nPODModesBeforeSwitch*ones(1,offline.n_frames);
    else
        offline.nPODModesBeforeSwitch = offline_default.nPODModesBeforeSwitch;
    end
    % number of POD modes in area (ii)
    if size(offline_default.nPODModesAfterSwitch,2) == 1
        offline.nPODModesAfterSwitch = offline_default.nPODModesAfterSwitch*ones(1,offline.n_frames);
    else
        offline.nPODModesAfterSwitch = offline_default.nPODModesAfterSwitch;
    end
    % time point between area (i) and area (ii)
    offline.switchTime = offline_default.switchTime; 
    % time point between areas (ii-a) and (ii-b)
    offline.shiftedPODstart = offline_default.shiftedPODstart;
    % extrapolation of coefficients is done via polynomial extrapolation
    offline.extrapolationMethod = 'polynomial';
    % degree of the extrapolation polynomial
    offline.extrapolationPolOrder = offline_default.extrapolationPolOrder;
end