function relative_error = relative_L2_norm(snapshot_matrix, difference)
% relative_error - computes the L2 norm of 'difference' relative to the L2 
% norm of 'snapshot_matrix'; Space and time integrals are approximated via 
% trapezoidal rule. This function assumes periodic boundary conditions in
% space.
%
% inputs:
% - snapshotMatrix: reference snapshot matrix
% - difference: snapshot matrix whose relative L2 norm is to be computed
% 
% outputs:
% - relative_error: relative error in the L2 norm
%
%--------------------------------------------------------------------------
% version 1.0 (July 27, 2021)
% authors:
% - Felix Black (TU Berlin), black@math.tu-berlin.de
% - Philipp Schulze (TU Berlin), pschulze@math.tu-berlin.de
% - Benjamin Unger (U Stuttgart), benjamin.unger@simtech.uni-stuttgart.de
%--------------------------------------------------------------------------

% contributions from 1st and last snapshot to the squared L2 norms
abs_error_snapshot = 0.5 * (snapshot_matrix(:,1)' * snapshot_matrix(:,1) + snapshot_matrix(:,end)' * snapshot_matrix(:,end));
abs_error_difference = 0.5 * (difference(:,1)' * difference(:,1) + difference(:,end)' * difference(:,end));

% contributions from 2nd to (n-1)th snapshot to the squared L2 norms
for i = 2:size(snapshot_matrix, 2)-1
    abs_error_snapshot = abs_error_snapshot + snapshot_matrix(:,i)'*snapshot_matrix(:,i);
    abs_error_difference = abs_error_difference + difference(:,i)'*difference(:,i);
end

% compute the relative error
relative_error = sqrt(abs_error_difference / abs_error_snapshot);