#!/bin/bash
#SBATCH --job-name=DATAFOLDER
#SBATCH --account=project_2002413
#SBATCH --time=70:00:00
#SBATCH --mem-per-cpu=3G
#SBATCH --partition=small
#SBATCH -c 6
#SBATCH --mail-type=END

module load python-env/2019.3

cd /scratch/project_2002413/compound-errors
cd DATAFOLDER
mkdir data
mkdir MODELTYPE
python3 -m onmt.bin.preprocess -train_src train_source.txt -train_tgt train_target.txt -valid_src valid_source.txt -valid_tgt valid_target.txt -save_data data/vocabulary
#python3 -m onmt.bin.train -data data/vocabulary -save_model MODELTYPE/nmt-model -encoder_type MODELTYPE -seed 3435 -layers 6 -rnn_size 512 -word_vec_size 512 -transformer_ff 2048 -heads 8
python3 -m onmt.bin.train -data data/vocabulary -save_model MODELTYPE/nmt-model -encoder_type MODELTYPE -seed 3435 

lastmodel=$( ls -t MODELTYPE/*.pt | head -1 )

python3 -m onmt.bin.translate -model $lastmodel -src test_source.txt -output MODELTYPE_pred.txt -replace_unk
