/*
	Authored 2020, James Meech. Modified 2021, Phillip Stanley-Marbell.

	All rights reserved.

	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

	*	Redistributions of source code must retain the above
		copyright notice, this list of conditions and the following
		disclaimer.

	*	Redistributions in binary form must reproduce the above
		copyright notice, this list of conditions and the following
		disclaimer in the documentation and/or other materials
		provided with the distribution.

	*	Neither the name of the author nor the names of its
		contributors may be used to endorse or promote products
		derived from this software without specific prior written
		permission.

	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
	BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
	CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
	LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
	ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	POSSIBILITY OF SUCH DAMAGE.
*/
#include <assert.h>
#include <printf.h>
#include <stdint.h>
#include <inttypes.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <uncertain.h>
#include <stdint.h>
#include "bme680.h"

enum
{
	kWarpDataBME680CalibrationConstantSetCount	= 5,
	kWarpDataBME680DatastreamLength			= 20,
	kWarpDataBME680MaxPathNameLength		= 128,
} WarpDataBME680;

static void	usage(void);
static void	loadFloatDistFromPath(const char *  filename, int sampleCount, float *  returnValue);
static void	loadNthFloatFromPath(const char *  filename, uint64_t which, float *  returnValue);


int
main(int argc, char *  argv[])
{
	char		filename[kWarpDataBME680MaxPathNameLength];
	char *		pathPrefix;
	char *		modeString;
	float		temperature, pressure, humidity;
	float		temperatureRawADC, pressureRawADC, humidityRawADC;
	float		par_t1, par_t2, par_t3;
	float		par_p1, par_p2, par_p3, par_p4, par_p5, par_p6, par_p7, par_p8, par_p9, par_p10;
	float		par_h1, par_h2, par_h3, par_h4, par_h5, par_h6, par_h7;
	char		tmp;
	char *		ep = &tmp;
	uint64_t	indexForCalibrationParameters;


	if (argc != 4)
	{
		usage();
	}

	pathPrefix = argv[1];
	printf("Processing [%s*]...\n", pathPrefix);

	indexForCalibrationParameters = strtoul(argv[2], &ep, 0);
	if (*ep != '\0')
	{
		usage();
	}
	printf("Index for calibration parameters to use is [%" PRIu64 "]\n", indexForCalibrationParameters);

	modeString = argv[3];
	printf("Evaluation mode is [%s]...\n", modeString);

	if (!strcmp(modeString, "allCalibrationParametersAsDistributions"))
	{
		loadFloatDistFromPath("../inputs/BME680-par-t1.csv", kWarpDataBME680CalibrationConstantSetCount, &par_t1);
		loadFloatDistFromPath("../inputs/BME680-par-t2.csv", kWarpDataBME680CalibrationConstantSetCount, &par_t2);
		loadFloatDistFromPath("../inputs/BME680-par-t3.csv", kWarpDataBME680CalibrationConstantSetCount, &par_t3);

		loadFloatDistFromPath("../inputs/BME680-par-p1.csv", kWarpDataBME680CalibrationConstantSetCount, &par_p1);
		loadFloatDistFromPath("../inputs/BME680-par-p2.csv", kWarpDataBME680CalibrationConstantSetCount, &par_p2);
		loadFloatDistFromPath("../inputs/BME680-par-p3.csv", kWarpDataBME680CalibrationConstantSetCount, &par_p3);
		loadFloatDistFromPath("../inputs/BME680-par-p4.csv", kWarpDataBME680CalibrationConstantSetCount, &par_p4);
		loadFloatDistFromPath("../inputs/BME680-par-p5.csv", kWarpDataBME680CalibrationConstantSetCount, &par_p5);
		loadFloatDistFromPath("../inputs/BME680-par-p6.csv", kWarpDataBME680CalibrationConstantSetCount, &par_p6);
		loadFloatDistFromPath("../inputs/BME680-par-p7.csv", kWarpDataBME680CalibrationConstantSetCount, &par_p7);
		loadFloatDistFromPath("../inputs/BME680-par-p8.csv", kWarpDataBME680CalibrationConstantSetCount, &par_p8);
		loadFloatDistFromPath("../inputs/BME680-par-p9.csv", kWarpDataBME680CalibrationConstantSetCount, &par_p9);
		loadFloatDistFromPath("../inputs/BME680-par-p10.csv", kWarpDataBME680CalibrationConstantSetCount, &par_p10);

		loadFloatDistFromPath("../inputs/BME680-par-h1.csv", kWarpDataBME680CalibrationConstantSetCount, &par_h1);
		loadFloatDistFromPath("../inputs/BME680-par-h2.csv", kWarpDataBME680CalibrationConstantSetCount, &par_h2);
		loadFloatDistFromPath("../inputs/BME680-par-h3.csv", kWarpDataBME680CalibrationConstantSetCount, &par_h3);
		loadFloatDistFromPath("../inputs/BME680-par-h4.csv", kWarpDataBME680CalibrationConstantSetCount, &par_h4);
		loadFloatDistFromPath("../inputs/BME680-par-h5.csv", kWarpDataBME680CalibrationConstantSetCount, &par_h5);
		loadFloatDistFromPath("../inputs/BME680-par-h6.csv", kWarpDataBME680CalibrationConstantSetCount, &par_h6);
		loadFloatDistFromPath("../inputs/BME680-par-h7.csv", kWarpDataBME680CalibrationConstantSetCount, &par_h7);
	}
	else if (!strcmp(modeString, "OnlyCalibrationParameterT1AsDistribution"))
	{
		loadFloatDistFromPath("../inputs/BME680-par-t1.csv", kWarpDataBME680CalibrationConstantSetCount, &par_t1);
		loadNthFloatFromPath("../inputs/BME680-par-t2.csv", indexForCalibrationParameters, &par_t2);
		loadNthFloatFromPath("../inputs/BME680-par-t3.csv", indexForCalibrationParameters, &par_t3);

		loadNthFloatFromPath("../inputs/BME680-par-p1.csv", indexForCalibrationParameters, &par_p1);
		loadNthFloatFromPath("../inputs/BME680-par-p2.csv", indexForCalibrationParameters, &par_p2);
		loadNthFloatFromPath("../inputs/BME680-par-p3.csv", indexForCalibrationParameters, &par_p3);
		loadNthFloatFromPath("../inputs/BME680-par-p4.csv", indexForCalibrationParameters, &par_p4);
		loadNthFloatFromPath("../inputs/BME680-par-p5.csv", indexForCalibrationParameters, &par_p5);
		loadNthFloatFromPath("../inputs/BME680-par-p6.csv", indexForCalibrationParameters, &par_p6);
		loadNthFloatFromPath("../inputs/BME680-par-p7.csv", indexForCalibrationParameters, &par_p7);
		loadNthFloatFromPath("../inputs/BME680-par-p8.csv", indexForCalibrationParameters, &par_p8);
		loadNthFloatFromPath("../inputs/BME680-par-p9.csv", indexForCalibrationParameters, &par_p9);
		loadNthFloatFromPath("../inputs/BME680-par-p10.csv", indexForCalibrationParameters, &par_p10);

		loadNthFloatFromPath("../inputs/BME680-par-h1.csv", indexForCalibrationParameters, &par_h1);
		loadNthFloatFromPath("../inputs/BME680-par-h2.csv", indexForCalibrationParameters, &par_h2);
		loadNthFloatFromPath("../inputs/BME680-par-h3.csv", indexForCalibrationParameters, &par_h3);
		loadNthFloatFromPath("../inputs/BME680-par-h4.csv", indexForCalibrationParameters, &par_h4);
		loadNthFloatFromPath("../inputs/BME680-par-h5.csv", indexForCalibrationParameters, &par_h5);
		loadNthFloatFromPath("../inputs/BME680-par-h6.csv", indexForCalibrationParameters, &par_h6);
		loadNthFloatFromPath("../inputs/BME680-par-h7.csv", indexForCalibrationParameters, &par_h7);
	}
	else if (!strcmp(modeString, "OnlyCalibrationParameterT2AsDistribution"))
	{
		loadNthFloatFromPath("../inputs/BME680-par-t1.csv", indexForCalibrationParameters, &par_t1);
		loadFloatDistFromPath("../inputs/BME680-par-t2.csv", kWarpDataBME680CalibrationConstantSetCount, &par_t2);
		loadNthFloatFromPath("../inputs/BME680-par-t3.csv", indexForCalibrationParameters, &par_t3);

		loadNthFloatFromPath("../inputs/BME680-par-p1.csv", indexForCalibrationParameters, &par_p1);
		loadNthFloatFromPath("../inputs/BME680-par-p2.csv", indexForCalibrationParameters, &par_p2);
		loadNthFloatFromPath("../inputs/BME680-par-p3.csv", indexForCalibrationParameters, &par_p3);
		loadNthFloatFromPath("../inputs/BME680-par-p4.csv", indexForCalibrationParameters, &par_p4);
		loadNthFloatFromPath("../inputs/BME680-par-p5.csv", indexForCalibrationParameters, &par_p5);
		loadNthFloatFromPath("../inputs/BME680-par-p6.csv", indexForCalibrationParameters, &par_p6);
		loadNthFloatFromPath("../inputs/BME680-par-p7.csv", indexForCalibrationParameters, &par_p7);
		loadNthFloatFromPath("../inputs/BME680-par-p8.csv", indexForCalibrationParameters, &par_p8);
		loadNthFloatFromPath("../inputs/BME680-par-p9.csv", indexForCalibrationParameters, &par_p9);
		loadNthFloatFromPath("../inputs/BME680-par-p10.csv", indexForCalibrationParameters, &par_p10);

		loadNthFloatFromPath("../inputs/BME680-par-h1.csv", indexForCalibrationParameters, &par_h1);
		loadNthFloatFromPath("../inputs/BME680-par-h2.csv", indexForCalibrationParameters, &par_h2);
		loadNthFloatFromPath("../inputs/BME680-par-h3.csv", indexForCalibrationParameters, &par_h3);
		loadNthFloatFromPath("../inputs/BME680-par-h4.csv", indexForCalibrationParameters, &par_h4);
		loadNthFloatFromPath("../inputs/BME680-par-h5.csv", indexForCalibrationParameters, &par_h5);
		loadNthFloatFromPath("../inputs/BME680-par-h6.csv", indexForCalibrationParameters, &par_h6);
		loadNthFloatFromPath("../inputs/BME680-par-h7.csv", indexForCalibrationParameters, &par_h7);
	}
	else if (!strcmp(modeString, "OnlyCalibrationParameterT3AsDistribution"))
	{
		loadNthFloatFromPath("../inputs/BME680-par-t1.csv", indexForCalibrationParameters, &par_t1);
		loadNthFloatFromPath("../inputs/BME680-par-t2.csv", indexForCalibrationParameters, &par_t2);
		loadFloatDistFromPath("../inputs/BME680-par-t3.csv", kWarpDataBME680CalibrationConstantSetCount, &par_t3);

		loadNthFloatFromPath("../inputs/BME680-par-p1.csv", indexForCalibrationParameters, &par_p1);
		loadNthFloatFromPath("../inputs/BME680-par-p2.csv", indexForCalibrationParameters, &par_p2);
		loadNthFloatFromPath("../inputs/BME680-par-p3.csv", indexForCalibrationParameters, &par_p3);
		loadNthFloatFromPath("../inputs/BME680-par-p4.csv", indexForCalibrationParameters, &par_p4);
		loadNthFloatFromPath("../inputs/BME680-par-p5.csv", indexForCalibrationParameters, &par_p5);
		loadNthFloatFromPath("../inputs/BME680-par-p6.csv", indexForCalibrationParameters, &par_p6);
		loadNthFloatFromPath("../inputs/BME680-par-p7.csv", indexForCalibrationParameters, &par_p7);
		loadNthFloatFromPath("../inputs/BME680-par-p8.csv", indexForCalibrationParameters, &par_p8);
		loadNthFloatFromPath("../inputs/BME680-par-p9.csv", indexForCalibrationParameters, &par_p9);
		loadNthFloatFromPath("../inputs/BME680-par-p10.csv", indexForCalibrationParameters, &par_p10);

		loadNthFloatFromPath("../inputs/BME680-par-h1.csv", indexForCalibrationParameters, &par_h1);
		loadNthFloatFromPath("../inputs/BME680-par-h2.csv", indexForCalibrationParameters, &par_h2);
		loadNthFloatFromPath("../inputs/BME680-par-h3.csv", indexForCalibrationParameters, &par_h3);
		loadNthFloatFromPath("../inputs/BME680-par-h4.csv", indexForCalibrationParameters, &par_h4);
		loadNthFloatFromPath("../inputs/BME680-par-h5.csv", indexForCalibrationParameters, &par_h5);
		loadNthFloatFromPath("../inputs/BME680-par-h6.csv", indexForCalibrationParameters, &par_h6);
		loadNthFloatFromPath("../inputs/BME680-par-h7.csv", indexForCalibrationParameters, &par_h7);
	}
	else if (!strcmp(modeString, "OnlyCalibrationParameterP1AsDistribution"))
	{
		loadNthFloatFromPath("../inputs/BME680-par-t1.csv", indexForCalibrationParameters, &par_t1);
		loadNthFloatFromPath("../inputs/BME680-par-t2.csv", indexForCalibrationParameters, &par_t2);
		loadNthFloatFromPath("../inputs/BME680-par-t3.csv", indexForCalibrationParameters, &par_t3);

		loadFloatDistFromPath("../inputs/BME680-par-p1.csv", kWarpDataBME680CalibrationConstantSetCount, &par_p1);
		loadNthFloatFromPath("../inputs/BME680-par-p2.csv", indexForCalibrationParameters, &par_p2);
		loadNthFloatFromPath("../inputs/BME680-par-p3.csv", indexForCalibrationParameters, &par_p3);
		loadNthFloatFromPath("../inputs/BME680-par-p4.csv", indexForCalibrationParameters, &par_p4);
		loadNthFloatFromPath("../inputs/BME680-par-p5.csv", indexForCalibrationParameters, &par_p5);
		loadNthFloatFromPath("../inputs/BME680-par-p6.csv", indexForCalibrationParameters, &par_p6);
		loadNthFloatFromPath("../inputs/BME680-par-p7.csv", indexForCalibrationParameters, &par_p7);
		loadNthFloatFromPath("../inputs/BME680-par-p8.csv", indexForCalibrationParameters, &par_p8);
		loadNthFloatFromPath("../inputs/BME680-par-p9.csv", indexForCalibrationParameters, &par_p9);
		loadNthFloatFromPath("../inputs/BME680-par-p10.csv", indexForCalibrationParameters, &par_p10);

		loadNthFloatFromPath("../inputs/BME680-par-h1.csv", indexForCalibrationParameters, &par_h1);
		loadNthFloatFromPath("../inputs/BME680-par-h2.csv", indexForCalibrationParameters, &par_h2);
		loadNthFloatFromPath("../inputs/BME680-par-h3.csv", indexForCalibrationParameters, &par_h3);
		loadNthFloatFromPath("../inputs/BME680-par-h4.csv", indexForCalibrationParameters, &par_h4);
		loadNthFloatFromPath("../inputs/BME680-par-h5.csv", indexForCalibrationParameters, &par_h5);
		loadNthFloatFromPath("../inputs/BME680-par-h6.csv", indexForCalibrationParameters, &par_h6);
		loadNthFloatFromPath("../inputs/BME680-par-h7.csv", indexForCalibrationParameters, &par_h7);
	}
	else if (!strcmp(modeString, "OnlyCalibrationParameterP2AsDistribution"))
	{
		loadNthFloatFromPath("../inputs/BME680-par-t1.csv", indexForCalibrationParameters, &par_t1);
		loadNthFloatFromPath("../inputs/BME680-par-t2.csv", indexForCalibrationParameters, &par_t2);
		loadNthFloatFromPath("../inputs/BME680-par-t3.csv", indexForCalibrationParameters, &par_t3);

		loadNthFloatFromPath("../inputs/BME680-par-p1.csv", indexForCalibrationParameters, &par_p1);
		loadFloatDistFromPath("../inputs/BME680-par-p2.csv", kWarpDataBME680CalibrationConstantSetCount, &par_p2);
		loadNthFloatFromPath("../inputs/BME680-par-p3.csv", indexForCalibrationParameters, &par_p3);
		loadNthFloatFromPath("../inputs/BME680-par-p4.csv", indexForCalibrationParameters, &par_p4);
		loadNthFloatFromPath("../inputs/BME680-par-p5.csv", indexForCalibrationParameters, &par_p5);
		loadNthFloatFromPath("../inputs/BME680-par-p6.csv", indexForCalibrationParameters, &par_p6);
		loadNthFloatFromPath("../inputs/BME680-par-p7.csv", indexForCalibrationParameters, &par_p7);
		loadNthFloatFromPath("../inputs/BME680-par-p8.csv", indexForCalibrationParameters, &par_p8);
		loadNthFloatFromPath("../inputs/BME680-par-p9.csv", indexForCalibrationParameters, &par_p9);
		loadNthFloatFromPath("../inputs/BME680-par-p10.csv", indexForCalibrationParameters, &par_p10);

		loadNthFloatFromPath("../inputs/BME680-par-h1.csv", indexForCalibrationParameters, &par_h1);
		loadNthFloatFromPath("../inputs/BME680-par-h2.csv", indexForCalibrationParameters, &par_h2);
		loadNthFloatFromPath("../inputs/BME680-par-h3.csv", indexForCalibrationParameters, &par_h3);
		loadNthFloatFromPath("../inputs/BME680-par-h4.csv", indexForCalibrationParameters, &par_h4);
		loadNthFloatFromPath("../inputs/BME680-par-h5.csv", indexForCalibrationParameters, &par_h5);
		loadNthFloatFromPath("../inputs/BME680-par-h6.csv", indexForCalibrationParameters, &par_h6);
		loadNthFloatFromPath("../inputs/BME680-par-h7.csv", indexForCalibrationParameters, &par_h7);
	}
	else if (!strcmp(modeString, "OnlyCalibrationParameterP3AsDistribution"))
	{
		loadNthFloatFromPath("../inputs/BME680-par-t1.csv", indexForCalibrationParameters, &par_t1);
		loadNthFloatFromPath("../inputs/BME680-par-t2.csv", indexForCalibrationParameters, &par_t2);
		loadNthFloatFromPath("../inputs/BME680-par-t3.csv", indexForCalibrationParameters, &par_t3);

		loadNthFloatFromPath("../inputs/BME680-par-p1.csv", indexForCalibrationParameters, &par_p1);
		loadNthFloatFromPath("../inputs/BME680-par-p2.csv", indexForCalibrationParameters, &par_p2);
		loadFloatDistFromPath("../inputs/BME680-par-p3.csv", kWarpDataBME680CalibrationConstantSetCount, &par_p3);
		loadNthFloatFromPath("../inputs/BME680-par-p4.csv", indexForCalibrationParameters, &par_p4);
		loadNthFloatFromPath("../inputs/BME680-par-p5.csv", indexForCalibrationParameters, &par_p5);
		loadNthFloatFromPath("../inputs/BME680-par-p6.csv", indexForCalibrationParameters, &par_p6);
		loadNthFloatFromPath("../inputs/BME680-par-p7.csv", indexForCalibrationParameters, &par_p7);
		loadNthFloatFromPath("../inputs/BME680-par-p8.csv", indexForCalibrationParameters, &par_p8);
		loadNthFloatFromPath("../inputs/BME680-par-p9.csv", indexForCalibrationParameters, &par_p9);
		loadNthFloatFromPath("../inputs/BME680-par-p10.csv", indexForCalibrationParameters, &par_p10);

		loadNthFloatFromPath("../inputs/BME680-par-h1.csv", indexForCalibrationParameters, &par_h1);
		loadNthFloatFromPath("../inputs/BME680-par-h2.csv", indexForCalibrationParameters, &par_h2);
		loadNthFloatFromPath("../inputs/BME680-par-h3.csv", indexForCalibrationParameters, &par_h3);
		loadNthFloatFromPath("../inputs/BME680-par-h4.csv", indexForCalibrationParameters, &par_h4);
		loadNthFloatFromPath("../inputs/BME680-par-h5.csv", indexForCalibrationParameters, &par_h5);
		loadNthFloatFromPath("../inputs/BME680-par-h6.csv", indexForCalibrationParameters, &par_h6);
		loadNthFloatFromPath("../inputs/BME680-par-h7.csv", indexForCalibrationParameters, &par_h7);
	}
	else if (!strcmp(modeString, "OnlyCalibrationParameterP4AsDistribution"))
	{
		loadNthFloatFromPath("../inputs/BME680-par-t1.csv", indexForCalibrationParameters, &par_t1);
		loadNthFloatFromPath("../inputs/BME680-par-t2.csv", indexForCalibrationParameters, &par_t2);
		loadNthFloatFromPath("../inputs/BME680-par-t3.csv", indexForCalibrationParameters, &par_t3);

		loadNthFloatFromPath("../inputs/BME680-par-p1.csv", indexForCalibrationParameters, &par_p1);
		loadNthFloatFromPath("../inputs/BME680-par-p2.csv", indexForCalibrationParameters, &par_p2);
		loadNthFloatFromPath("../inputs/BME680-par-p3.csv", indexForCalibrationParameters, &par_p3);
		loadFloatDistFromPath("../inputs/BME680-par-p4.csv", kWarpDataBME680CalibrationConstantSetCount, &par_p4);
		loadNthFloatFromPath("../inputs/BME680-par-p5.csv", indexForCalibrationParameters, &par_p5);
		loadNthFloatFromPath("../inputs/BME680-par-p6.csv", indexForCalibrationParameters, &par_p6);
		loadNthFloatFromPath("../inputs/BME680-par-p7.csv", indexForCalibrationParameters, &par_p7);
		loadNthFloatFromPath("../inputs/BME680-par-p8.csv", indexForCalibrationParameters, &par_p8);
		loadNthFloatFromPath("../inputs/BME680-par-p9.csv", indexForCalibrationParameters, &par_p9);
		loadNthFloatFromPath("../inputs/BME680-par-p10.csv", indexForCalibrationParameters, &par_p10);

		loadNthFloatFromPath("../inputs/BME680-par-h1.csv", indexForCalibrationParameters, &par_h1);
		loadNthFloatFromPath("../inputs/BME680-par-h2.csv", indexForCalibrationParameters, &par_h2);
		loadNthFloatFromPath("../inputs/BME680-par-h3.csv", indexForCalibrationParameters, &par_h3);
		loadNthFloatFromPath("../inputs/BME680-par-h4.csv", indexForCalibrationParameters, &par_h4);
		loadNthFloatFromPath("../inputs/BME680-par-h5.csv", indexForCalibrationParameters, &par_h5);
		loadNthFloatFromPath("../inputs/BME680-par-h6.csv", indexForCalibrationParameters, &par_h6);
		loadNthFloatFromPath("../inputs/BME680-par-h7.csv", indexForCalibrationParameters, &par_h7);
	}
	else if (!strcmp(modeString, "OnlyCalibrationParameterP5AsDistribution"))
	{
		loadNthFloatFromPath("../inputs/BME680-par-t1.csv", indexForCalibrationParameters, &par_t1);
		loadNthFloatFromPath("../inputs/BME680-par-t2.csv", indexForCalibrationParameters, &par_t2);
		loadNthFloatFromPath("../inputs/BME680-par-t3.csv", indexForCalibrationParameters, &par_t3);

		loadNthFloatFromPath("../inputs/BME680-par-p1.csv", indexForCalibrationParameters, &par_p1);
		loadNthFloatFromPath("../inputs/BME680-par-p2.csv", indexForCalibrationParameters, &par_p2);
		loadNthFloatFromPath("../inputs/BME680-par-p3.csv", indexForCalibrationParameters, &par_p3);
		loadNthFloatFromPath("../inputs/BME680-par-p4.csv", indexForCalibrationParameters, &par_p4);
		loadFloatDistFromPath("../inputs/BME680-par-p5.csv", kWarpDataBME680CalibrationConstantSetCount, &par_p5);
		loadNthFloatFromPath("../inputs/BME680-par-p6.csv", indexForCalibrationParameters, &par_p6);
		loadNthFloatFromPath("../inputs/BME680-par-p7.csv", indexForCalibrationParameters, &par_p7);
		loadNthFloatFromPath("../inputs/BME680-par-p8.csv", indexForCalibrationParameters, &par_p8);
		loadNthFloatFromPath("../inputs/BME680-par-p9.csv", indexForCalibrationParameters, &par_p9);
		loadNthFloatFromPath("../inputs/BME680-par-p10.csv", indexForCalibrationParameters, &par_p10);

		loadNthFloatFromPath("../inputs/BME680-par-h1.csv", indexForCalibrationParameters, &par_h1);
		loadNthFloatFromPath("../inputs/BME680-par-h2.csv", indexForCalibrationParameters, &par_h2);
		loadNthFloatFromPath("../inputs/BME680-par-h3.csv", indexForCalibrationParameters, &par_h3);
		loadNthFloatFromPath("../inputs/BME680-par-h4.csv", indexForCalibrationParameters, &par_h4);
		loadNthFloatFromPath("../inputs/BME680-par-h5.csv", indexForCalibrationParameters, &par_h5);
		loadNthFloatFromPath("../inputs/BME680-par-h6.csv", indexForCalibrationParameters, &par_h6);
		loadNthFloatFromPath("../inputs/BME680-par-h7.csv", indexForCalibrationParameters, &par_h7);
	}
	else if (!strcmp(modeString, "OnlyCalibrationParameterP6AsDistribution"))
	{
		loadNthFloatFromPath("../inputs/BME680-par-t1.csv", indexForCalibrationParameters, &par_t1);
		loadNthFloatFromPath("../inputs/BME680-par-t2.csv", indexForCalibrationParameters, &par_t2);
		loadNthFloatFromPath("../inputs/BME680-par-t3.csv", indexForCalibrationParameters, &par_t3);

		loadNthFloatFromPath("../inputs/BME680-par-p1.csv", indexForCalibrationParameters, &par_p1);
		loadNthFloatFromPath("../inputs/BME680-par-p2.csv", indexForCalibrationParameters, &par_p2);
		loadNthFloatFromPath("../inputs/BME680-par-p3.csv", indexForCalibrationParameters, &par_p3);
		loadNthFloatFromPath("../inputs/BME680-par-p4.csv", indexForCalibrationParameters, &par_p4);
		loadNthFloatFromPath("../inputs/BME680-par-p5.csv", indexForCalibrationParameters, &par_p5);
		loadFloatDistFromPath("../inputs/BME680-par-p6.csv", kWarpDataBME680CalibrationConstantSetCount, &par_p6);
		loadNthFloatFromPath("../inputs/BME680-par-p7.csv", indexForCalibrationParameters, &par_p7);
		loadNthFloatFromPath("../inputs/BME680-par-p8.csv", indexForCalibrationParameters, &par_p8);
		loadNthFloatFromPath("../inputs/BME680-par-p9.csv", indexForCalibrationParameters, &par_p9);
		loadNthFloatFromPath("../inputs/BME680-par-p10.csv", indexForCalibrationParameters, &par_p10);

		loadNthFloatFromPath("../inputs/BME680-par-h1.csv", indexForCalibrationParameters, &par_h1);
		loadNthFloatFromPath("../inputs/BME680-par-h2.csv", indexForCalibrationParameters, &par_h2);
		loadNthFloatFromPath("../inputs/BME680-par-h3.csv", indexForCalibrationParameters, &par_h3);
		loadNthFloatFromPath("../inputs/BME680-par-h4.csv", indexForCalibrationParameters, &par_h4);
		loadNthFloatFromPath("../inputs/BME680-par-h5.csv", indexForCalibrationParameters, &par_h5);
		loadNthFloatFromPath("../inputs/BME680-par-h6.csv", indexForCalibrationParameters, &par_h6);
		loadNthFloatFromPath("../inputs/BME680-par-h7.csv", indexForCalibrationParameters, &par_h7);
	}
	else if (!strcmp(modeString, "OnlyCalibrationParameterP7AsDistribution"))
	{
		loadNthFloatFromPath("../inputs/BME680-par-t1.csv", indexForCalibrationParameters, &par_t1);
		loadNthFloatFromPath("../inputs/BME680-par-t2.csv", indexForCalibrationParameters, &par_t2);
		loadNthFloatFromPath("../inputs/BME680-par-t3.csv", indexForCalibrationParameters, &par_t3);

		loadNthFloatFromPath("../inputs/BME680-par-p1.csv", indexForCalibrationParameters, &par_p1);
		loadNthFloatFromPath("../inputs/BME680-par-p2.csv", indexForCalibrationParameters, &par_p2);
		loadNthFloatFromPath("../inputs/BME680-par-p3.csv", indexForCalibrationParameters, &par_p3);
		loadNthFloatFromPath("../inputs/BME680-par-p4.csv", indexForCalibrationParameters, &par_p4);
		loadNthFloatFromPath("../inputs/BME680-par-p5.csv", indexForCalibrationParameters, &par_p5);
		loadNthFloatFromPath("../inputs/BME680-par-p6.csv", indexForCalibrationParameters, &par_p6);
		loadFloatDistFromPath("../inputs/BME680-par-p7.csv", kWarpDataBME680CalibrationConstantSetCount, &par_p7);
		loadNthFloatFromPath("../inputs/BME680-par-p8.csv", indexForCalibrationParameters, &par_p8);
		loadNthFloatFromPath("../inputs/BME680-par-p9.csv", indexForCalibrationParameters, &par_p9);
		loadNthFloatFromPath("../inputs/BME680-par-p10.csv", indexForCalibrationParameters, &par_p10);

		loadNthFloatFromPath("../inputs/BME680-par-h1.csv", indexForCalibrationParameters, &par_h1);
		loadNthFloatFromPath("../inputs/BME680-par-h2.csv", indexForCalibrationParameters, &par_h2);
		loadNthFloatFromPath("../inputs/BME680-par-h3.csv", indexForCalibrationParameters, &par_h3);
		loadNthFloatFromPath("../inputs/BME680-par-h4.csv", indexForCalibrationParameters, &par_h4);
		loadNthFloatFromPath("../inputs/BME680-par-h5.csv", indexForCalibrationParameters, &par_h5);
		loadNthFloatFromPath("../inputs/BME680-par-h6.csv", indexForCalibrationParameters, &par_h6);
		loadNthFloatFromPath("../inputs/BME680-par-h7.csv", indexForCalibrationParameters, &par_h7);
	}
	else if (!strcmp(modeString, "OnlyCalibrationParameterP8AsDistribution"))
	{
		loadNthFloatFromPath("../inputs/BME680-par-t1.csv", indexForCalibrationParameters, &par_t1);
		loadNthFloatFromPath("../inputs/BME680-par-t2.csv", indexForCalibrationParameters, &par_t2);
		loadNthFloatFromPath("../inputs/BME680-par-t3.csv", indexForCalibrationParameters, &par_t3);

		loadNthFloatFromPath("../inputs/BME680-par-p1.csv", indexForCalibrationParameters, &par_p1);
		loadNthFloatFromPath("../inputs/BME680-par-p2.csv", indexForCalibrationParameters, &par_p2);
		loadNthFloatFromPath("../inputs/BME680-par-p3.csv", indexForCalibrationParameters, &par_p3);
		loadNthFloatFromPath("../inputs/BME680-par-p4.csv", indexForCalibrationParameters, &par_p4);
		loadNthFloatFromPath("../inputs/BME680-par-p5.csv", indexForCalibrationParameters, &par_p5);
		loadNthFloatFromPath("../inputs/BME680-par-p6.csv", indexForCalibrationParameters, &par_p6);
		loadNthFloatFromPath("../inputs/BME680-par-p7.csv", indexForCalibrationParameters, &par_p7);
		loadFloatDistFromPath("../inputs/BME680-par-p8.csv", kWarpDataBME680CalibrationConstantSetCount, &par_p8);
		loadNthFloatFromPath("../inputs/BME680-par-p9.csv", indexForCalibrationParameters, &par_p9);
		loadNthFloatFromPath("../inputs/BME680-par-p10.csv", indexForCalibrationParameters, &par_p10);

		loadNthFloatFromPath("../inputs/BME680-par-h1.csv", indexForCalibrationParameters, &par_h1);
		loadNthFloatFromPath("../inputs/BME680-par-h2.csv", indexForCalibrationParameters, &par_h2);
		loadNthFloatFromPath("../inputs/BME680-par-h3.csv", indexForCalibrationParameters, &par_h3);
		loadNthFloatFromPath("../inputs/BME680-par-h4.csv", indexForCalibrationParameters, &par_h4);
		loadNthFloatFromPath("../inputs/BME680-par-h5.csv", indexForCalibrationParameters, &par_h5);
		loadNthFloatFromPath("../inputs/BME680-par-h6.csv", indexForCalibrationParameters, &par_h6);
		loadNthFloatFromPath("../inputs/BME680-par-h7.csv", indexForCalibrationParameters, &par_h7);
	}
	else if (!strcmp(modeString, "OnlyCalibrationParameterP9AsDistribution"))
	{
		loadNthFloatFromPath("../inputs/BME680-par-t1.csv", indexForCalibrationParameters, &par_t1);
		loadNthFloatFromPath("../inputs/BME680-par-t2.csv", indexForCalibrationParameters, &par_t2);
		loadNthFloatFromPath("../inputs/BME680-par-t3.csv", indexForCalibrationParameters, &par_t3);

		loadNthFloatFromPath("../inputs/BME680-par-p1.csv", indexForCalibrationParameters, &par_p1);
		loadNthFloatFromPath("../inputs/BME680-par-p2.csv", indexForCalibrationParameters, &par_p2);
		loadNthFloatFromPath("../inputs/BME680-par-p3.csv", indexForCalibrationParameters, &par_p3);
		loadNthFloatFromPath("../inputs/BME680-par-p4.csv", indexForCalibrationParameters, &par_p4);
		loadNthFloatFromPath("../inputs/BME680-par-p5.csv", indexForCalibrationParameters, &par_p5);
		loadNthFloatFromPath("../inputs/BME680-par-p6.csv", indexForCalibrationParameters, &par_p6);
		loadNthFloatFromPath("../inputs/BME680-par-p7.csv", indexForCalibrationParameters, &par_p7);
		loadNthFloatFromPath("../inputs/BME680-par-p8.csv", indexForCalibrationParameters, &par_p8);
		loadFloatDistFromPath("../inputs/BME680-par-p9.csv", kWarpDataBME680CalibrationConstantSetCount, &par_p9);
		loadNthFloatFromPath("../inputs/BME680-par-p10.csv", indexForCalibrationParameters, &par_p10);

		loadNthFloatFromPath("../inputs/BME680-par-h1.csv", indexForCalibrationParameters, &par_h1);
		loadNthFloatFromPath("../inputs/BME680-par-h2.csv", indexForCalibrationParameters, &par_h2);
		loadNthFloatFromPath("../inputs/BME680-par-h3.csv", indexForCalibrationParameters, &par_h3);
		loadNthFloatFromPath("../inputs/BME680-par-h4.csv", indexForCalibrationParameters, &par_h4);
		loadNthFloatFromPath("../inputs/BME680-par-h5.csv", indexForCalibrationParameters, &par_h5);
		loadNthFloatFromPath("../inputs/BME680-par-h6.csv", indexForCalibrationParameters, &par_h6);
		loadNthFloatFromPath("../inputs/BME680-par-h7.csv", indexForCalibrationParameters, &par_h7);
	}
	else if (!strcmp(modeString, "OnlyCalibrationParameterP10AsDistribution"))
	{
		loadNthFloatFromPath("../inputs/BME680-par-t1.csv", indexForCalibrationParameters, &par_t1);
		loadNthFloatFromPath("../inputs/BME680-par-t2.csv", indexForCalibrationParameters, &par_t2);
		loadNthFloatFromPath("../inputs/BME680-par-t3.csv", indexForCalibrationParameters, &par_t3);

		loadNthFloatFromPath("../inputs/BME680-par-p1.csv", indexForCalibrationParameters, &par_p1);
		loadNthFloatFromPath("../inputs/BME680-par-p2.csv", indexForCalibrationParameters, &par_p2);
		loadNthFloatFromPath("../inputs/BME680-par-p3.csv", indexForCalibrationParameters, &par_p3);
		loadNthFloatFromPath("../inputs/BME680-par-p4.csv", indexForCalibrationParameters, &par_p4);
		loadNthFloatFromPath("../inputs/BME680-par-p5.csv", indexForCalibrationParameters, &par_p5);
		loadNthFloatFromPath("../inputs/BME680-par-p6.csv", indexForCalibrationParameters, &par_p6);
		loadNthFloatFromPath("../inputs/BME680-par-p7.csv", indexForCalibrationParameters, &par_p7);
		loadNthFloatFromPath("../inputs/BME680-par-p8.csv", indexForCalibrationParameters, &par_p8);
		loadNthFloatFromPath("../inputs/BME680-par-p9.csv", indexForCalibrationParameters, &par_p9);
		loadFloatDistFromPath("../inputs/BME680-par-p10.csv", kWarpDataBME680CalibrationConstantSetCount, &par_p10);

		loadNthFloatFromPath("../inputs/BME680-par-h1.csv", indexForCalibrationParameters, &par_h1);
		loadNthFloatFromPath("../inputs/BME680-par-h2.csv", indexForCalibrationParameters, &par_h2);
		loadNthFloatFromPath("../inputs/BME680-par-h3.csv", indexForCalibrationParameters, &par_h3);
		loadNthFloatFromPath("../inputs/BME680-par-h4.csv", indexForCalibrationParameters, &par_h4);
		loadNthFloatFromPath("../inputs/BME680-par-h5.csv", indexForCalibrationParameters, &par_h5);
		loadNthFloatFromPath("../inputs/BME680-par-h6.csv", indexForCalibrationParameters, &par_h6);
		loadNthFloatFromPath("../inputs/BME680-par-h7.csv", indexForCalibrationParameters, &par_h7);
	}
	else if (!strcmp(modeString, "OnlyCalibrationParameterH1AsDistribution"))
	{
		loadNthFloatFromPath("../inputs/BME680-par-t1.csv", indexForCalibrationParameters, &par_t1);
		loadNthFloatFromPath("../inputs/BME680-par-t2.csv", indexForCalibrationParameters, &par_t2);
		loadNthFloatFromPath("../inputs/BME680-par-t3.csv", indexForCalibrationParameters, &par_t3);

		loadNthFloatFromPath("../inputs/BME680-par-p1.csv", indexForCalibrationParameters, &par_p1);
		loadNthFloatFromPath("../inputs/BME680-par-p2.csv", indexForCalibrationParameters, &par_p2);
		loadNthFloatFromPath("../inputs/BME680-par-p3.csv", indexForCalibrationParameters, &par_p3);
		loadNthFloatFromPath("../inputs/BME680-par-p4.csv", indexForCalibrationParameters, &par_p4);
		loadNthFloatFromPath("../inputs/BME680-par-p5.csv", indexForCalibrationParameters, &par_p5);
		loadNthFloatFromPath("../inputs/BME680-par-p6.csv", indexForCalibrationParameters, &par_p6);
		loadNthFloatFromPath("../inputs/BME680-par-p7.csv", indexForCalibrationParameters, &par_p7);
		loadNthFloatFromPath("../inputs/BME680-par-p8.csv", indexForCalibrationParameters, &par_p8);
		loadNthFloatFromPath("../inputs/BME680-par-p9.csv", indexForCalibrationParameters, &par_p9);
		loadNthFloatFromPath("../inputs/BME680-par-p10.csv", indexForCalibrationParameters, &par_p10);

		loadFloatDistFromPath("../inputs/BME680-par-h1.csv", kWarpDataBME680CalibrationConstantSetCount, &par_h1);
		loadNthFloatFromPath("../inputs/BME680-par-h2.csv", indexForCalibrationParameters, &par_h2);
		loadNthFloatFromPath("../inputs/BME680-par-h3.csv", indexForCalibrationParameters, &par_h3);
		loadNthFloatFromPath("../inputs/BME680-par-h4.csv", indexForCalibrationParameters, &par_h4);
		loadNthFloatFromPath("../inputs/BME680-par-h5.csv", indexForCalibrationParameters, &par_h5);
		loadNthFloatFromPath("../inputs/BME680-par-h6.csv", indexForCalibrationParameters, &par_h6);
		loadNthFloatFromPath("../inputs/BME680-par-h7.csv", indexForCalibrationParameters, &par_h7);
	}
	else if (!strcmp(modeString, "OnlyCalibrationParameterH2AsDistribution"))
	{
		loadNthFloatFromPath("../inputs/BME680-par-t1.csv", indexForCalibrationParameters, &par_t1);
		loadNthFloatFromPath("../inputs/BME680-par-t2.csv", indexForCalibrationParameters, &par_t2);
		loadNthFloatFromPath("../inputs/BME680-par-t3.csv", indexForCalibrationParameters, &par_t3);

		loadNthFloatFromPath("../inputs/BME680-par-p1.csv", indexForCalibrationParameters, &par_p1);
		loadNthFloatFromPath("../inputs/BME680-par-p2.csv", indexForCalibrationParameters, &par_p2);
		loadNthFloatFromPath("../inputs/BME680-par-p3.csv", indexForCalibrationParameters, &par_p3);
		loadNthFloatFromPath("../inputs/BME680-par-p4.csv", indexForCalibrationParameters, &par_p4);
		loadNthFloatFromPath("../inputs/BME680-par-p5.csv", indexForCalibrationParameters, &par_p5);
		loadNthFloatFromPath("../inputs/BME680-par-p6.csv", indexForCalibrationParameters, &par_p6);
		loadNthFloatFromPath("../inputs/BME680-par-p7.csv", indexForCalibrationParameters, &par_p7);
		loadNthFloatFromPath("../inputs/BME680-par-p8.csv", indexForCalibrationParameters, &par_p8);
		loadNthFloatFromPath("../inputs/BME680-par-p9.csv", indexForCalibrationParameters, &par_p9);
		loadNthFloatFromPath("../inputs/BME680-par-p10.csv", indexForCalibrationParameters, &par_p10);

		loadNthFloatFromPath("../inputs/BME680-par-h1.csv", indexForCalibrationParameters, &par_h1);
		loadFloatDistFromPath("../inputs/BME680-par-h2.csv", kWarpDataBME680CalibrationConstantSetCount, &par_h2);
		loadNthFloatFromPath("../inputs/BME680-par-h3.csv", indexForCalibrationParameters, &par_h3);
		loadNthFloatFromPath("../inputs/BME680-par-h4.csv", indexForCalibrationParameters, &par_h4);
		loadNthFloatFromPath("../inputs/BME680-par-h5.csv", indexForCalibrationParameters, &par_h5);
		loadNthFloatFromPath("../inputs/BME680-par-h6.csv", indexForCalibrationParameters, &par_h6);
		loadNthFloatFromPath("../inputs/BME680-par-h7.csv", indexForCalibrationParameters, &par_h7);
	}
	else if (!strcmp(modeString, "OnlyCalibrationParameterH3AsDistribution"))
	{
		loadNthFloatFromPath("../inputs/BME680-par-t1.csv", indexForCalibrationParameters, &par_t1);
		loadNthFloatFromPath("../inputs/BME680-par-t2.csv", indexForCalibrationParameters, &par_t2);
		loadNthFloatFromPath("../inputs/BME680-par-t3.csv", indexForCalibrationParameters, &par_t3);

		loadNthFloatFromPath("../inputs/BME680-par-p1.csv", indexForCalibrationParameters, &par_p1);
		loadNthFloatFromPath("../inputs/BME680-par-p2.csv", indexForCalibrationParameters, &par_p2);
		loadNthFloatFromPath("../inputs/BME680-par-p3.csv", indexForCalibrationParameters, &par_p3);
		loadNthFloatFromPath("../inputs/BME680-par-p4.csv", indexForCalibrationParameters, &par_p4);
		loadNthFloatFromPath("../inputs/BME680-par-p5.csv", indexForCalibrationParameters, &par_p5);
		loadNthFloatFromPath("../inputs/BME680-par-p6.csv", indexForCalibrationParameters, &par_p6);
		loadNthFloatFromPath("../inputs/BME680-par-p7.csv", indexForCalibrationParameters, &par_p7);
		loadNthFloatFromPath("../inputs/BME680-par-p8.csv", indexForCalibrationParameters, &par_p8);
		loadNthFloatFromPath("../inputs/BME680-par-p9.csv", indexForCalibrationParameters, &par_p9);
		loadNthFloatFromPath("../inputs/BME680-par-p10.csv", indexForCalibrationParameters, &par_p10);

		loadNthFloatFromPath("../inputs/BME680-par-h1.csv", indexForCalibrationParameters, &par_h1);
		loadNthFloatFromPath("../inputs/BME680-par-h2.csv", indexForCalibrationParameters, &par_h2);
		loadFloatDistFromPath("../inputs/BME680-par-h3.csv", kWarpDataBME680CalibrationConstantSetCount, &par_h3);
		loadNthFloatFromPath("../inputs/BME680-par-h4.csv", indexForCalibrationParameters, &par_h4);
		loadNthFloatFromPath("../inputs/BME680-par-h5.csv", indexForCalibrationParameters, &par_h5);
		loadNthFloatFromPath("../inputs/BME680-par-h6.csv", indexForCalibrationParameters, &par_h6);
		loadNthFloatFromPath("../inputs/BME680-par-h7.csv", indexForCalibrationParameters, &par_h7);
	}
	else if (!strcmp(modeString, "OnlyCalibrationParameterH4AsDistribution"))
	{
		loadNthFloatFromPath("../inputs/BME680-par-t1.csv", indexForCalibrationParameters, &par_t1);
		loadNthFloatFromPath("../inputs/BME680-par-t2.csv", indexForCalibrationParameters, &par_t2);
		loadNthFloatFromPath("../inputs/BME680-par-t3.csv", indexForCalibrationParameters, &par_t3);

		loadNthFloatFromPath("../inputs/BME680-par-p1.csv", indexForCalibrationParameters, &par_p1);
		loadNthFloatFromPath("../inputs/BME680-par-p2.csv", indexForCalibrationParameters, &par_p2);
		loadNthFloatFromPath("../inputs/BME680-par-p3.csv", indexForCalibrationParameters, &par_p3);
		loadNthFloatFromPath("../inputs/BME680-par-p4.csv", indexForCalibrationParameters, &par_p4);
		loadNthFloatFromPath("../inputs/BME680-par-p5.csv", indexForCalibrationParameters, &par_p5);
		loadNthFloatFromPath("../inputs/BME680-par-p6.csv", indexForCalibrationParameters, &par_p6);
		loadNthFloatFromPath("../inputs/BME680-par-p7.csv", indexForCalibrationParameters, &par_p7);
		loadNthFloatFromPath("../inputs/BME680-par-p8.csv", indexForCalibrationParameters, &par_p8);
		loadNthFloatFromPath("../inputs/BME680-par-p9.csv", indexForCalibrationParameters, &par_p9);
		loadNthFloatFromPath("../inputs/BME680-par-p10.csv", indexForCalibrationParameters, &par_p10);

		loadNthFloatFromPath("../inputs/BME680-par-h1.csv", indexForCalibrationParameters, &par_h1);
		loadNthFloatFromPath("../inputs/BME680-par-h2.csv", indexForCalibrationParameters, &par_h2);
		loadNthFloatFromPath("../inputs/BME680-par-h3.csv", indexForCalibrationParameters, &par_h3);
		loadFloatDistFromPath("../inputs/BME680-par-h4.csv", kWarpDataBME680CalibrationConstantSetCount, &par_h4);
		loadNthFloatFromPath("../inputs/BME680-par-h5.csv", indexForCalibrationParameters, &par_h5);
		loadNthFloatFromPath("../inputs/BME680-par-h6.csv", indexForCalibrationParameters, &par_h6);
		loadNthFloatFromPath("../inputs/BME680-par-h7.csv", indexForCalibrationParameters, &par_h7);
	}
	else if (!strcmp(modeString, "OnlyCalibrationParameterH5AsDistribution"))
	{
		loadNthFloatFromPath("../inputs/BME680-par-t1.csv", indexForCalibrationParameters, &par_t1);
		loadNthFloatFromPath("../inputs/BME680-par-t2.csv", indexForCalibrationParameters, &par_t2);
		loadNthFloatFromPath("../inputs/BME680-par-t3.csv", indexForCalibrationParameters, &par_t3);

		loadNthFloatFromPath("../inputs/BME680-par-p1.csv", indexForCalibrationParameters, &par_p1);
		loadNthFloatFromPath("../inputs/BME680-par-p2.csv", indexForCalibrationParameters, &par_p2);
		loadNthFloatFromPath("../inputs/BME680-par-p3.csv", indexForCalibrationParameters, &par_p3);
		loadNthFloatFromPath("../inputs/BME680-par-p4.csv", indexForCalibrationParameters, &par_p4);
		loadNthFloatFromPath("../inputs/BME680-par-p5.csv", indexForCalibrationParameters, &par_p5);
		loadNthFloatFromPath("../inputs/BME680-par-p6.csv", indexForCalibrationParameters, &par_p6);
		loadNthFloatFromPath("../inputs/BME680-par-p7.csv", indexForCalibrationParameters, &par_p7);
		loadNthFloatFromPath("../inputs/BME680-par-p8.csv", indexForCalibrationParameters, &par_p8);
		loadNthFloatFromPath("../inputs/BME680-par-p9.csv", indexForCalibrationParameters, &par_p9);
		loadNthFloatFromPath("../inputs/BME680-par-p10.csv", indexForCalibrationParameters, &par_p10);

		loadNthFloatFromPath("../inputs/BME680-par-h1.csv", indexForCalibrationParameters, &par_h1);
		loadNthFloatFromPath("../inputs/BME680-par-h2.csv", indexForCalibrationParameters, &par_h2);
		loadNthFloatFromPath("../inputs/BME680-par-h3.csv", indexForCalibrationParameters, &par_h3);
		loadNthFloatFromPath("../inputs/BME680-par-h4.csv", indexForCalibrationParameters, &par_h4);
		loadFloatDistFromPath("../inputs/BME680-par-h5.csv", kWarpDataBME680CalibrationConstantSetCount, &par_h5);
		loadNthFloatFromPath("../inputs/BME680-par-h6.csv", indexForCalibrationParameters, &par_h6);
		loadNthFloatFromPath("../inputs/BME680-par-h7.csv", indexForCalibrationParameters, &par_h7);
	}
	else if (!strcmp(modeString, "OnlyCalibrationParameterH6AsDistribution"))
	{
		loadNthFloatFromPath("../inputs/BME680-par-t1.csv", indexForCalibrationParameters, &par_t1);
		loadNthFloatFromPath("../inputs/BME680-par-t2.csv", indexForCalibrationParameters, &par_t2);
		loadNthFloatFromPath("../inputs/BME680-par-t3.csv", indexForCalibrationParameters, &par_t3);

		loadNthFloatFromPath("../inputs/BME680-par-p1.csv", indexForCalibrationParameters, &par_p1);
		loadNthFloatFromPath("../inputs/BME680-par-p2.csv", indexForCalibrationParameters, &par_p2);
		loadNthFloatFromPath("../inputs/BME680-par-p3.csv", indexForCalibrationParameters, &par_p3);
		loadNthFloatFromPath("../inputs/BME680-par-p4.csv", indexForCalibrationParameters, &par_p4);
		loadNthFloatFromPath("../inputs/BME680-par-p5.csv", indexForCalibrationParameters, &par_p5);
		loadNthFloatFromPath("../inputs/BME680-par-p6.csv", indexForCalibrationParameters, &par_p6);
		loadNthFloatFromPath("../inputs/BME680-par-p7.csv", indexForCalibrationParameters, &par_p7);
		loadNthFloatFromPath("../inputs/BME680-par-p8.csv", indexForCalibrationParameters, &par_p8);
		loadNthFloatFromPath("../inputs/BME680-par-p9.csv", indexForCalibrationParameters, &par_p9);
		loadNthFloatFromPath("../inputs/BME680-par-p10.csv", indexForCalibrationParameters, &par_p10);

		loadNthFloatFromPath("../inputs/BME680-par-h1.csv", indexForCalibrationParameters, &par_h1);
		loadNthFloatFromPath("../inputs/BME680-par-h2.csv", indexForCalibrationParameters, &par_h2);
		loadNthFloatFromPath("../inputs/BME680-par-h3.csv", indexForCalibrationParameters, &par_h3);
		loadNthFloatFromPath("../inputs/BME680-par-h4.csv", indexForCalibrationParameters, &par_h4);
		loadNthFloatFromPath("../inputs/BME680-par-h5.csv", indexForCalibrationParameters, &par_h5);
		loadFloatDistFromPath("../inputs/BME680-par-h6.csv", kWarpDataBME680CalibrationConstantSetCount, &par_h6);
		loadNthFloatFromPath("../inputs/BME680-par-h7.csv", indexForCalibrationParameters, &par_h7);
	}
	else if (!strcmp(modeString, "OnlyCalibrationParameterH7AsDistribution"))
	{
		loadNthFloatFromPath("../inputs/BME680-par-t1.csv", indexForCalibrationParameters, &par_t1);
		loadNthFloatFromPath("../inputs/BME680-par-t2.csv", indexForCalibrationParameters, &par_t2);
		loadNthFloatFromPath("../inputs/BME680-par-t3.csv", indexForCalibrationParameters, &par_t3);

		loadNthFloatFromPath("../inputs/BME680-par-p1.csv", indexForCalibrationParameters, &par_p1);
		loadNthFloatFromPath("../inputs/BME680-par-p2.csv", indexForCalibrationParameters, &par_p2);
		loadNthFloatFromPath("../inputs/BME680-par-p3.csv", indexForCalibrationParameters, &par_p3);
		loadNthFloatFromPath("../inputs/BME680-par-p4.csv", indexForCalibrationParameters, &par_p4);
		loadNthFloatFromPath("../inputs/BME680-par-p5.csv", indexForCalibrationParameters, &par_p5);
		loadNthFloatFromPath("../inputs/BME680-par-p6.csv", indexForCalibrationParameters, &par_p6);
		loadNthFloatFromPath("../inputs/BME680-par-p7.csv", indexForCalibrationParameters, &par_p7);
		loadNthFloatFromPath("../inputs/BME680-par-p8.csv", indexForCalibrationParameters, &par_p8);
		loadNthFloatFromPath("../inputs/BME680-par-p9.csv", indexForCalibrationParameters, &par_p9);
		loadNthFloatFromPath("../inputs/BME680-par-p10.csv", indexForCalibrationParameters, &par_p10);

		loadNthFloatFromPath("../inputs/BME680-par-h1.csv", indexForCalibrationParameters, &par_h1);
		loadNthFloatFromPath("../inputs/BME680-par-h2.csv", indexForCalibrationParameters, &par_h2);
		loadNthFloatFromPath("../inputs/BME680-par-h3.csv", indexForCalibrationParameters, &par_h3);
		loadNthFloatFromPath("../inputs/BME680-par-h4.csv", indexForCalibrationParameters, &par_h4);
		loadNthFloatFromPath("../inputs/BME680-par-h5.csv", indexForCalibrationParameters, &par_h5);
		loadNthFloatFromPath("../inputs/BME680-par-h6.csv", indexForCalibrationParameters, &par_h6);
		loadFloatDistFromPath("../inputs/BME680-par-h7.csv", kWarpDataBME680CalibrationConstantSetCount, &par_h7);
	}
	else
	{
		usage();
	}

	snprintf(filename, kWarpDataBME680MaxPathNameLength, "%s-temperature-adc-trace.csv", pathPrefix);
	loadFloatDistFromPath(filename, kWarpDataBME680DatastreamLength, &temperatureRawADC);
	printf("Mean temperature raw ADC value for [%s] as percentage of full 20-bit range: %f\n", filename, 100*temperatureRawADC/(1 << 20));
	libUncertainFloatPrint(100*temperatureRawADC/(1 << 20));

	snprintf(filename, kWarpDataBME680MaxPathNameLength, "%s-pressure-adc-trace.csv", pathPrefix);
	loadFloatDistFromPath(filename, kWarpDataBME680DatastreamLength, &pressureRawADC);
	printf("Mean pressure raw ADC value for [%s] as percentage of full 20-bit range: %f\n", filename, 100*pressureRawADC/(1 << 20));
	libUncertainFloatPrint(100*pressureRawADC/(1 << 20));


	snprintf(filename, kWarpDataBME680MaxPathNameLength, "%s-humidity-adc-trace.csv", pathPrefix);
	loadFloatDistFromPath(filename, kWarpDataBME680DatastreamLength, &humidityRawADC);
	printf("Mean humidity raw ADC value for [%s] as percentage of full 16-bit range: %f\n", filename, 100*humidityRawADC/(1 << 16));
	libUncertainFloatPrint(100*humidityRawADC/(1 << 16));

	temperature	= calc_temperature(temperatureRawADC, par_t1, par_t2, par_t3);
	pressure	= calc_pressure(pressureRawADC, temperature, par_p1, par_p2, par_p3, par_p4, par_p5, par_p6, par_p7, par_p8, par_p9, par_p10);
	humidity	= calc_humidity(humidityRawADC, temperature, par_h1, par_h2, par_h3, par_h4, par_h5, par_h6, par_h7);

	printf("Mean temperature (converted) for [%s]= %f Celcius\n", filename, temperature);
	libUncertainFloatPrint(temperature);

	printf("Mean pressure (converted) for [%s]= %f kPa\n", filename, pressure/1000);
	libUncertainFloatPrint(pressure/1000);

	printf("Mean humidity (converted) for [%s]= %f%%\n", filename, humidity);
	libUncertainFloatPrint(humidity);

	return 0;
}

void
loadFloatDistFromPath(const char *  filename, int sampleCount, float *  returnValue)
{
	FILE *		fp;
	float *		samples;

	fp = fopen(filename, "r");
	if (fp == NULL)
	{
		perror("error: could not open input file");
		exit(EXIT_FAILURE);
	}

	printf("Number of samples from %s: %d\n", filename, sampleCount);

	samples = malloc(sampleCount * sizeof(float));
	if (samples == NULL)
	{
		perror("error: could not allocate memory for samples");
		exit(EXIT_FAILURE);
	}
	for (int i = 0; i < sampleCount; i++)
	{
		fscanf(fp, "%f\n", &samples[i]);
	}

	*returnValue = libUncertainFloatDistFromSamples(samples, sampleCount);
	
	if (fclose(fp) != 0)
	{
		perror("warning: could not close input file");
	}
	free(samples);

	return;
}

void
loadNthFloatFromPath(const char *  filename, uint64_t which, float *  returnValue)
{
	FILE *		fp;

	fp = fopen(filename, "r");
	if (fp == NULL)
	{
		perror("error: could not open input file");
		exit(EXIT_FAILURE);
	}

	printf("Index of sample from %s: %" PRIu64 "\n", filename, which);

	for (int i = 0; i <= which; i++)
	{
		fscanf(fp, "%f\n", returnValue);
	}
	printf("Sample [%" PRIu64 "] from %s: is [%f]\n", which, filename, *returnValue);

	return;
}

void
usage(void)
{
	fprintf(stderr, "Usage: bme680-conversion-routines <path prefix for input files (e.g., \"../inputs/warp-board-002\")> <index for calibration parameters (e.g., '0' to use those for Warp revB 002)> <mode (e.g., 'allCalibrationParametersAsDistributions')\n");

	exit(EXIT_FAILURE);
}
