#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include "bme680_defs.h"
#define BME680_CONCAT_THREE_BYTES(msb, lsb, xlsb)    (((uint16_t)msb << 12) | (uint16_t)lsb << 4 | ((uint16_t)xlsb && 0XF0) >> 4)
#define BME680_CONCAT_BYTES(msb, lsb)	(((uint16_t)msb << 8) | (uint16_t)lsb)
uint16_t 	coeff_array[BME680_COEFF_SIZE] = { 0 };

uint32_t 
getP(int offset)
{
	uint32_t 	P = 0;
   	uint16_t 	MSB = 0;
   	uint16_t 	LSB = 0;
   	uint16_t	XLSB = 0;
   	FILE 		*fp;
   	char 		buff[255];
   	char 		*ptr;
   	fp = fopen("ExampleHex.csv", "r");
   	for(int i = 0; i < (398 + (offset*195) ); i++)
   	{
        	fscanf(fp, "%s", buff);
   	}	
   	fscanf(fp, "%s", buff);
   	MSB = strtoul(buff,&ptr,16);
   	fscanf(fp, "%s", buff);
  	LSB = strtoul(buff,&ptr,16);
   
	fscanf(fp, "%s", buff);
   	XLSB = strtoul(buff,&ptr,16);
	fclose(fp);
   	P = BME680_CONCAT_THREE_BYTES(MSB, LSB, XLSB);

	return P;
}

uint32_t 
getH(int offset)
{
	uint32_t	H = 0;
   	uint16_t	MSB = 0;
   	uint16_t	LSB = 0;
   	FILE 		* fp;
   	char 		buff[255];
   	char 		* ptr;
   	fp = fopen("ExampleHex.csv", "r");
   	for(int i = 0; i < (404 + (offset*195) ); i++)
   	{
        	fscanf(fp, "%s", buff);
   	}
   	fscanf(fp, "%s", buff);
   	MSB = strtoul(buff,&ptr,16);

   	fscanf(fp, "%s", buff);
   	LSB = strtoul(buff,&ptr,16);
	fclose(fp);
   	H = BME680_CONCAT_BYTES(MSB, LSB);

   	return H;
}

uint32_t 
getT(int offset)
{
	uint32_t 	T = 0;
   	uint16_t 	MSB = 0;
   	uint16_t 	LSB = 0;
   	uint16_t 	XLSB = 0;
   	FILE 		* fp;
   	char 		buff[255];
   	char 		* ptr;
   	fp = fopen("ExampleHex.csv", "r");
   	for(int i = 0; i < (401 + (offset*195) ); i++)
   	{
        	fscanf(fp, "%s", buff);
	}
   	fscanf(fp, "%s", buff);
   	MSB = strtoul(buff,&ptr,16);
   	fscanf(fp, "%s", buff);
   	LSB = strtoul(buff,&ptr,16);
   	fscanf(fp, "%s", buff);
   	XLSB = strtoul(buff,&ptr,16);
	fclose(fp);
    	T = BME680_CONCAT_THREE_BYTES(MSB, LSB, XLSB);

   	return T;
}

void
parseCSV()
{
	FILE 	* fp;
   	char 	buff[255];//creating char array to store data of file
   	char 	* ptr;
   	fp = fopen("ExampleHex.csv", "r");
   	for(int i=0 ; i < 204 ; i++)
   	{
        	fscanf(fp, "%s", buff);
   	}

	for(int i=0 ; i < BME680_COEFF_SIZE ; i++)
	{
    		fscanf(fp, "%s", buff);
    		coeff_array[i] = strtoul(buff,&ptr,16);
	}
   	fclose(fp);
}


int 
main ()
{
	int 	kN = 900;
	FILE 	* fp;
	int 	i;
	/* open the file for writing*/
	fp = fopen ("T.txt","w");

	for(i = 0; i < kN;i++)
   	{
     		fprintf (fp, "%u\n",getT(i)) ;
   	}

   	/* close the file*/
   	fclose (fp);

   	fp = fopen("P.txt","w");
   	for(i = 0; i < kN; i++)
   	{
     		fprintf(fp, "%u\n",getP(i));
   	}
   	fclose(fp);

  	fp = fopen("H.txt","w");
  	for(i = 0; i < kN; i++)
  	{
     		fprintf(fp, "%u\n",getH(i));
  	}
  	fclose(fp);

  	parseCSV();

  	/* Temperature related coefficients */
	uint16_t	par_t1 = (uint16_t) (BME680_CONCAT_BYTES(coeff_array[BME680_T1_MSB_REG], coeff_array[BME680_T1_LSB_REG]));
	int16_t		par_t2 = (int16_t) (BME680_CONCAT_BYTES(coeff_array[BME680_T2_MSB_REG], coeff_array[BME680_T2_LSB_REG]));
	int8_t		par_t3 = (int8_t) (coeff_array[BME680_T3_REG]);

	/* Pressure related coefficients */
	uint16_t 	par_p1 = (uint16_t) (BME680_CONCAT_BYTES(coeff_array[BME680_P1_MSB_REG], coeff_array[BME680_P1_LSB_REG]));
	int16_t 	par_p2 = (int16_t) (BME680_CONCAT_BYTES(coeff_array[BME680_P2_MSB_REG], coeff_array[BME680_P2_LSB_REG]));
	int8_t 		par_p3 = (int8_t) coeff_array[BME680_P3_REG];
	int16_t 	par_p4 = (int16_t) (BME680_CONCAT_BYTES(coeff_array[BME680_P4_MSB_REG], coeff_array[BME680_P4_LSB_REG]));
	int16_t 	par_p5 = (int16_t) (BME680_CONCAT_BYTES(coeff_array[BME680_P5_MSB_REG], coeff_array[BME680_P5_LSB_REG]));
	int8_t 		par_p6 = (int8_t) (coeff_array[BME680_P6_REG]);
	int8_t 		par_p7 = (int8_t) (coeff_array[BME680_P7_REG]);
	int16_t 	par_p8 = (int16_t) (BME680_CONCAT_BYTES(coeff_array[BME680_P8_MSB_REG], coeff_array[BME680_P8_LSB_REG]));
	int16_t		par_p9 = (int16_t) (BME680_CONCAT_BYTES(coeff_array[BME680_P9_MSB_REG], coeff_array[BME680_P9_LSB_REG]));
	uint8_t 	par_p10 = (uint8_t) (coeff_array[BME680_P10_REG]);

	/* Humidity related coefficients */
	uint16_t 	par_h1 = (uint16_t) (((uint16_t) coeff_array[BME680_H1_MSB_REG] << BME680_HUM_REG_SHIFT_VAL) | (coeff_array[BME680_H1_LSB_REG] & BME680_BIT_H1_DATA_MSK));
	uint16_t 	par_h2 = (uint16_t) (((uint16_t) coeff_array[BME680_H2_MSB_REG] << BME680_HUM_REG_SHIFT_VAL) | ((coeff_array[BME680_H2_LSB_REG]) >> BME680_HUM_REG_SHIFT_VAL));
	int8_t 		par_h3 = (int8_t) coeff_array[BME680_H3_REG];
	int8_t 		par_h4 = (int8_t) coeff_array[BME680_H4_REG];
	int8_t 		par_h5 = (int8_t) coeff_array[BME680_H5_REG];
	uint8_t 	par_h6 = (uint8_t) coeff_array[BME680_H6_REG];
	int8_t 		par_h7 = (int8_t) coeff_array[BME680_H7_REG];

 	fp = fopen("TemperatureCalibration.txt","w");
  	fprintf(fp, "%u\n", par_t1);
  	fprintf(fp, "%d\n", par_t2);
  	fprintf(fp, "%d\n", par_t3);
  	fclose(fp);

  	fp = fopen("PressureCalibration.txt","w");
  	fprintf(fp, "%u\n", par_p1);
  	fprintf(fp, "%d\n", par_p2);
  	fprintf(fp, "%d\n", par_p3);
  	fprintf(fp, "%d\n", par_p4);
  	fprintf(fp, "%d\n", par_p5);
  	fprintf(fp, "%d\n", par_p6);
  	fprintf(fp, "%d\n", par_p7);
  	fprintf(fp, "%d\n", par_p8);
  	fprintf(fp, "%d\n", par_p9);
  	fprintf(fp, "%u\n", par_p10);
  	fclose(fp);

  	fp = fopen("HumidityCalibration.txt","w");
  	fprintf(fp, "%u\n", par_h1);
  	fprintf(fp, "%u\n", par_h2);
  	fprintf(fp, "%d\n", par_h3);
  	fprintf(fp, "%d\n", par_h4);
  	fprintf(fp, "%d\n", par_h5);
  	fprintf(fp, "%u\n", par_h6);
  	fprintf(fp, "%d\n", par_h7);
  	fclose(fp);
	
	return 0;
}
