#include <math.h>
#include <stdio.h>
#include <uncertain.h>

int main(int argc, char* argv[])
{
    float E_vals[] = { 0, 1 };
    float alpha = 0;
    float mu_0 = M_PI_2;
    float sigma_0 = 0.5;

    float M = 1 / pow(sigma_0, alpha);
    float theta = mu_0 - sigma_0;

    // Likelihood
    double Phi = libUncertainDoubleGaussDist(mu_0, sigma_0);
    // double Phi = libUncertainDoubleUniformDist(-M_PI,M_PI);
    // double Phi = libUncertainDoubleExponentialDist(M_PI_2);

    printf("Phi : %lf\n", Phi);
    libUncertainDoublePrint(Phi);

    // Prior - I think this tried to emulate the output of the quantum circuit
    // [0.9387912809451864, 0.06120871905481362] from Phi = mu_0
    double E = libUncertainDoubleBernoulliDist(0.061208719);
    printf("E : %lf\n", E);
    libUncertainDoublePrint(E);

    // Posterior
    double Phi_E = E * Phi;

    printf("Phi_E : %lf\n", Phi_E);
    libUncertainDoublePrint(Phi_E);
}
