# Accelerated Variational Quantum Eigensolver
Implementation of the Quantum Phase Estimation (QPE) subroutine of the
Accelerated Variational Quantum Eigensolver based on this paper [1].

[1] J. R. Cruise, N. I. Gillespie, and B. Reid, “Practical Quantum Computing: The value of local computation,” arXiv:2009.08513 [quant-ph], Sep. 2020, Accessed: Apr. 07, 2021. [Online]. Available: http://arxiv.org/abs/2009.08513

## Overview
This quantum algorithm calculates ground states of a quantum system Hamiltonian,
H. This benchmark tries to find the quantum state ψ(k) that minimizes
\<ψ(k)|H|ψ(k)\>. Typically, this uses rejection sampling to calculate P(φ|E)
from measurements of P(E|φ) from a quantum phase estimation (QPE) circuit.
## Inputs
The input is part of the source code of the benchmark.
## Output
An estimate of the quantum state ψ(k) that minimizes \<ψ(k)|H|ψ(k)\>. The
benchmark result is in an SQLite3 database (`.db` file).
## Notes
None.
