#!/bin/env bash
source ../fpbench-generate-inputs.conf

#	herbie input directories
mkdir -p $FPBENCH_DIR/herbie/inputs/gaussian/
mkdir -p $FPBENCH_DIR/herbie/inputs/test/
mkdir -p $FPBENCH_DIR/herbie/inputs/laplace/
mkdir -p $FPBENCH_DIR/herbie/inputs/uniform/


$GENERATOR --out $FPBENCH_DIR/herbie/inputs/gaussian/input-ex0-re.txt --samples $SAMPLES Gauss 10.0 1.0
$GENERATOR --out $FPBENCH_DIR/herbie/inputs/test/input-ex0-re.txt --samples 100 Gauss 10.0 1.0
$GENERATOR --out $FPBENCH_DIR/herbie/inputs/laplace/input-ex0-re.txt --samples $SAMPLES  Laplace 10.0 0.7071067811865475
$GENERATOR --out $FPBENCH_DIR/herbie/inputs/uniform/input-ex0-re.txt --samples $SAMPLES  Uniform 8 12
$GENERATOR --out $FPBENCH_DIR/herbie/inputs/gaussian/input-ex0-im.txt --samples $SAMPLES Gauss 10.0 1.0
$GENERATOR --out $FPBENCH_DIR/herbie/inputs/test/input-ex0-im.txt --samples 100 Gauss 10.0 1.0
$GENERATOR --out $FPBENCH_DIR/herbie/inputs/laplace/input-ex0-im.txt --samples $SAMPLES  Laplace 10.0 0.7071067811865475
$GENERATOR --out $FPBENCH_DIR/herbie/inputs/uniform/input-ex0-im.txt --samples $SAMPLES  Uniform 8 12


$GENERATOR --out $FPBENCH_DIR/herbie/inputs/gaussian/input-ex1-re.txt --samples $SAMPLES Gauss 10.0 1.0
$GENERATOR --out $FPBENCH_DIR/herbie/inputs/test/input-ex1-re.txt --samples 100 Gauss 10.0 1.0
$GENERATOR --out $FPBENCH_DIR/herbie/inputs/laplace/input-ex1-re.txt --samples $SAMPLES  Laplace 10.0 0.7071067811865475
$GENERATOR --out $FPBENCH_DIR/herbie/inputs/uniform/input-ex1-re.txt --samples $SAMPLES  Uniform 8 12
$GENERATOR --out $FPBENCH_DIR/herbie/inputs/gaussian/input-ex1-im.txt --samples $SAMPLES Gauss 2.0 0.5
$GENERATOR --out $FPBENCH_DIR/herbie/inputs/test/input-ex1-im.txt --samples 100 Gauss 2.0 0.5
$GENERATOR --out $FPBENCH_DIR/herbie/inputs/laplace/input-ex1-im.txt --samples $SAMPLES  Laplace 2.0 0.35355339059327373
$GENERATOR --out $FPBENCH_DIR/herbie/inputs/uniform/input-ex1-im.txt --samples $SAMPLES  Uniform 1 3


$GENERATOR --out $FPBENCH_DIR/herbie/inputs/gaussian/input-ex2-cp.txt --samples $SAMPLES Gauss 5.0 0.5
$GENERATOR --out $FPBENCH_DIR/herbie/inputs/test/input-ex2-cp.txt --samples 100 Gauss 5.0 0.5
$GENERATOR --out $FPBENCH_DIR/herbie/inputs/laplace/input-ex2-cp.txt --samples $SAMPLES  Laplace 5.0 0.35355339059327373
$GENERATOR --out $FPBENCH_DIR/herbie/inputs/uniform/input-ex2-cp.txt --samples $SAMPLES  Uniform 4 6
$GENERATOR --out $FPBENCH_DIR/herbie/inputs/gaussian/input-ex2-cn.txt --samples $SAMPLES Gauss 5.0 0.5
$GENERATOR --out $FPBENCH_DIR/herbie/inputs/test/input-ex2-cn.txt --samples 100 Gauss 5.0 0.5
$GENERATOR --out $FPBENCH_DIR/herbie/inputs/laplace/input-ex2-cn.txt --samples $SAMPLES  Laplace 5.0 0.35355339059327373
$GENERATOR --out $FPBENCH_DIR/herbie/inputs/uniform/input-ex2-cn.txt --samples $SAMPLES  Uniform 4 6
$GENERATOR --out $FPBENCH_DIR/herbie/inputs/gaussian/input-ex2-t.txt --samples $SAMPLES Gauss 5.0 0.5
$GENERATOR --out $FPBENCH_DIR/herbie/inputs/test/input-ex2-t.txt --samples 100 Gauss 5.0 0.5
$GENERATOR --out $FPBENCH_DIR/herbie/inputs/laplace/input-ex2-t.txt --samples $SAMPLES  Laplace 5.0 0.35355339059327373
$GENERATOR --out $FPBENCH_DIR/herbie/inputs/uniform/input-ex2-t.txt --samples $SAMPLES  Uniform 4 6
$GENERATOR --out $FPBENCH_DIR/herbie/inputs/gaussian/input-ex2-s.txt --samples $SAMPLES Gauss 5.0 0.5
$GENERATOR --out $FPBENCH_DIR/herbie/inputs/test/input-ex2-s.txt --samples 100 Gauss 5.0 0.5
$GENERATOR --out $FPBENCH_DIR/herbie/inputs/laplace/input-ex2-s.txt --samples $SAMPLES  Laplace 5.0 0.35355339059327373
$GENERATOR --out $FPBENCH_DIR/herbie/inputs/uniform/input-ex2-s.txt --samples $SAMPLES  Uniform 4 6
# Stats:
# {'benches': 1, 'exes': 3, 'params': 8, 'closed-range': 8, 'open-range': 0, 'exclusion-condition': 0, 'no-condition': 0, 'extra-conditions': 0}
