/*
	Authored 2021, Orestis Kaparounakis.

	All rights reserved.

	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:

	*	Redistributions of source code must retain the above
		copyright notice, this list of conditions and the following
		disclaimer.

	*	Redistributions in binary form must reproduce the above
		copyright notice, this list of conditions and the following
		disclaimer in the documentation and/or other materials
		provided with the distribution.

	*	Neither the name of the author nor the names of its
		contributors may be used to endorse or promote products
		derived from this software without specific prior written
		permission.

	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
	"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
	LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
	FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
	COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
	BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
	CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
	LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
	ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
	POSSIBILITY OF SUCH DAMAGE.
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <uncertain.h>

#include "herbie.h"

enum {
	kBenchmarkFunctionCount 	= 3, 
	kBenchmarkMaxArgumentCount 	= 4,
};

double	loadDoubleDistFromPath(double *  var, const char *  filename);
void	usage();

int
main(int argc, char *  argv[])
{
	int32_t	mode = 0;

	double	ex[kBenchmarkFunctionCount];
	double	in[kBenchmarkFunctionCount][kBenchmarkMaxArgumentCount];
	/*
	 *	Can't use this because it triggers the correlation mechanism.
	 */
	// double	in[kBenchmarkMaxArgumentCount];

	if (argc != 1)
	{
		usage();
		exit(EXIT_FAILURE);
	}

	/*
	 *	Load samples into distributional double variables and call
	 *	benchmark functions.
	 */
	loadDoubleDistFromPath(&in[0][0], "input-ex0-re.txt");
	loadDoubleDistFromPath(&in[0][1], "input-ex0-im.txt");
	ex[0] = ex0(in[0][0], in[0][1]);
	printf("ex0 = %lf\n", ex[0]);
	libUncertainDoublePrint(ex[0]);

	loadDoubleDistFromPath(&in[1][0], "input-ex1-re.txt");
	loadDoubleDistFromPath(&in[1][1], "input-ex1-im.txt");
	ex[1] = ex1(in[1][0], in[1][1]);
	printf("ex1 = %lf\n", ex[1]);
	libUncertainDoublePrint(ex[1]);

	loadDoubleDistFromPath(&in[2][0], "input-ex2-cp.txt");
	loadDoubleDistFromPath(&in[2][1], "input-ex2-cn.txt");
	loadDoubleDistFromPath(&in[2][2], "input-ex2-s.txt");
	loadDoubleDistFromPath(&in[2][3], "input-ex2-t.txt");
	ex[2] = ex2(in[2][0], in[2][1], in[2][2], in[2][3]);
	printf("ex2 = %lf\n", ex[2]);
	libUncertainDoublePrint(ex[2]);

	return 0;
}

double
loadDoubleDistFromPath(double *  var, const char *  filename)
{
	FILE *		inp;
	int		sampleCount;
	double *	samples;
	double		returnValue;

	inp = fopen(filename, "r");
	if (inp == NULL)
	{
		perror("error: could not open input file");
		exit(EXIT_FAILURE);
	}
	fscanf(inp, "%d\n", &sampleCount);

	printf("Number of samples from %s: %d\n", filename, sampleCount);

	samples = malloc(sampleCount * sizeof(double));
	if (samples == NULL)
	{
		perror("error: could not allocate memory for samples");
		exit(EXIT_FAILURE);
	}
	for (int i = 0; i < sampleCount; i++)
	{
		fscanf(inp, "%lf\n", &samples[i]);
	}
	if (var == NULL )
		returnValue = libUncertainDoubleDistFromSamples(samples, sampleCount);
	else
		(*var) = libUncertainDoubleDistFromSamples(samples, sampleCount);

	if (fclose(inp) != 0)
	{
		perror("warning: could not close input file");
	}
	free(samples);

	return returnValue;
}

void
usage(void)
{
	fprintf(stderr, "Usage: main\nInputs loaded from working directory.\nSee run.m for more information.\n");
}
