# The `FPbench` Benchmarks

## Overview
This benchmark is actually a collection of the following benchmarks: `rosa`,
`daisy`, `rump`, `salsa`, `herbie`, `precimonious`, `hamming-ch3`,
`fptaylor-tests`, `fptaylor-real2float`, and `fptaylor-extra`. This benchmark
collection is called [FPBench](http://fpbench.org/) and _"contains 98 benchmarks from four sources
(FPTaylor, Herbie, Salsa, and Rosa) covering a variety of application domains
and the full complement of FPCore features"_.

The benchmarks were converted to C from Racket using the commands in the _Notes_
section.

## Inputs
FPBench does not provide an input dataset for the benchmarks.

We create our own dataset consulting the benchmark preconditions. We create 3
input dataset types. One with Laplace input distributions, one with Uniform
distributions, and two with Gaussian input distribution. The first three
datasets contain 5000 samples for each random variable. The last dataset (the
second Gaussian) contains 100 samples for each random variable and we use it for
testing purposes only. 

<!-- Stats:
{'benches': 10, 'exes': 128, 'params': 347, 'closed-range': 249, 
'open-range': 10, 'exclusion-condition': 9, 'no-condition': 79} -->
The 10 benchmarks contain in total 128 benchmark functions with a total of 347
parameters. For each input dataset type, we generate 347 input datasets, one for
each parameter to represent an empirical random variable. We load these
variables using the libUncertain API. Each input dataset (except the `test`
ones) contains 5000 samples.

### How we choose the distribution parameters
Of the 347 parameters (or random variables), the 251 specify a closed range for
the domain of the input (precondition or fpbench-precondition-override). For
example, `rosa`'s `ex0` specifies a range of [-100, 100] for parameter `u`. From
the rest, 8 specify an open range condition (e.g., `herbie` `ex2` `cp`), 9
specify one or more exclusion conditions (e.g., `hamming-ch3` `ex2` `x` and
`hamming-ch3` `ex7` `x`), and 79 specify no conditions.

When a parameter specifies a closed range condition we compute the sample
generator distribution parameters such that the mean of the samples falls on the
midpoint of the range. For the Uniform dataset type, we use the bounds of the
closed range as the distribution parameters (typically `a` and `b`). For the
Gaussian and Laplace dataset type, we compute the samples' distribution
parameters **such that** the mean of the samples minus standard deviation
multiplied by a factor is the lower bound of the range and the mean of the
samples plus standard deviation multiplied by a factor is the upper bound of the
range, or:
```
	lower_bound  ==  mean - factor*stdev
	upper_bound  ==  mean + factor*stdev
```

When a parameter specifies an open range condition, specifies one or more
exclusion conditions, or no conditions at all. We use the mean of the parameters
for all other parameters in this benchmark kernel. If that's not possible, we
use the mean of all other parameters in this benchmark suite. If that's also not
possible, we use a mean of `15.0` and standard deviation of `3.0` as the default
fallback parameters.

22 benchmark functions specify that a relationship **between the parameters**
must also hold(e.g., `rosa` `ex20`). We have not ensured that these extra
relationships hold in our analysis as it would then have been too cumbersome to
generate the datasets.
## Outputs
Each benchmark specifies its own outputs. Generally, the results are in SQLite3
databases.

## Notes
Converting the `fpcore` format benchmarks to C:
```shell
racket FPBench/export.rkt FPBench/benchmarks/rump.fpcore rump/benchmark/rump.c
racket FPBench/export.rkt FPBench/benchmarks/fptaylor-extra.fpcore fptaylor-extra/benchmark/fptaylor-extra.c
racket FPBench/export.rkt FPBench/benchmarks/fptaylor-real2float.fpcore fptaylor-real2float/benchmark/fptaylor-real2float.c
racket FPBench/export.rkt FPBench/benchmarks/fptaylor-tests.fpcore fptaylor-tests/benchmark/fptaylor-tests.c
racket FPBench/export.rkt FPBench/benchmarks/hamming-ch3.fpcore hamming-ch3/benchmark/hamming-ch3.c
racket FPBench/export.rkt FPBench/benchmarks/herbie.fpcore herbie/benchmark/herbie.c
racket FPBench/export.rkt FPBench/benchmarks/precimonious.fpcore precimonious/benchmark/precimonious.c
racket FPBench/export.rkt FPBench/benchmarks/rosa.fpcore rosa/benchmark/rosa.c
racket FPBench/export.rkt FPBench/benchmarks/rump.fpcore rump/benchmark/rump.c
racket FPBench/export.rkt FPBench/benchmarks/salsa.fpcore salsa/benchmark/salsa.c
# To generate the header files:
racket FPBench/export.rkt FPBench/benchmarks/rump.fpcore rump/benchmark/rump.h
racket FPBench/export.rkt FPBench/benchmarks/fptaylor-extra.fpcore fptaylor-extra/benchmark/fptaylor-extra.h
racket FPBench/export.rkt FPBench/benchmarks/fptaylor-real2float.fpcore fptaylor-real2float/benchmark/fptaylor-real2float.h
racket FPBench/export.rkt FPBench/benchmarks/fptaylor-tests.fpcore fptaylor-tests/benchmark/fptaylor-tests.h
racket FPBench/export.rkt FPBench/benchmarks/hamming-ch3.fpcore hamming-ch3/benchmark/hamming-ch3.h
racket FPBench/export.rkt FPBench/benchmarks/herbie.fpcore herbie/benchmark/herbie.h
racket FPBench/export.rkt FPBench/benchmarks/precimonious.fpcore precimonious/benchmark/precimonious.h
racket FPBench/export.rkt FPBench/benchmarks/rosa.fpcore rosa/benchmark/rosa.h
racket FPBench/export.rkt FPBench/benchmarks/rump.fpcore rump/benchmark/rump.h
racket FPBench/export.rkt FPBench/benchmarks/salsa.fpcore salsa/benchmark/salsa.h
```
