(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     13762,        352]
NotebookOptionsPosition[     11924,        318]
NotebookOutlinePosition[     12321,        334]
CellTagsIndexPosition[     12278,        331]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", 
    RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"distFromRange", "[", 
    RowBox[{"range_", ",", " ", "count_"}], "]"}], " ", ":=", " ", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"RandomVariate", "[", 
      RowBox[{
       RowBox[{"NormalDistribution", "[", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"range", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "+", 
           RowBox[{"range", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "2"], ",", " ", 
         FractionBox[
          RowBox[{
           RowBox[{"range", "[", 
            RowBox[{"[", "2", "]"}], "]"}], "-", 
           RowBox[{"range", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], "6"]}], "]"}], ",", "count"}], 
      "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}]}], "Code",
 CellChangeTimes->{{3.828011994488634*^9, 
  3.828011996441146*^9}},ExpressionUUID->"5ec9e88d-71a9-4b69-9974-\
2b541ba09b9d"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"gammaData", " ", "=", " ", 
   RowBox[{"RandomVariate", "[", 
    RowBox[{
     RowBox[{"UniformDistribution", "[", 
      RowBox[{"{", 
       RowBox[{"0.15", ",", " ", "0.25"}], "}"}], "]"}], ",", "1000"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{
   "\"\<gamma.csv\>\"", ",", " ", "gammaData", ",", " ", "\"\<List\>\""}], 
   "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.8278304036365128`*^9, 3.827830463422324*^9}, {
  3.8278306078347883`*^9, 3.827830663961101*^9}, {3.828011113125852*^9, 
  3.828011113526979*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"52897640-238f-4267-b08c-31d0618f55e1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"phiData", " ", "=", " ", 
   RowBox[{"RandomVariate", "[", 
    RowBox[{
     RowBox[{"UniformDistribution", "[", 
      RowBox[{"{", 
       RowBox[{"0.3", ",", " ", "0.45"}], "}"}], "]"}], ",", "1000"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<phi.csv\>\"", ",", " ", "phiData", ",", " ", "\"\<List\>\""}],
    "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.8278304036365128`*^9, 3.827830463422324*^9}, {
   3.8278306078347883`*^9, 3.827830663961101*^9}, {3.827830719636119*^9, 
   3.827830735568928*^9}, 3.8280111113119507`*^9},
 CellLabel->"In[12]:=",ExpressionUUID->"17573fe6-ccd8-43fd-add1-d14fbb4ed3c5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"RsData", " ", "=", " ", 
   RowBox[{"RandomVariate", "[", 
    RowBox[{
     RowBox[{"UniformDistribution", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", " ", 
         SuperscriptBox["10", 
          RowBox[{"-", "8"}]]}], ",", 
        RowBox[{"3", " ", 
         SuperscriptBox["10", 
          RowBox[{"-", "8"}]]}]}], "}"}], "]"}], ",", "1000"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<Rs.csv\>\"", ",", " ", "RsData", ",", " ", "\"\<List\>\""}], 
   "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.8278304036365128`*^9, 3.827830463422324*^9}, {
   3.8278306078347883`*^9, 3.827830663961101*^9}, {3.827830719636119*^9, 
   3.827830735568928*^9}, {3.827831219503189*^9, 3.827831256110811*^9}, 
   3.8278313198829308`*^9},
 CellLabel->"In[16]:=",ExpressionUUID->"169918bf-d0ba-42e6-91a2-5372d68f47f3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"GData", " ", "=", " ", 
   RowBox[{"RandomVariate", "[", 
    RowBox[{
     RowBox[{"UniformDistribution", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"6", " ", 
         SuperscriptBox["10", "10"]}], ",", 
        RowBox[{"8", " ", 
         SuperscriptBox["10", "10"]}]}], "}"}], "]"}], ",", "1000"}], "]"}]}],
   ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<G.csv\>\"", ",", " ", "GData", ",", " ", "\"\<List\>\""}], 
   "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.8278304036365128`*^9, 3.827830463422324*^9}, {
  3.8278306078347883`*^9, 3.827830663961101*^9}, {3.827830719636119*^9, 
  3.827830735568928*^9}, {3.827831219503189*^9, 3.8278313135979233`*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"efda337a-f26b-4b7c-b6c6-3badb7773ad5"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"bData", " ", "=", " ", 
   RowBox[{"RandomVariate", "[", 
    RowBox[{
     RowBox[{"UniformDistribution", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"2.54", " ", 
         SuperscriptBox["10", 
          RowBox[{"-", "10"}]]}], ",", 
        RowBox[{"2.54", " ", 
         SuperscriptBox["10", 
          RowBox[{"-", "10"}]]}]}], "}"}], "]"}], ",", "1000"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<b.csv\>\"", ",", " ", "bData", ",", " ", "\"\<List\>\""}], 
   "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.8278304036365128`*^9, 3.827830463422324*^9}, {
  3.8278306078347883`*^9, 3.827830663961101*^9}, {3.827830719636119*^9, 
  3.827830735568928*^9}, {3.827831219503189*^9, 3.8278313135979233`*^9}, {
  3.8278313522778473`*^9, 3.8278313890730133`*^9}, {3.827986627349444*^9, 
  3.827986631725973*^9}},
 CellLabel->
  "In[154]:=",ExpressionUUID->"1700bb84-4e38-4d56-b217-64e21aa410b1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"MData", " ", "=", " ", 
   RowBox[{"RandomVariate", "[", 
    RowBox[{
     RowBox[{"UniformDistribution", "[", 
      RowBox[{"{", 
       RowBox[{"2.9", ",", "3.2"}], "}"}], "]"}], ",", "1000"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<M.csv\>\"", ",", " ", "MData", ",", " ", "\"\<List\>\""}], 
   "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.8278304036365128`*^9, 3.827830463422324*^9}, {
  3.8278306078347883`*^9, 3.827830663961101*^9}, {3.827830719636119*^9, 
  3.827830735568928*^9}, {3.827831219503189*^9, 3.8278313135979233`*^9}, {
  3.8278313522778473`*^9, 3.8278314170849257`*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"9d04cf6c-0296-469c-bfca-4d1c40c8a54d"],

Cell[CellGroupData[{

Cell["\<\
Now, for all except b, which is constant, take the ranges, divide by 6 (since \
+/- 3sigma on either side of the mean is 99.7% confidence interval), and use \
that as the standard deviation for a gaussian centered at the midpoint of the \
range\
\>", "Text",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.82801096702085*^9, 3.828011084528408*^9}, {
   3.82801116158991*^9, 3.828011168303718*^9}, 3.8280119840245523`*^9},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"ea832045-27c6-47d5-9e05-45f8fa17050c"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"gammaGaussianData", " ", "=", " ", 
   RowBox[{"distFromRange", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.15", ",", " ", "0.25"}], "}"}], ",", "1000"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{
   "\"\<gammaGaussian.csv\>\"", ",", " ", "gammaGaussianData", ",", " ", 
    "\"\<List\>\""}], "]"}], ";"}]}], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.8278304036365128`*^9, 3.827830463422324*^9}, {
   3.8278306078347883`*^9, 3.827830663961101*^9}, {3.828011113125852*^9, 
   3.828011131301876*^9}, {3.82801117951709*^9, 3.828011188493973*^9}, {
   3.828011248633235*^9, 3.828011268122032*^9}, {3.828011359337022*^9, 
   3.82801136059324*^9}, 3.828011397851293*^9, 3.828011984025921*^9},
 CellLabel->
  "In[331]:=",ExpressionUUID->"78a92500-e445-42a6-af5f-9d331d763ef3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"phiGaussianData", " ", "=", " ", 
   RowBox[{"distFromRange", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.3", ",", " ", "0.45"}], "}"}], ",", "1000"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{
   "\"\<phiGaussian.csv\>\"", ",", " ", "phiGaussianData", ",", " ", 
    "\"\<List\>\""}], "]"}], ";"}]}], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.8278304036365128`*^9, 3.827830463422324*^9}, {
   3.8278306078347883`*^9, 3.827830663961101*^9}, {3.827830719636119*^9, 
   3.827830735568928*^9}, {3.8280111113119507`*^9, 3.8280111359224463`*^9}, {
   3.828011371185605*^9, 3.828011428697554*^9}, 3.8280119840260077`*^9},
 CellLabel->
  "In[333]:=",ExpressionUUID->"2644f365-395e-43af-96d1-fb88c8812138"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"RsGaussianData", " ", "=", " ", 
   RowBox[{"distFromRange", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", " ", 
        SuperscriptBox["10", 
         RowBox[{"-", "8"}]]}], ",", 
       RowBox[{"3", " ", 
        SuperscriptBox["10", 
         RowBox[{"-", "8"}]]}]}], "}"}], ",", "1000"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{
   "\"\<RsGaussian.csv\>\"", ",", " ", "RsGaussianData", ",", " ", 
    "\"\<List\>\""}], "]"}], ";"}]}], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.8278304036365128`*^9, 3.827830463422324*^9}, {
   3.8278306078347883`*^9, 3.827830663961101*^9}, {3.827830719636119*^9, 
   3.827830735568928*^9}, {3.827831219503189*^9, 3.827831256110811*^9}, 
   3.8278313198829308`*^9, 3.8280111376095247`*^9, {3.828011373435083*^9, 
   3.82801140399049*^9}, 3.828011438319408*^9, 3.828011984026107*^9},
 CellLabel->
  "In[335]:=",ExpressionUUID->"9276e620-1241-4a26-ad39-f7976d37024e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"GGaussianData", " ", "=", " ", 
   RowBox[{"distFromRange", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"6", " ", 
        SuperscriptBox["10", "10"]}], ",", 
       RowBox[{"8", " ", 
        SuperscriptBox["10", "10"]}]}], "}"}], ",", "1000"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{
   "\"\<GGaussian.csv\>\"", ",", " ", "GGaussianData", ",", " ", 
    "\"\<List\>\""}], "]"}], ";"}]}], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.8278304036365128`*^9, 3.827830463422324*^9}, {
   3.8278306078347883`*^9, 3.827830663961101*^9}, {3.827830719636119*^9, 
   3.827830735568928*^9}, {3.827831219503189*^9, 3.8278313135979233`*^9}, 
   3.8280111392972803`*^9, {3.8280113752681303`*^9, 3.828011407551044*^9}, 
   3.828011450268444*^9, 3.828011984026209*^9},
 CellLabel->
  "In[337]:=",ExpressionUUID->"e4e3f382-b9cd-422a-93b5-d6b9dea436c0"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"MGaussianData", " ", "=", " ", 
   RowBox[{"distFromRange", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.9", ",", "3.2"}], "}"}], ",", "1000"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{
   "\"\<MGaussian.csv\>\"", ",", " ", "MGaussianData", ",", " ", 
    "\"\<List\>\""}], "]"}], ";"}]}], "Input",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.},
 CellChangeTimes->{{3.8278304036365128`*^9, 3.827830463422324*^9}, {
   3.8278306078347883`*^9, 3.827830663961101*^9}, {3.827830719636119*^9, 
   3.827830735568928*^9}, {3.827831219503189*^9, 3.8278313135979233`*^9}, {
   3.8278313522778473`*^9, 3.8278314170849257`*^9}, 3.828011146348534*^9, {
   3.828011376401362*^9, 3.828011411461978*^9}, 3.8280114579487257`*^9, 
   3.828011984027337*^9},
 CellLabel->
  "In[339]:=",ExpressionUUID->"2ef23c17-d6d5-4075-b253-75228af5748f"]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{302, Automatic}, {Automatic, 5}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"6ca2103d-2483-4812-af7f-2bcb47a08c33"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 1119, 31, 159, "Code",ExpressionUUID->"5ec9e88d-71a9-4b69-9974-2b541ba09b9d"],
Cell[1680, 53, 688, 17, 52, "Input",ExpressionUUID->"52897640-238f-4267-b08c-31d0618f55e1"],
Cell[2371, 72, 703, 16, 52, "Input",ExpressionUUID->"17573fe6-ccd8-43fd-add1-d14fbb4ed3c5"],
Cell[3077, 90, 912, 23, 54, "Input",ExpressionUUID->"169918bf-d0ba-42e6-91a2-5372d68f47f3"],
Cell[3992, 115, 831, 20, 54, "Input",ExpressionUUID->"efda337a-f26b-4b7c-b6c6-3badb7773ad5"],
Cell[4826, 137, 995, 25, 54, "Input",ExpressionUUID->"1700bb84-4e38-4d56-b217-64e21aa410b1"],
Cell[5824, 164, 764, 17, 52, "Input",ExpressionUUID->"9d04cf6c-0296-469c-bfca-4d1c40c8a54d"],
Cell[CellGroupData[{
Cell[6613, 185, 557, 10, 97, "Text",ExpressionUUID->"ea832045-27c6-47d5-9e05-45f8fa17050c",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[7173, 197, 909, 20, 52, "Input",ExpressionUUID->"78a92500-e445-42a6-af5f-9d331d763ef3",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[8085, 219, 838, 19, 52, "Input",ExpressionUUID->"2644f365-395e-43af-96d1-fb88c8812138",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[8926, 240, 1060, 26, 54, "Input",ExpressionUUID->"9276e620-1241-4a26-ad39-f7976d37024e",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[9989, 268, 990, 24, 54, "Input",ExpressionUUID->"e4e3f382-b9cd-422a-93b5-d6b9dea436c0",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}],
Cell[10982, 294, 926, 21, 52, "Input",ExpressionUUID->"2ef23c17-d6d5-4075-b253-75228af5748f",
 CellGroupingRules->{"GroupTogetherGrouping", 10000.}]
}, Open  ]]
}
]
*)

