# Precipitate "cutting" dislocation model from Brown and Ham

## Overview
Models an equation for a materials precipitate "cutting" dislocation model from Brown and Ham [1]. The article [2] from Hector Basoalto's group has some empirical values for several of these distributions.

## Inputs
The inputs and their ranges are:
-	`gamma`:	0.15 to 0.25
-	`phi`:		0.30 to 0.45
-	`Rs`:		1 10^-8 to 3 10^-8
-	`G`:		6 10^10 to 8 10^10
-	`b`:		2.54 10^-9 to 2.54 10^-9 (i.e., constant)
-	`M`:		2.9 to 3.2.

The parameter `gamma` is the APB energy with units J/m^2, `phi` is the 
precipitate volume fraction, `Rs` is mean particle radius on plane with units m,
`G` is the shear modulus with units Pa, `b` is the magnitude of the Burgers
vector with units m, and `M` is the Taylor factor.

## Outputs
The output is the cutting stress, `sigmaC` where `sigmaC = (M*gamma/2.0*b)*(sqrt((8.0*gamma*phi*Rs)/(M_PI*G*pow(b, 2))) - phi)`.

## Evaluation Criteria
0. Run without uncertainty propagation enabled
1. Run with point-valued inputs but with uncertainty propagation enabled
2. Run with uncertainty propagation enabled, distributions overlaid on inputs, and verify that point-valued results match Evaluation 1, and record the distributions of all program result variables which depend on the inputs.
3. Taint analysis to give insight into dataflow in application. Represent taint analysis results as a matrix where each row is an input from which we track taint and each column is a variable in the program to which we want to see if taint propagates.

## Notes
[1] Brown, L. M., and R. K. Ham. "Dislocation-particle interactions." Strengthening methods in crystals (1971): 9-135.
[2] Anderson, M. J., F. Schulz, Y. Lu, H. S. Kitaguchi, P. Bowen, C. Argyrakis, and H. C. Basoalto. "On the modelling of precipitation kinetics in a turbine disc nickel based superalloy." Acta Materialia 191 (2020): 81-100.
